/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.plugin;

import java.util.Locale;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.wst.common.frameworks.internal.WTPPlugin;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.internal.DependencyIndex;
import org.eclipse.wst.validation.internal.EventManager;
import org.eclipse.wst.validation.internal.TimeEntry;
import org.eclipse.wst.validation.internal.ValOperationManager;
import org.eclipse.wst.validation.internal.core.Message;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ValidationPlugin
extends WTPPlugin {
    public static final String VALIDATION_PROP_FILE_NAME = "validate_base";
    public static final String PLUGIN_ID = "org.eclipse.wst.validation";
    private static ValidationPlugin _plugin;
    private static TimeEntry _tEntry;
    private static LogEntry _entry;
    private static Message _message;
    public static final String VALIDATION_BUILDER_ID = "org.eclipse.wst.validation.validationbuilder";
    public static final String VALIDATOR_EXT_PT_ID = "validator";

    public ValidationPlugin() {
        if (_plugin == null) {
            _plugin = this;
        }
    }

    public static String getBundleName() {
        return ValidationPlugin.getBundlePropertyFileName();
    }

    public static String getBundlePropertyFileName() {
        return VALIDATION_PROP_FILE_NAME;
    }

    public static LogEntry getLogEntry() {
        if (_entry == null) {
            _entry = new LogEntry(VALIDATION_PROP_FILE_NAME);
        } else {
            _entry.reset();
        }
        _entry.setLocaleOfOrigin(Locale.getDefault().toString());
        return _entry;
    }

    public static TimeEntry getTimeEntry() {
        if (_tEntry == null) {
            _tEntry = new TimeEntry();
        }
        _tEntry.reset();
        return _tEntry;
    }

    public static Message getMessage() {
        if (_message == null) {
            _message = new Message();
            _message.setBundleName(ValidationPlugin.getBundlePropertyFileName());
        }
        _message.setId(null);
        _message.setParams(null);
        _message.setTargetObject(null);
        _message.setGroupName(null);
        _message.setSeverity(4);
        return _message;
    }

    public static ValidationPlugin getPlugin() {
        return _plugin;
    }

    public static boolean isActivated() {
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        if (bundle != null) {
            return bundle.getState() == 32;
        }
        return false;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)EventManager.getManager(), 31);
        DependencyIndex di = (DependencyIndex)ValidationFramework.getDefault().getDependencyIndex();
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.addSaveParticipant((Plugin)this, (ISaveParticipant)di);
        ws.addResourceChangeListener((IResourceChangeListener)ValOperationManager.getDefault(), 24);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)EventManager.getManager());
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)ValOperationManager.getDefault());
        EventManager.getManager().shutdown();
    }

    public String getPluginID() {
        return PLUGIN_ID;
    }

    public void handleException(Exception e) {
        Status status = new Status(4, PLUGIN_ID, e.getLocalizedMessage(), (Throwable)e);
        this.getLog().log((IStatus)status);
    }

    public void logMessage(int severity, String message) {
        Status status = new Status(severity, PLUGIN_ID, message);
        this.getLog().log((IStatus)status);
    }
}

