/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.IModuleVisitor;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerMonitorManager;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.ServerSchedulingRule;
import org.eclipse.wst.server.core.internal.Trace;

public class ServerUtil {
    public static final Object SERVER_JOB_FAMILY = "org.eclipse.wst.server.core";

    private ServerUtil() {
    }

    public static IModule getModule(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException();
        }
        IModule[] modules = ServerUtil.getModules(project);
        if (modules != null && modules.length > 0) {
            return modules[0];
        }
        return null;
    }

    public static IModule[] getModules(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException();
        }
        HashSet<IModule> set = new HashSet<IModule>();
        ModuleFactory[] factories = ServerPlugin.getModuleFactories();
        if (factories != null) {
            int size = factories.length;
            int i = 0;
            while (i < size) {
                IModule[] modules = factories[i].getModules(project, null);
                if (modules != null) {
                    int size2 = modules.length;
                    int j = 0;
                    while (j < size2) {
                        if (!set.contains(modules[j])) {
                            set.add(modules[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        IModule[] modules = new IModule[set.size()];
        set.toArray(modules);
        return modules;
    }

    public static IModule getModule(String moduleId) {
        if (moduleId == null) {
            throw new IllegalArgumentException();
        }
        int index = moduleId.indexOf(":");
        if (index <= 0) {
            return null;
        }
        String factoryId = moduleId.substring(0, index);
        ModuleFactory moduleFactory = ServerPlugin.findModuleFactory(factoryId);
        if (moduleFactory == null) {
            return null;
        }
        String moduleSubId = moduleId.substring(index + 1);
        return moduleFactory.findModule(moduleSubId, null);
    }

    public static IModule[] getModules(IModuleType[] moduleTypes) {
        ArrayList<IModule> list = new ArrayList<IModule>();
        ModuleFactory[] factories = ServerPlugin.getModuleFactories();
        if (factories != null) {
            int size = factories.length;
            int i = 0;
            while (i < size) {
                IModule[] modules;
                if (ServerUtil.isSupportedModule(factories[i].getModuleTypes(), moduleTypes) && (modules = factories[i].getModules(null)) != null) {
                    int size2 = modules.length;
                    int j = 0;
                    while (j < size2) {
                        list.add(modules[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        IModule[] modules = new IModule[list.size()];
        list.toArray(modules);
        return modules;
    }

    public static IModule[] getModules(String type) {
        ArrayList<IModule> list = new ArrayList<IModule>();
        ModuleFactory[] factories = ServerPlugin.getModuleFactories();
        if (factories != null) {
            int size = factories.length;
            int i = 0;
            while (i < size) {
                IModule[] modules;
                if (ServerUtil.isSupportedModule(factories[i].getModuleTypes(), type, null) && (modules = factories[i].getModules(null)) != null) {
                    int size2 = modules.length;
                    int j = 0;
                    while (j < size2) {
                        if (type.equals(modules[j].getModuleType().getId())) {
                            list.add(modules[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        IModule[] modules = new IModule[list.size()];
        list.toArray(modules);
        return modules;
    }

    public static boolean isSupportedModule(IModuleType[] moduleTypes, String typeId, String versionId) {
        if (moduleTypes == null) {
            throw new IllegalArgumentException();
        }
        if ("".equals(typeId)) {
            typeId = null;
        }
        if ("".equals(versionId)) {
            versionId = null;
        }
        if (typeId == null && versionId == null) {
            return true;
        }
        int size = moduleTypes.length;
        int i = 0;
        while (i < size) {
            if (ServerUtil.isSupportedModule(moduleTypes[i], typeId, versionId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isSupportedModule(IModuleType[] moduleTypes, IModuleType[] mt) {
        if (mt != null) {
            int size = mt.length;
            int i = 0;
            while (i < size) {
                if (ServerUtil.isSupportedModule(moduleTypes, mt[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isSupportedModule(IModuleType[] moduleTypes, IModuleType mt) {
        if (moduleTypes == null || mt == null) {
            throw new IllegalArgumentException();
        }
        int size = moduleTypes.length;
        int i = 0;
        while (i < size) {
            if (ServerUtil.isSupportedModule(moduleTypes[i], mt)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isSupportedModule(IModuleType moduleType, String type, String version) {
        String version2;
        String type2 = moduleType.getId();
        return ServerUtil.matches(type, type2) && ServerUtil.matches(version, version2 = moduleType.getVersion());
    }

    public static boolean isSupportedModule(IModuleType moduleType, IModuleType mt) {
        if (moduleType == null || mt == null) {
            throw new IllegalArgumentException();
        }
        return ServerUtil.matches(mt.getId(), moduleType.getId()) && ServerUtil.matches(mt.getVersion(), moduleType.getVersion());
    }

    private static boolean matches(String a, String b) {
        return a == null || b == null || "*".equals(a) || "*".equals(b) || a.startsWith(b) || b.startsWith(a) || a.endsWith(".*") && b.startsWith(a.substring(0, a.length() - 1)) || b.endsWith(".*") && a.startsWith(b.substring(0, b.length() - 1));
    }

    public static void modifyModules(IServerWorkingCopy server, IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
        if (server == null) {
            throw new IllegalArgumentException("Server cannot be null");
        }
        if (add == null) {
            add = new IModule[]{};
        }
        if (remove == null) {
            remove = new IModule[]{};
        }
        int size = add.length;
        int i = 0;
        while (i < size) {
            if (add[i] == null) {
                throw new IllegalArgumentException("Cannot add null entries");
            }
            ++i;
        }
        ArrayList<IModule> addParentModules = new ArrayList<IModule>();
        int i2 = 0;
        while (i2 < size) {
            boolean found = false;
            try {
                IModule[] parents = server.getRootModules(add[i2], monitor);
                if (parents != null && parents.length > 0) {
                    IModule parent = parents[0];
                    found = true;
                    if (!addParentModules.contains(parent)) {
                        addParentModules.add(parent);
                    }
                }
            }
            catch (Exception e) {
                Trace.trace(2, "Could not find parent module", e);
            }
            if (!found) {
                addParentModules.add(add[i2]);
            }
            ++i2;
        }
        size = remove.length;
        i2 = 0;
        while (i2 < size) {
            if (remove[i2] == null) {
                throw new IllegalArgumentException("Cannot remove null entries");
            }
            ++i2;
        }
        ArrayList<IModule> removeParentModules = new ArrayList<IModule>();
        int i3 = 0;
        while (i3 < size) {
            boolean found = false;
            try {
                IModule[] parents = server.getRootModules(remove[i3], monitor);
                if (parents != null && parents.length > 0) {
                    IModule parent = parents[0];
                    found = true;
                    if (!removeParentModules.contains(parent)) {
                        removeParentModules.add(parent);
                    }
                }
            }
            catch (Exception e) {
                Trace.trace(2, "Could not find parent module 2", e);
            }
            if (!found) {
                removeParentModules.add(remove[i3]);
            }
            ++i3;
        }
        IModule[] add2 = new IModule[addParentModules.size()];
        addParentModules.toArray(add2);
        IModule[] remove2 = new IModule[removeParentModules.size()];
        removeParentModules.toArray(remove2);
        server.modifyModules(add2, remove2, monitor);
    }

    public static void setRuntimeDefaultName(IRuntimeWorkingCopy runtime) {
        String typeName = runtime.getRuntimeType().getName();
        String name = NLS.bind((String)Messages.defaultRuntimeName, (Object)typeName);
        int i = 2;
        while (ServerPlugin.isNameInUse(runtime.getOriginal(), name)) {
            name = NLS.bind((String)Messages.defaultRuntimeName2, (Object[])new String[]{typeName, String.valueOf(i)});
            ++i;
        }
        runtime.setName(name);
    }

    public static void setServerDefaultName(IServerWorkingCopy server) {
        if (server == null) {
            throw new IllegalArgumentException();
        }
        String typeName = server.getServerType().getName();
        String host = server.getHost();
        IRuntime runtime = server.getRuntime();
        if (runtime != null) {
            IRuntimeWorkingCopy wc = runtime.createWorkingCopy();
            ServerUtil.setRuntimeDefaultName(wc);
            if (!wc.getName().equals(runtime.getName())) {
                typeName = runtime.getName();
            }
        }
        String name = NLS.bind((String)Messages.defaultServerName, (Object[])new String[]{typeName, host});
        int i = 2;
        while (ServerPlugin.isNameInUse(server.getOriginal(), name)) {
            name = NLS.bind((String)Messages.defaultServerName2, (Object[])new String[]{typeName, host, String.valueOf(i)});
            ++i;
        }
        server.setName(name);
    }

    private static boolean isValidFilename(String name) {
        IStatus status = ResourcesPlugin.getWorkspace().validateName(name, 1);
        if (status != null && !status.isOK()) {
            return false;
        }
        status = ResourcesPlugin.getWorkspace().validateName(name, 2);
        return status == null || status.isOK();
    }

    private static String getValidFileName(String name) {
        if (ServerUtil.isValidFilename(name)) {
            return name;
        }
        String[] s = new String[]{".", "\\", "/", "?", ":", "*", "\"", "|", "<", ">"};
        int ind = 0;
        while (ind < s.length) {
            int index = name.indexOf(s[ind]);
            while (index >= 0) {
                name = String.valueOf(name.substring(0, index)) + name.substring(index + 1);
                index = name.indexOf(s[ind]);
            }
            ++ind;
        }
        return name;
    }

    public static IFile getUnusedServerFile(IProject project, IServer server) {
        if (project == null || server == null) {
            throw new IllegalArgumentException();
        }
        String typeName = ServerUtil.getValidFileName(server.getName());
        String name = String.valueOf(NLS.bind((String)Messages.defaultServerName3, (Object)typeName)) + "." + "server";
        int i = 2;
        while (ServerUtil.isFileNameInUse(project, name)) {
            name = String.valueOf(NLS.bind((String)Messages.defaultServerName4, (Object[])new String[]{typeName, String.valueOf(i)})) + "." + "server";
            ++i;
        }
        return project.getFile(name);
    }

    private static boolean isFileNameInUse(IProject project, String name) {
        if (name == null || project == null) {
            return false;
        }
        if (project.getFile(name).exists()) {
            return true;
        }
        return project.getFolder(name).exists();
    }

    public static IRuntime[] getRuntimes(String type, String version) {
        ArrayList<IRuntime> list = new ArrayList<IRuntime>();
        IRuntime[] runtimes = ServerCore.getRuntimes();
        if (runtimes != null) {
            int size = runtimes.length;
            int i = 0;
            while (i < size) {
                IRuntimeType runtimeType = runtimes[i].getRuntimeType();
                if (runtimeType != null && ServerUtil.isSupportedModule(runtimeType.getModuleTypes(), type, version)) {
                    list.add(runtimes[i]);
                }
                ++i;
            }
        }
        IRuntime[] runtimes2 = new IRuntime[list.size()];
        list.toArray(runtimes2);
        return runtimes2;
    }

    public static IRuntimeType[] getRuntimeTypes(String type, String version) {
        ArrayList<IRuntimeType> list = new ArrayList<IRuntimeType>();
        IRuntimeType[] runtimeTypes = ServerCore.getRuntimeTypes();
        if (runtimeTypes != null) {
            int size = runtimeTypes.length;
            int i = 0;
            while (i < size) {
                if (ServerUtil.isSupportedModule(runtimeTypes[i].getModuleTypes(), type, version)) {
                    list.add(runtimeTypes[i]);
                }
                ++i;
            }
        }
        IRuntimeType[] rt = new IRuntimeType[list.size()];
        list.toArray(rt);
        return rt;
    }

    public static IRuntimeType[] getRuntimeTypes(String type, String version, String runtimeTypeId) {
        ArrayList<IRuntimeType> list = new ArrayList<IRuntimeType>();
        IRuntimeType[] runtimeTypes = ServerCore.getRuntimeTypes();
        if (runtimeTypes != null) {
            int size = runtimeTypes.length;
            int i = 0;
            while (i < size) {
                if (ServerUtil.isSupportedModule(runtimeTypes[i].getModuleTypes(), type, version) && (runtimeTypeId == null || runtimeTypes[i].getId().startsWith(runtimeTypeId))) {
                    list.add(runtimeTypes[i]);
                }
                ++i;
            }
        }
        IRuntimeType[] rt = new IRuntimeType[list.size()];
        list.toArray(rt);
        return rt;
    }

    public static IServer[] getAvailableServersForModule(IModule module, boolean includeErrors, IProgressMonitor monitor) {
        if (module == null) {
            return new IServer[0];
        }
        ArrayList<IServer> list = new ArrayList<IServer>();
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                block9: {
                    if (!ServerUtil.containsModule(servers[i], module, monitor)) {
                        try {
                            IModule[] parents = servers[i].getRootModules(module, monitor);
                            if (parents != null && parents.length > 0) {
                                boolean found = false;
                                int size2 = parents.length;
                                int j = 0;
                                while (!found && j < size2) {
                                    IModule parent = parents[j];
                                    IStatus status = servers[i].canModifyModules(new IModule[]{parent}, new IModule[0], monitor);
                                    if (status == null || status.isOK()) {
                                        list.add(servers[i]);
                                        found = true;
                                    }
                                    ++j;
                                }
                            }
                        }
                        catch (Exception exception) {
                            if (!includeErrors) break block9;
                            list.add(servers[i]);
                        }
                    }
                }
                ++i;
            }
        }
        IServer[] allServers = new IServer[list.size()];
        list.toArray(allServers);
        return allServers;
    }

    public static IServer[] getServersByModule(IModule module, IProgressMonitor monitor) {
        if (module == null) {
            return new IServer[0];
        }
        ArrayList<IServer> list = new ArrayList<IServer>();
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                if (ServerUtil.containsModule(servers[i], module, monitor)) {
                    list.add(servers[i]);
                }
                ++i;
            }
        }
        IServer[] allServers = new IServer[list.size()];
        list.toArray(allServers);
        return allServers;
    }

    public static boolean containsModule(IServer server, final IModule module, IProgressMonitor monitor) {
        if (server == null || module == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        Trace.trace(5, "containsModule() " + server + " " + module);
        final boolean[] b = new boolean[1];
        ((Server)server).visit(new IModuleVisitor(){

            public boolean visit(IModule[] modules) {
                int size = modules.length;
                if (modules[size - 1].equals(module)) {
                    b[0] = true;
                    return false;
                }
                return true;
            }
        }, null);
        return b[0];
    }

    public static IServer getServer(ILaunchConfiguration configuration) throws CoreException {
        String serverId = configuration.getAttribute("server-id", null);
        if (serverId != null) {
            return ServerCore.findServer(serverId);
        }
        return null;
    }

    public static IStatus validateEdit(Object context, IServer server) {
        return ((Server)server).validateEdit(context);
    }

    public static int getMonitoredPort(IServer server, int port, String contentType) {
        return ServerMonitorManager.getInstance().getMonitoredPort(server, port, contentType);
    }

    public static ISchedulingRule getServerSchedulingRule(IServer server) {
        return new ServerSchedulingRule(server);
    }
}

