/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.IRuntimeLocator;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.RuntimeLocatorDelegate;

public class RuntimeLocator
implements IRuntimeLocator {
    private IConfigurationElement element;
    private RuntimeLocatorDelegate delegate;

    public RuntimeLocator(IConfigurationElement element) {
        this.element = element;
    }

    protected IConfigurationElement getElement() {
        return this.element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    protected String[] getTypeIds() {
        try {
            return ServerPlugin.tokenize(this.element.getAttribute("typeIds"), ",");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean supportsType(String id) {
        return ServerPlugin.supportsType(this.getTypeIds(), id);
    }

    protected RuntimeLocatorDelegate getDelegate() {
        if (this.delegate == null) {
            try {
                this.delegate = (RuntimeLocatorDelegate)this.element.createExecutableExtension("class");
            }
            catch (Throwable t) {
                Trace.trace(3, "Could not create delegate " + this.toString(), t);
            }
        }
        return this.delegate;
    }

    public void searchForRuntimes(IPath path, final IRuntimeLocator.IRuntimeSearchListener found, IProgressMonitor monitor) {
        try {
            this.getDelegate().searchForRuntimes(path, new RuntimeLocatorDelegate.IRuntimeSearchListener(){

                public void runtimeFound(IRuntimeWorkingCopy runtime) {
                    found.runtimeFound(runtime);
                }
            }, monitor);
        }
        catch (Exception e) {
            Trace.trace(3, "Error calling delegate " + this.toString(), e);
        }
    }

    public String toString() {
        return "RuntimeLocator[" + this.getId() + "]";
    }
}

