/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.internal.helper;

import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.ocl.helper.Choice;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.helper.OCLHelper;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.internal.helper.HelperUtil;
import org.eclipse.ocl.internal.helper.OCLSyntaxHelper;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.utilities.ExpressionInOCL;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OCLHelperImpl<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
implements OCLHelper<C, O, P, CT> {
    private final EnvironmentFactory<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> environmentFactory;
    private final UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> uml;
    private final OCLFactory oclFactory;
    private Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env;
    private OCLSyntaxHelper<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> syntaxHelper;
    private boolean validating = true;
    private final OCL<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> ocl;
    private Diagnostic problems;

    OCLHelperImpl(OCL<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> ocl) {
        this.ocl = ocl;
        this.uml = ocl.getEnvironment().getUMLReflection();
        this.oclFactory = ocl.getEnvironment().getOCLFactory();
        this.environmentFactory = ocl.getEnvironment().getFactory();
    }

    protected Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getEnvironment() {
        return this.env == null ? this.ocl.getEnvironment() : this.env;
    }

    @Override
    public OCL<?, C, O, P, ?, ?, ?, ?, ?, CT, ?, ?> getOCL() {
        return this.ocl;
    }

    @Override
    public boolean isValidating() {
        return this.validating;
    }

    @Override
    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    private String removeOCLComments(String txt) {
        try {
            return HelperUtil.getLogicalLine(txt);
        }
        catch (Exception ex) {
            HelperUtil.catchException(ex, this.getClass(), "removeOCLComments");
            return "";
        }
    }

    private void setEnvironment(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        this.env = env;
        this.syntaxHelper = null;
    }

    @Override
    public void setContext(C context) {
        this.setEnvironment(this.environmentFactory.createClassifierContext(this.ocl.getEnvironment(), context));
    }

    @Override
    public void setOperationContext(C context, O operation) {
        this.setContext(context);
        this.setEnvironment(this.environmentFactory.createOperationContext(this.env, operation));
    }

    @Override
    public void setAttributeContext(C context, P property) {
        this.setContext(context);
        this.setEnvironment(this.environmentFactory.createAttributeContext(this.env, property));
    }

    @Override
    public void setInstanceContext(Object instance) {
        this.setEnvironment(this.environmentFactory.createInstanceContext(this.ocl.getEnvironment(), instance));
    }

    @Override
    public void setInstanceOperationContext(Object instance, O operation) {
        this.setInstanceContext(instance);
        this.setEnvironment(this.environmentFactory.createOperationContext(this.env, operation));
    }

    @Override
    public void setInstanceAttributeContext(Object instance, P property) {
        this.setInstanceContext(instance);
        this.setEnvironment(this.environmentFactory.createAttributeContext(this.env, property));
    }

    @Override
    public C getContextClassifier() {
        return this.env.getContextClassifier();
    }

    @Override
    public O getContextOperation() {
        return this.env.getContextOperation();
    }

    @Override
    public P getContextAttribute() {
        return this.env.getContextProperty();
    }

    @Override
    public List<Choice> getSyntaxHelp(ConstraintKind constraintType, String txt) {
        return this.createSyntaxHelper().getSyntaxHelp(constraintType, txt);
    }

    @Override
    public OCLExpression<C> createQuery(String expression) throws ParserException {
        if (this.removeOCLComments(expression).length() > 0) {
            try {
                return HelperUtil.parseQuery(this, expression, this.validating, this.ocl.isParseTracingEnabled());
            }
            catch (RuntimeException e) {
                this.propagate(e, "createQuery");
            }
        }
        return this.uml.getSpecification(this.createNullCondition(this.env.getOCLStandardLibrary().getBoolean())).getBodyExpression();
    }

    @Override
    public CT createConstraint(ConstraintKind kind, String expression) throws ParserException {
        switch (kind) {
            case PRECONDITION: {
                return this.createPrecondition(expression);
            }
            case BODYCONDITION: {
                return this.createBodyCondition(expression);
            }
            case POSTCONDITION: {
                return this.createPostcondition(expression);
            }
            case INITIAL: {
                return this.createInitialValueExpression(expression);
            }
            case DERIVATION: {
                return this.createDerivedValueExpression(expression);
            }
            case DEFINITION: {
                return HelperUtil.parseDefExpression(this, expression, this.validating, this.ocl.isParseTracingEnabled());
            }
        }
        return this.createInvariant(expression);
    }

    @Override
    public CT createInvariant(String expression) throws ParserException {
        if (this.removeOCLComments(expression).length() > 0) {
            try {
                return HelperUtil.parseInvariant(this, expression, this.validating, this.ocl.isParseTracingEnabled());
            }
            catch (RuntimeException e) {
                this.propagate(e, "createInvariant");
            }
        }
        return this.createNullCondition(this.env.getOCLStandardLibrary().getBoolean());
    }

    @Override
    public CT createPrecondition(String expression) throws ParserException {
        if (this.removeOCLComments(expression).length() > 0) {
            try {
                return HelperUtil.parsePrecondition(this, expression, this.validating, this.ocl.isParseTracingEnabled());
            }
            catch (RuntimeException e) {
                this.propagate(e, "createPrecondition");
            }
        }
        return this.createNullCondition(this.env.getOCLStandardLibrary().getBoolean());
    }

    @Override
    public CT createPostcondition(String expression) throws ParserException {
        if (this.removeOCLComments(expression).length() > 0) {
            try {
                return HelperUtil.parsePostcondition(this, expression, this.validating, this.ocl.isParseTracingEnabled());
            }
            catch (RuntimeException e) {
                this.propagate(e, "createPostcondition");
            }
        }
        return this.createNullCondition(this.env.getOCLStandardLibrary().getBoolean());
    }

    @Override
    public CT createBodyCondition(String expression) throws ParserException {
        if (this.removeOCLComments(expression).length() > 0) {
            try {
                return HelperUtil.parseBodyCondition(this, expression, this.validating, this.ocl.isParseTracingEnabled());
            }
            catch (RuntimeException e) {
                this.propagate(e, "createBodyCondition");
            }
        }
        return this.createNullCondition(this.env.getOCLStandardLibrary().getOclVoid());
    }

    @Override
    public CT createInitialValueExpression(String expression) throws ParserException {
        if (this.removeOCLComments(expression).length() > 0) {
            try {
                return HelperUtil.parseInitialValueExpression(this, expression, this.validating, this.ocl.isParseTracingEnabled());
            }
            catch (RuntimeException e) {
                this.propagate(e, "createInitialValueExpression");
            }
        }
        return this.createNullCondition(this.env.getOCLStandardLibrary().getOclVoid());
    }

    @Override
    public CT createDerivedValueExpression(String expression) throws ParserException {
        if (this.removeOCLComments(expression).length() > 0) {
            try {
                return HelperUtil.parseDerivedValueExpression(this, expression, this.validating, this.ocl.isParseTracingEnabled());
            }
            catch (RuntimeException e) {
                this.propagate(e, "createDerivedValueExpression");
            }
        }
        return this.createNullCondition(this.env.getOCLStandardLibrary().getOclVoid());
    }

    @Override
    public O defineOperation(String defExpression) throws ParserException {
        try {
            EObject operation = this.define(defExpression);
            if (!this.uml.isOperation(operation)) {
                throw new ClassCastException();
            }
            return (O)operation;
        }
        catch (RuntimeException e) {
            this.propagate(e, "define");
            return null;
        }
    }

    @Override
    public P defineAttribute(String defExpression) throws ParserException {
        try {
            EObject property = this.define(defExpression);
            if (!this.uml.isProperty(property)) {
                throw new ClassCastException();
            }
            return (P)property;
        }
        catch (RuntimeException e) {
            this.propagate(e, "define");
            return null;
        }
    }

    EObject define(String defExpression) throws ParserException {
        Object constraint = HelperUtil.parseDefExpression(this, defExpression, this.validating, this.ocl.isParseTracingEnabled());
        List<EObject> constrainedElement = this.uml.getConstrainedElements(constraint);
        EObject result = constrainedElement.get(1);
        if (!ParsingOptions.getValue(this.getEnvironment(), ParsingOptions.DEFINITION_CONSTRAINS_FEATURE).booleanValue()) {
            constrainedElement.remove(result);
        }
        return result;
    }

    private CT createNullCondition(C type) {
        OCLExpression condition;
        OCLStandardLibrary<C> stdlib = this.env.getOCLStandardLibrary();
        if (type == stdlib.getBoolean()) {
            BooleanLiteralExp literal;
            condition = literal = this.oclFactory.createBooleanLiteralExp();
            this.uml.setType(literal, this.env.getOCLStandardLibrary().getBoolean());
            literal.setBooleanSymbol(Boolean.FALSE);
        } else {
            UnspecifiedValueExp unspec = this.oclFactory.createUnspecifiedValueExp();
            condition = unspec;
            if (type == null) {
                type = this.env.getOCLStandardLibrary().getOclVoid();
            }
            this.uml.setType(unspec, type);
        }
        CT result = this.uml.createConstraint();
        ExpressionInOCL<C, PM> spec = this.uml.createExpressionInOCL();
        spec.setBodyExpression(condition);
        spec.setContextVariable(this.env.getSelfVariable());
        this.uml.setSpecification(result, spec);
        return result;
    }

    private void propagate(Exception e, String method) throws ParserException {
        OCLPlugin.catching(this.getClass(), method, e);
        ParserException ope = new ParserException(e.getLocalizedMessage(), e);
        OCLPlugin.throwing(this.getClass(), method, ope);
        throw ope;
    }

    protected OCLSyntaxHelper<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> createSyntaxHelper() {
        if (this.syntaxHelper == null) {
            this.syntaxHelper = new OCLSyntaxHelper<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(this.getEnvironment());
        }
        return this.syntaxHelper;
    }

    @Override
    public Diagnostic getProblems() {
        return this.problems;
    }

    void setProblems(Diagnostic problems) {
        this.problems = problems;
    }
}

