/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.lpg;

import org.eclipse.emf.common.util.Monitor;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.lpg.AbstractParser;

public interface ProblemHandler {
    public static final String[] ERROR_MESSAGES = new String[]{OCLMessages.OCLParseErrorCodes_LEX_ERROR, OCLMessages.OCLParseErrorCodes_ERROR, OCLMessages.OCLParseErrorCodes_BEFORE, OCLMessages.OCLParseErrorCodes_INSERTION, OCLMessages.OCLParseErrorCodes_INVALID, OCLMessages.OCLParseErrorCodes_SUBSTITUTION_SECONDARY, OCLMessages.OCLParseErrorCodes_DELETION, OCLMessages.OCLParseErrorCodes_MERGE, OCLMessages.OCLParseErrorCodes_MISPLACED, OCLMessages.OCLParseErrorCodes_SCOPE, OCLMessages.OCLParseErrorCodes_EOF, OCLMessages.OCLParseErrorCodes_INVALID_TOKEN};

    public void setParser(AbstractParser var1);

    public AbstractParser getParser();

    public void handleProblem(Severity var1, Phase var2, String var3, String var4, int var5, int var6);

    public void analyzerProblem(Severity var1, String var2, String var3, int var4, int var5);

    public void lexerProblem(Severity var1, String var2, String var3, int var4, int var5);

    public void parserProblem(Severity var1, String var2, String var3, int var4, int var5);

    public void utilityProblem(Severity var1, String var2, String var3, int var4, int var5);

    public void validatorProblem(Severity var1, String var2, String var3, int var4, int var5);

    public void setErrorReportLineOffset(int var1);

    public int getErrorReportLineOffset();

    public void beginParse();

    public void endParse();

    public void beginValidation();

    public void endValidation();

    public void flush(Monitor var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Phase
    implements Comparable<Phase> {
        public static Phase LEXER = new Phase(OCLMessages.Phase_Lexer);
        public static Phase PARSER = new Phase(OCLMessages.Phase_Parser);
        public static Phase ANALYZER = new Phase(OCLMessages.Phase_Analyzer);
        public static Phase VALIDATOR = new Phase(OCLMessages.Phase_Validator);
        public static Phase UTILITY = new Phase(OCLMessages.Phase_Utility);
        public static Phase UNPARSER = new Phase(OCLMessages.Phase_Unparser);
        private final String localizedName;

        protected Phase(String lname) {
            this.localizedName = lname;
        }

        @Override
        public final int compareTo(Phase o) {
            return this.localizedName.compareTo(o.localizedName);
        }

        public final int hashCode() {
            int result = 1;
            result = 31 * result + (this.localizedName == null ? 0 : this.localizedName.hashCode());
            return result;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Phase)) {
                return false;
            }
            Phase other = (Phase)obj;
            return !(this.localizedName == null ? other.localizedName != null : !this.localizedName.equals(other.localizedName));
        }

        public String toString() {
            return this.localizedName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        OK(OCLMessages.Severity_OK, 0){

            public boolean isOK() {
                return true;
            }
        }
        ,
        INFO(OCLMessages.Severity_Info, 1),
        WARNING(OCLMessages.Severity_Warning, 2),
        ERROR(OCLMessages.Severity_Error, 4),
        FATAL(OCLMessages.Severity_Fatal_Error, 4),
        CANCEL(OCLMessages.Severity_Cancel, 8);

        private final int diagnosticSeverity;
        private final String localizedName;

        private Severity(String lname, int sev) {
            this.localizedName = lname;
            this.diagnosticSeverity = sev;
        }

        public int getDiagnosticSeverity() {
            return this.diagnosticSeverity;
        }

        public boolean isOK() {
            return false;
        }

        public String toString() {
            return this.localizedName;
        }
    }
}

