/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.util;

import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.ocl.internal.evaluation.NumberUtil;

public class ObjectUtil {
    public static boolean equal(Object anObject, Object anotherObject) {
        if (anObject == null || anotherObject == null) {
            return anObject == anotherObject;
        }
        if (ObjectUtil.isPrimitive(anObject) || ObjectUtil.isPrimitive(anotherObject)) {
            if (anObject instanceof Integer) {
                anObject = NumberUtil.higherPrecisionNumber((Integer)anObject);
            }
            if (anotherObject instanceof Integer) {
                anotherObject = NumberUtil.higherPrecisionNumber((Integer)anotherObject);
            }
            if (anObject instanceof Long && anotherObject instanceof Long) {
                return ((Long)anObject).longValue() == ((Long)anotherObject).longValue();
            }
            if (anObject instanceof Long && anotherObject instanceof Double) {
                return ((Long)anObject).doubleValue() == ((Double)anotherObject).doubleValue();
            }
            if (anObject instanceof Double && anotherObject instanceof Long) {
                return ((Double)anObject).doubleValue() == ((Long)anotherObject).doubleValue();
            }
            if (anObject instanceof Double && anotherObject instanceof Double) {
                return ((Double)anObject).doubleValue() == ((Double)anotherObject).doubleValue();
            }
            if (anObject instanceof String && anotherObject instanceof String) {
                return anObject.equals(anotherObject);
            }
            if (anObject instanceof Boolean && anotherObject instanceof Boolean) {
                return ((Boolean)anObject).booleanValue() == ((Boolean)anotherObject).booleanValue();
            }
            return false;
        }
        if (anObject instanceof EEnumLiteral && anotherObject instanceof EEnumLiteral) {
            return anObject == anotherObject;
        }
        if (anObject instanceof EEnumLiteral && anotherObject instanceof Enumerator) {
            return ((EEnumLiteral)anObject).getInstance() == anotherObject;
        }
        if (anotherObject instanceof EEnumLiteral && anObject instanceof Enumerator) {
            return ((EEnumLiteral)anotherObject).getInstance() == anObject;
        }
        return anObject.equals(anotherObject);
    }

    public static int hashCode(Object anObject) {
        if (anObject == null) {
            return 0;
        }
        if (ObjectUtil.isPrimitive(anObject)) {
            if (anObject instanceof Integer) {
                return 37 * (Integer)anObject;
            }
            if (anObject instanceof Long) {
                return 37 * ((Long)anObject).intValue();
            }
            if (anObject instanceof Double) {
                return 37 * ((Double)anObject).intValue();
            }
            if (anObject instanceof String) {
                return anObject.hashCode();
            }
            if (anObject instanceof Boolean) {
                return anObject.hashCode();
            }
            return 0;
        }
        if (anObject instanceof EEnumLiteral) {
            return ((EEnumLiteral)anObject).getInstance().hashCode();
        }
        return anObject.hashCode();
    }

    public static boolean isPrimitive(Object o) {
        return o instanceof Integer || o instanceof Long || o instanceof String || o instanceof Boolean || o instanceof Double;
    }
}

