/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.utilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.ocl.expressions.AssociationClassCallExp;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.CollectionLiteralPart;
import org.eclipse.ocl.expressions.CollectionRange;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.IntegerLiteralExp;
import org.eclipse.ocl.expressions.InvalidLiteralExp;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.MessageExp;
import org.eclipse.ocl.expressions.NullLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.RealLiteralExp;
import org.eclipse.ocl.expressions.StateExp;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralPart;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.utilities.ExpressionInOCL;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVisitor<T, C, O, P, EL, PM, S, COA, SSA, CT>
implements Visitor<T, C, O, P, EL, PM, S, COA, SSA, CT> {
    protected T result;

    protected AbstractVisitor() {
    }

    protected AbstractVisitor(T initialValue) {
        this.result = initialValue;
    }

    @Override
    public T visitOperationCallExp(OperationCallExp<C, O> callExp) {
        List argumentResults;
        Object sourceResult = callExp.getSource().accept(this);
        List arguments = (List)callExp.getArgument();
        if (arguments.isEmpty()) {
            argumentResults = Collections.emptyList();
        } else {
            argumentResults = new ArrayList(arguments.size());
            for (OCLExpression qual : arguments) {
                argumentResults.add(qual.accept(this));
            }
        }
        return (T)this.handleOperationCallExp(callExp, sourceResult, argumentResults);
    }

    protected T handleOperationCallExp(OperationCallExp<C, O> callExp, T sourceResult, List<T> argumentResults) {
        return this.result;
    }

    @Override
    public T visitVariableExp(VariableExp<C, PM> v) {
        return this.result;
    }

    @Override
    public T visitPropertyCallExp(PropertyCallExp<C, P> callExp) {
        List qualifierResults;
        List qualifiers;
        Object sourceResult = null;
        if (callExp.getSource() != null) {
            sourceResult = callExp.getSource().accept(this);
        }
        if ((qualifiers = (List)callExp.getQualifier()).isEmpty()) {
            qualifierResults = Collections.emptyList();
        } else {
            qualifierResults = new ArrayList(qualifiers.size());
            for (OCLExpression qual : qualifiers) {
                qualifierResults.add(qual.accept(this));
            }
        }
        return (T)this.handlePropertyCallExp(callExp, sourceResult, qualifierResults);
    }

    protected T handlePropertyCallExp(PropertyCallExp<C, P> callExp, T sourceResult, List<T> qualifierResults) {
        return this.result;
    }

    @Override
    public T visitAssociationClassCallExp(AssociationClassCallExp<C, P> callExp) {
        List qualifierResults;
        Object sourceResult = callExp.getSource().accept(this);
        List qualifiers = (List)callExp.getQualifier();
        if (qualifiers.isEmpty()) {
            qualifierResults = Collections.emptyList();
        } else {
            qualifierResults = new ArrayList(qualifiers.size());
            for (OCLExpression qual : qualifiers) {
                qualifierResults.add(qual.accept(this));
            }
        }
        return (T)this.handleAssociationClassCallExp(callExp, sourceResult, qualifierResults);
    }

    protected T handleAssociationClassCallExp(AssociationClassCallExp<C, P> callExp, T sourceResult, List<T> qualifierResults) {
        return this.result;
    }

    @Override
    public T visitVariable(Variable<C, PM> variable) {
        Object initResult = null;
        if (variable.getInitExpression() != null) {
            initResult = variable.getInitExpression().accept(this);
        }
        return this.handleVariable(variable, initResult);
    }

    protected T handleVariable(Variable<C, PM> variable, T initResult) {
        return this.result;
    }

    @Override
    public T visitIfExp(IfExp<C> ifExp) {
        return (T)this.handleIfExp(ifExp, ifExp.getCondition().accept(this), ifExp.getThenExpression().accept(this), ifExp.getElseExpression().accept(this));
    }

    protected T handleIfExp(IfExp<C> ifExp, T conditionResult, T thenResult, T elseResult) {
        return this.result;
    }

    @Override
    public T visitTypeExp(TypeExp<C> t) {
        return this.result;
    }

    @Override
    public T visitMessageExp(MessageExp<C, COA, SSA> messageExp) {
        List argumentResults;
        Object targetResult = messageExp.getTarget().accept(this);
        List arguments = (List)messageExp.getArgument();
        if (arguments.isEmpty()) {
            argumentResults = Collections.emptyList();
        } else {
            argumentResults = new ArrayList(arguments.size());
            for (OCLExpression qual : arguments) {
                argumentResults.add(qual.accept(this));
            }
        }
        return (T)this.handleMessageExp(messageExp, targetResult, argumentResults);
    }

    protected T handleMessageExp(MessageExp<C, COA, SSA> messageExp, T targetResult, List<T> argumentResults) {
        return this.result;
    }

    @Override
    public T visitUnspecifiedValueExp(UnspecifiedValueExp<C> unspecExp) {
        return this.result;
    }

    @Override
    public T visitStateExp(StateExp<C, S> stateExp) {
        return this.result;
    }

    @Override
    public T visitIntegerLiteralExp(IntegerLiteralExp<C> literalExp) {
        return this.result;
    }

    @Override
    public T visitUnlimitedNaturalLiteralExp(UnlimitedNaturalLiteralExp<C> literalExp) {
        return this.result;
    }

    @Override
    public T visitRealLiteralExp(RealLiteralExp<C> literalExp) {
        return this.result;
    }

    @Override
    public T visitStringLiteralExp(StringLiteralExp<C> literalExp) {
        return this.result;
    }

    @Override
    public T visitBooleanLiteralExp(BooleanLiteralExp<C> literalExp) {
        return this.result;
    }

    @Override
    public T visitNullLiteralExp(NullLiteralExp<C> literalExp) {
        return this.result;
    }

    @Override
    public T visitInvalidLiteralExp(InvalidLiteralExp<C> literalExp) {
        return this.result;
    }

    @Override
    public T visitTupleLiteralExp(TupleLiteralExp<C, P> literalExp) {
        List partResults;
        List parts = (List)literalExp.getPart();
        if (parts.isEmpty()) {
            partResults = Collections.emptyList();
        } else {
            partResults = new ArrayList(parts.size());
            for (TupleLiteralPart part : parts) {
                partResults.add(part.accept(this));
            }
        }
        return this.handleTupleLiteralExp(literalExp, partResults);
    }

    protected T handleTupleLiteralExp(TupleLiteralExp<C, P> literalExp, List<T> partResults) {
        return this.result;
    }

    @Override
    public T visitTupleLiteralPart(TupleLiteralPart<C, P> part) {
        Object valueResult = null;
        if (part.getValue() != null) {
            valueResult = part.getValue().accept(this);
        }
        return this.handleTupleLiteralPart(part, valueResult);
    }

    protected T handleTupleLiteralPart(TupleLiteralPart<C, P> part, T valueResult) {
        return this.result;
    }

    @Override
    public T visitLetExp(LetExp<C, PM> letExp) {
        return (T)this.handleLetExp(letExp, letExp.getVariable().accept(this), letExp.getIn().accept(this));
    }

    protected T handleLetExp(LetExp<C, PM> letExp, T variableResult, T inResult) {
        return this.result;
    }

    @Override
    public T visitEnumLiteralExp(EnumLiteralExp<C, EL> literalExp) {
        return this.result;
    }

    @Override
    public T visitCollectionLiteralExp(CollectionLiteralExp<C> literalExp) {
        List partResults;
        List parts = (List)literalExp.getPart();
        if (parts.isEmpty()) {
            partResults = Collections.emptyList();
        } else {
            partResults = new ArrayList(parts.size());
            for (CollectionLiteralPart part : parts) {
                partResults.add(part.accept(this));
            }
        }
        return this.handleCollectionLiteralExp(literalExp, partResults);
    }

    protected T handleCollectionLiteralExp(CollectionLiteralExp<C> literalExp, List<T> partResults) {
        return this.result;
    }

    @Override
    public T visitCollectionItem(CollectionItem<C> item) {
        return (T)this.handleCollectionItem(item, item.getItem().accept(this));
    }

    protected T handleCollectionItem(CollectionItem<C> item, T itemResult) {
        return this.result;
    }

    @Override
    public T visitCollectionRange(CollectionRange<C> range) {
        return (T)this.handleCollectionRange(range, range.getFirst().accept(this), range.getLast().accept(this));
    }

    protected T handleCollectionRange(CollectionRange<C> range, T firstResult, T lastResult) {
        return this.result;
    }

    @Override
    public T visitIteratorExp(IteratorExp<C, PM> callExp) {
        List variableResults;
        Object sourceResult = callExp.getSource().accept(this);
        List variables = (List)callExp.getIterator();
        if (variables.isEmpty()) {
            variableResults = Collections.emptyList();
        } else {
            variableResults = new ArrayList(variables.size());
            for (Variable iterVar : variables) {
                variableResults.add(iterVar.accept(this));
            }
        }
        Object bodyResult = callExp.getBody().accept(this);
        return (T)this.handleIteratorExp(callExp, sourceResult, variableResults, bodyResult);
    }

    protected T handleIteratorExp(IteratorExp<C, PM> callExp, T sourceResult, List<T> variableResults, T bodyResult) {
        return this.result;
    }

    @Override
    public T visitIterateExp(IterateExp<C, PM> callExp) {
        List variableResults;
        Object sourceResult = callExp.getSource().accept(this);
        List variables = (List)callExp.getIterator();
        if (variables.isEmpty()) {
            variableResults = Collections.emptyList();
        } else {
            variableResults = new ArrayList(variables.size());
            for (Variable iterVar : variables) {
                variableResults.add(iterVar.accept(this));
            }
        }
        Object resultResult = callExp.getResult().accept(this);
        Object bodyResult = callExp.getBody().accept(this);
        return (T)this.handleIterateExp(callExp, sourceResult, variableResults, resultResult, bodyResult);
    }

    protected T handleIterateExp(IterateExp<C, PM> callExp, T sourceResult, List<T> variableResults, T resultResult, T bodyResult) {
        return this.result;
    }

    @Override
    public T visitExpressionInOCL(ExpressionInOCL<C, PM> expression) {
        List parameterResults;
        Object contextResult = expression.getContextVariable().accept(this);
        Variable<C, PM> resultVar = expression.getResultVariable();
        Object resultResult = resultVar == null ? null : resultVar.accept(this);
        List parameters = (List)expression.getParameterVariable();
        if (parameters.isEmpty()) {
            parameterResults = Collections.emptyList();
        } else {
            parameterResults = new ArrayList(parameters.size());
            for (Variable iterVar : parameters) {
                parameterResults.add(iterVar.accept(this));
            }
        }
        Object bodyResult = expression.getBodyExpression().accept(this);
        return (T)this.handleExpressionInOCL(expression, contextResult, resultResult, parameterResults, bodyResult);
    }

    protected T handleExpressionInOCL(ExpressionInOCL<C, PM> expression, T contextResult, T resultResult, List<T> parameterResults, T bodyResult) {
        return this.result;
    }

    @Override
    public T visitConstraint(CT constraint) {
        T specificationResult = null;
        if (this.getSpecification(constraint) != null) {
            specificationResult = this.getSpecification(constraint).accept(this);
        }
        return this.handleConstraint(constraint, specificationResult);
    }

    protected T handleConstraint(CT constraint, T specificationResult) {
        return this.result;
    }

    protected ExpressionInOCL<C, PM> getSpecification(CT constraint) {
        return null;
    }
}

