/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.part.DrillDownComposite;

public abstract class TreeViewerSelectionDialog
extends SelectionDialog {
    private static final String DEFAULT_TITLE = JSFUICommonPlugin.getResourceString("Dialog.TreeViewerSelectionDialog.DefaultTitle");
    public static final int STYLE_NONE = 0;
    private static final int STYLE_INFORMATION = 1;
    private static final int STYLE_ERROR = 2;
    private static final int STYLE_WARNING = 3;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 300;
    private static final int SIZING_SELECTION_PANE_WIDTH = 320;
    private String _title = DEFAULT_TITLE;
    private static Object[] _selection;
    private ITreeContentProvider _contentProvider;
    private ILabelProvider _labelProvider;
    private ViewerFilter _filter;
    private Label _statusImage;
    private Label _statusLabel;
    private String _statusMessage;
    private TreeViewer _treeViewer;
    private int _style;
    private ViewerSorter _viewerSorter = null;

    public TreeViewerSelectionDialog(Shell parentShell, String statusMessage, int style) {
        super(parentShell);
        this._statusMessage = statusMessage;
        this._style = style;
        this.setShellStyle(67696);
    }

    public TreeViewerSelectionDialog(Shell parentShell, String statusMessage) {
        this(parentShell, statusMessage, 0);
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this._title = title;
    }

    protected void createTreeViewer(Composite parent) {
        DrillDownComposite drillDown = new DrillDownComposite(parent, 2048);
        GridData spec = new GridData(1808);
        spec.widthHint = 320;
        spec.heightHint = 300;
        drillDown.setLayoutData((Object)spec);
        this._treeViewer = new TreeViewer((Composite)drillDown, this._style);
        drillDown.setChildTree(this._treeViewer);
    }

    private void setTreeViewerProviders() {
        this._treeViewer.setContentProvider((IContentProvider)this._contentProvider);
        this._treeViewer.setLabelProvider((IBaseLabelProvider)this._labelProvider);
        if (this._viewerSorter == null) {
            this._viewerSorter = new ViewerSorter();
        }
        this._treeViewer.setSorter(this._viewerSorter);
        this._treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                _selection = TreeViewerSelectionDialog.this.getSelectedElements((IStructuredSelection)event.getSelection());
                TreeViewerSelectionDialog.this.updateStatus();
            }
        });
        this._treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (item instanceof IFile) {
                        TreeViewerSelectionDialog.this.okPressed();
                    } else if (TreeViewerSelectionDialog.this._treeViewer.getExpandedState(item)) {
                        TreeViewerSelectionDialog.this._treeViewer.collapseToLevel(item, 1);
                    } else {
                        TreeViewerSelectionDialog.this._treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this._treeViewer.setInput(this.findInputElement());
        if (this._filter != null) {
            this._treeViewer.addFilter(this._filter);
        }
    }

    protected void createTreeViewerComposite(Composite parent) {
        Composite treeViewerComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        treeViewerComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        treeViewerComposite.setLayoutData((Object)gridData);
        Label label = new Label(treeViewerComposite, 64);
        label.setText(this._title);
        label.setFont(treeViewerComposite.getFont());
        this.createTreeViewer(treeViewerComposite);
        Dialog.applyDialogFont((Control)treeViewerComposite);
    }

    public void setSelectedElement(Object[] selection) {
        if (selection == null) {
            return;
        }
        int i = 0;
        while (i < selection.length) {
            if (_selection[i] != null) {
                this._treeViewer.expandToLevel(_selection[i], 1);
            }
            ++i;
        }
        this._treeViewer.setSelection((ISelection)new StructuredSelection(selection), true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        area.setLayout((Layout)gridLayout);
        this.createTreeViewerComposite(area);
        this._statusImage = this.createLabel(area);
        this._statusImage.setImage(this.getMessageImage(2));
        this._statusLabel = this.createLabel(area);
        this.setTreeViewerProviders();
        return this.dialogArea;
    }

    private Label createLabel(Composite parent) {
        Label label = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        label.setText(this._statusMessage == null ? "" : this._statusMessage);
        return label;
    }

    private Object[] getSelectedElements(IStructuredSelection selection) {
        return selection.toArray();
    }

    public void setContentProvider(ITreeContentProvider provider) {
        this._contentProvider = provider;
    }

    public void setLabelProvider(ILabelProvider provider) {
        this._labelProvider = provider;
    }

    public void setFilter(ViewerFilter filter) {
        this._filter = filter;
    }

    public void setViewerSorter(ViewerSorter sorter) {
        this._viewerSorter = sorter;
    }

    public void setStatusMessage(String message) {
        this._statusMessage = message;
    }

    private void updateStatus() {
        Object selection = _selection;
        if (_selection != null && _selection.length == 1) {
            selection = _selection[0];
        }
        if (this.isValidSelection(selection)) {
            this._statusImage.setVisible(false);
            this._statusLabel.setText("");
            this.getOkButton().setEnabled(true);
        } else {
            this._statusImage.setVisible(true);
            this._statusImage.setImage(this.getMessageImage(2));
            this._statusImage.redraw();
            this._statusLabel.setText(this._statusMessage);
            this.getOkButton().setEnabled(false);
        }
    }

    protected Image getMessageImage(int imageType) {
        switch (imageType) {
            case 2: {
                return JFaceResources.getImage((String)"dialog_message_error_image");
            }
            case 3: {
                return JFaceResources.getImage((String)"dialog_messasge_warning_image");
            }
            case 1: {
                return JFaceResources.getImage((String)"dialog_messasge_info_image");
            }
        }
        return null;
    }

    protected void okPressed() {
        ArrayList chosenContainerPathList = new ArrayList();
        if (_selection != null) {
            chosenContainerPathList.addAll(Arrays.asList(_selection));
        }
        this.setResult(chosenContainerPathList);
        super.okPressed();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (_selection != null) {
            this.setSelectedElement(_selection);
        }
        return control;
    }

    protected abstract boolean isValidSelection(Object var1);

    protected abstract Object findInputElement();
}

