/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.ui.internal.IJpaPlatformUi;
import org.eclipse.jpt.ui.internal.IJpaUiFactory;
import org.eclipse.jpt.ui.internal.details.IJpaDetailsProvider;
import org.eclipse.jpt.ui.internal.generic.EntitiesGenerator;
import org.eclipse.jpt.ui.internal.java.details.IAttributeMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.details.ITypeMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.details.JavaDetailsProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.BasicMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.DefaultBasicMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.DefaultEmbeddedMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.EmbeddableUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.EmbeddedIdMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.EmbeddedMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.EntityUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.IdMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.ManyToManyMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.ManyToOneMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.MappedSuperclassUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.NullTypeMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.OneToManyMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.OneToOneMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.TransientMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.VersionMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.structure.JavaStructureProvider;
import org.eclipse.jpt.ui.internal.structure.IJpaStructureProvider;
import org.eclipse.jpt.ui.internal.xml.details.XmlDetailsProvider;
import org.eclipse.jpt.ui.internal.xml.structure.XmlStructureProvider;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseJpaPlatformUi
implements IJpaPlatformUi {
    private Collection<IJpaDetailsProvider> detailsProviders;
    private Collection<IJpaStructureProvider> structureProviders;
    private List<ITypeMappingUiProvider> javaTypeMappingUiProviders;
    private List<IAttributeMappingUiProvider> javaAttributeMappingUiProviders;
    private List<IAttributeMappingUiProvider> defaultJavaAttributeMappingUiProviders;
    private IJpaUiFactory jpaUiFactory = this.createJpaUiFactory();

    protected BaseJpaPlatformUi() {
    }

    protected abstract IJpaUiFactory createJpaUiFactory();

    @Override
    public IJpaUiFactory getJpaUiFactory() {
        return this.jpaUiFactory;
    }

    @Override
    public Iterator<IJpaDetailsProvider> detailsProviders() {
        if (this.detailsProviders == null) {
            this.detailsProviders = new ArrayList<IJpaDetailsProvider>();
            this.addDetailsProvidersTo(this.detailsProviders);
        }
        return new CloneIterator(this.detailsProviders);
    }

    protected void addDetailsProvidersTo(Collection<IJpaDetailsProvider> providers) {
        providers.add(new JavaDetailsProvider());
        providers.add(new XmlDetailsProvider());
    }

    @Override
    public IJpaDetailsProvider detailsProvider(String fileContentType) {
        Iterator<IJpaDetailsProvider> i = this.detailsProviders();
        while (i.hasNext()) {
            IJpaDetailsProvider provider = i.next();
            if (!provider.fileContentType().equals(fileContentType)) continue;
            return provider;
        }
        return null;
    }

    @Override
    public Iterator<IJpaStructureProvider> structureProviders() {
        if (this.structureProviders == null) {
            this.structureProviders = new ArrayList<IJpaStructureProvider>();
            this.addStructureProvidersTo(this.structureProviders);
        }
        return new CloneIterator(this.structureProviders);
    }

    protected void addStructureProvidersTo(Collection<IJpaStructureProvider> providers) {
        providers.add(new JavaStructureProvider());
        providers.add(new XmlStructureProvider());
    }

    @Override
    public IJpaStructureProvider structureProvider(String fileContentType) {
        Iterator<IJpaStructureProvider> i = this.structureProviders();
        while (i.hasNext()) {
            IJpaStructureProvider provider = i.next();
            if (!provider.fileContentType().equals(fileContentType)) continue;
            return provider;
        }
        return null;
    }

    @Override
    public ListIterator<ITypeMappingUiProvider> javaTypeMappingUiProviders() {
        if (this.javaTypeMappingUiProviders == null) {
            this.javaTypeMappingUiProviders = new ArrayList<ITypeMappingUiProvider>();
            this.addJavaTypeMappingUiProvidersTo(this.javaTypeMappingUiProviders);
        }
        return new CloneListIterator(this.javaTypeMappingUiProviders);
    }

    protected void addJavaTypeMappingUiProvidersTo(List<ITypeMappingUiProvider> providers) {
        providers.add(NullTypeMappingUiProvider.instance());
        providers.add(EntityUiProvider.instance());
        providers.add(MappedSuperclassUiProvider.instance());
        providers.add(EmbeddableUiProvider.instance());
    }

    @Override
    public ListIterator<IAttributeMappingUiProvider> javaAttributeMappingUiProviders() {
        if (this.javaAttributeMappingUiProviders == null) {
            this.javaAttributeMappingUiProviders = new ArrayList<IAttributeMappingUiProvider>();
            this.addJavaAttributeMappingUiProvidersTo(this.javaAttributeMappingUiProviders);
        }
        return new CloneListIterator(this.javaAttributeMappingUiProviders);
    }

    protected void addJavaAttributeMappingUiProvidersTo(List<IAttributeMappingUiProvider> providers) {
        providers.add(BasicMappingUiProvider.instance());
        providers.add(EmbeddedMappingUiProvider.instance());
        providers.add(EmbeddedIdMappingUiProvider.instance());
        providers.add(IdMappingUiProvider.instance());
        providers.add(ManyToManyMappingUiProvider.instance());
        providers.add(ManyToOneMappingUiProvider.instance());
        providers.add(OneToManyMappingUiProvider.instance());
        providers.add(OneToOneMappingUiProvider.instance());
        providers.add(TransientMappingUiProvider.instance());
        providers.add(VersionMappingUiProvider.instance());
    }

    @Override
    public ListIterator<IAttributeMappingUiProvider> defaultJavaAttributeMappingUiProviders() {
        if (this.defaultJavaAttributeMappingUiProviders == null) {
            this.defaultJavaAttributeMappingUiProviders = new ArrayList<IAttributeMappingUiProvider>();
            this.addDefaultJavaAttributeMappingUiProvidersTo(this.defaultJavaAttributeMappingUiProviders);
        }
        return new CloneListIterator(this.defaultJavaAttributeMappingUiProviders);
    }

    protected void addDefaultJavaAttributeMappingUiProvidersTo(List<IAttributeMappingUiProvider> providers) {
        providers.add(DefaultBasicMappingUiProvider.instance());
        providers.add(DefaultEmbeddedMappingUiProvider.instance());
    }

    @Override
    public void generateEntities(IJpaProject project, IStructuredSelection selection) {
        EntitiesGenerator.generate(project, selection);
    }
}

