/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.content.orm.EntityMappingsInternal;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.JptUiPlugin;
import org.eclipse.jpt.ui.internal.java.details.ITypeMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.EmbeddableUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.EntityUiProvider;
import org.eclipse.jpt.ui.internal.java.mappings.properties.MappedSuperclassUiProvider;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.IProgressService;

public class AddPersistentClassDialog
extends StatusDialog {
    private EntityMappingsInternal entityMappings;
    private Text classText;
    private Button classBrowseButton;
    private ComboViewer mappingCombo;

    public AddPersistentClassDialog(Shell parentShell, EntityMappingsInternal entityMappings) {
        super(parentShell);
        this.entityMappings = entityMappings;
        this.setTitle(JptUiMessages.AddPersistentClassDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createLabel(composite, 2, JptUiMessages.AddPersistentClassDialog_classLabel);
        this.classText = this.createText(composite, 1);
        this.classText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddPersistentClassDialog.this.validate();
            }
        });
        this.classBrowseButton = this.createButton(composite, 1, JptUiMessages.General_browse);
        this.classBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IType type = AddPersistentClassDialog.this.chooseType();
                if (type != null) {
                    AddPersistentClassDialog.this.classText.setText(type.getFullyQualifiedName());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.createLabel(composite, 2, JptUiMessages.AddPersistentClassDialog_mappingLabel);
        this.mappingCombo = new ComboViewer(this.createCombo(composite, 2));
        this.mappingCombo.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return new Object[]{MappedSuperclassUiProvider.instance(), EntityUiProvider.instance(), EmbeddableUiProvider.instance()};
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.mappingCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ITypeMappingUiProvider)element).label();
            }
        });
        this.mappingCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddPersistentClassDialog.this.validate();
            }
        });
        this.mappingCombo.setInput((Object)"FOO");
        this.mappingCombo.getCombo().select(1);
        AddPersistentClassDialog.applyDialogFont((Control)dialogArea);
        this.validate();
        return dialogArea;
    }

    private Label createLabel(Composite container, int span, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        label.setLayoutData((Object)gd);
        return label;
    }

    private Text createText(Composite container, int span) {
        Text text = new Text(container, 2052);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        gd.widthHint = 250;
        text.setLayoutData((Object)gd);
        return text;
    }

    private Button createButton(Composite container, int span, String text) {
        Button button = new Button(container, 0);
        button.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        button.setLayoutData((Object)gd);
        return button;
    }

    private Combo createCombo(Composite container, int span) {
        Combo combo = new Combo(container, 2060);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        combo.setLayoutData((Object)gd);
        return combo;
    }

    private IJpaProject getJpaProject() {
        return this.entityMappings.getJpaProject();
    }

    public String getClassName() {
        return this.classText.getText();
    }

    public String getMappingKey() {
        StructuredSelection selection = (StructuredSelection)this.mappingCombo.getSelection();
        return selection.isEmpty() ? null : ((ITypeMappingUiProvider)selection.getFirstElement()).mappingKey();
    }

    protected IType chooseType() {
        SelectionDialog typeSelectionDialog;
        IJavaElement[] elements = new IJavaElement[]{this.getJpaProject().javaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            typeSelectionDialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)service, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)this.getClassName());
        }
        catch (JavaModelException e) {
            JptUiPlugin.log(e);
            throw new RuntimeException(e);
        }
        typeSelectionDialog.setTitle(JptUiMessages.AddPersistentClassDialog_classDialog_title);
        typeSelectionDialog.setMessage(JptUiMessages.AddPersistentClassDialog_classDialog_message);
        if (typeSelectionDialog.open() == 0) {
            return (IType)typeSelectionDialog.getResult()[0];
        }
        return null;
    }

    private void validate() {
        IType type;
        String className = this.getClassName();
        if (StringTools.stringIsEmpty((String)className)) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.jpt.ui", JptUiMessages.AddPersistentClassDialog_noClassError));
            return;
        }
        try {
            type = this.getJpaProject().javaProject().findType(className);
        }
        catch (JavaModelException javaModelException) {
            type = null;
        }
        if (type == null) {
            this.updateStatus((IStatus)new Status(2, "org.eclipse.jpt.ui", JptUiMessages.AddPersistentClassDialog_classNotFoundWarning));
            return;
        }
        if (this.entityMappings.containsPersistentType(type)) {
            this.updateStatus((IStatus)new Status(2, "org.eclipse.jpt.ui", JptUiMessages.AddPersistentClassDialog_duplicateClassWarning));
            return;
        }
        String mappingKey = this.getMappingKey();
        if (mappingKey == null) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.jpt.ui", JptUiMessages.AddPersistentClassDialog_noMappingKeyError));
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }

    protected void okPressed() {
        this.entityMappings.addMapping(this.getClassName(), this.getMappingKey());
        super.okPressed();
    }
}

