/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Iterator;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jpt.core.internal.mappings.ITable;
import org.eclipse.jpt.db.internal.ConnectionListener;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.db.internal.Database;
import org.eclipse.jpt.db.internal.Schema;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.ui.internal.details.BaseJpaController;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class CatalogCombo
extends BaseJpaController {
    private ITable table;
    private Adapter listener = this.buildTableListener();
    private ConnectionProfile connectionProfile;
    private ConnectionListener connectionListener = this.buildConnectionListener();
    private CCombo combo;

    public CatalogCombo(Composite parent, CommandStack theCommandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, theCommandStack, widgetFactory);
    }

    private Adapter buildTableListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                CatalogCombo.this.catalogChanged(notification);
            }
        };
    }

    private ConnectionListener buildConnectionListener() {
        return new ConnectionListener(){

            public void aboutToClose(ConnectionProfile profile) {
            }

            public void closed(ConnectionProfile profile) {
                CatalogCombo.this.getCombo().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (CatalogCombo.this.getControl().isDisposed()) {
                            return;
                        }
                        CatalogCombo.this.populateCatalogCombo();
                    }
                });
            }

            public void modified(ConnectionProfile profile) {
                CatalogCombo.this.getCombo().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (CatalogCombo.this.getControl().isDisposed()) {
                            return;
                        }
                        CatalogCombo.this.populateCatalogCombo();
                    }
                });
            }

            public boolean okToClose(ConnectionProfile profile) {
                return true;
            }

            public void opened(ConnectionProfile profile) {
                CatalogCombo.this.getCombo().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (CatalogCombo.this.getControl().isDisposed()) {
                            return;
                        }
                        CatalogCombo.this.populateCatalogCombo();
                    }
                });
            }

            public void databaseChanged(ConnectionProfile profile, final Database database) {
                CatalogCombo.this.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (database == CatalogCombo.this.getDatabase() && !CatalogCombo.this.getControl().isDisposed()) {
                            CatalogCombo.this.populateCatalogCombo();
                        }
                    }
                });
            }

            public void schemaChanged(ConnectionProfile profile, Schema schema) {
            }

            public void tableChanged(ConnectionProfile profile, Table table) {
            }
        };
    }

    protected void buildWidget(Composite parent) {
        this.combo = this.getWidgetFactory().createCCombo(parent, 0x800008);
        this.combo.add(JptUiMappingsMessages.TableComposite_defaultEmpty);
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CatalogCombo.this.isPopulating()) {
                    return;
                }
                String catalogText = ((CCombo)e.getSource()).getText();
                if (catalogText.equals("")) {
                    catalogText = null;
                    if (CatalogCombo.this.table.getSpecifiedCatalog() == null || CatalogCombo.this.table.getSpecifiedCatalog().equals("")) {
                        return;
                    }
                }
                if (catalogText != null && CatalogCombo.this.combo.getItemCount() > 0 && catalogText.equals(CatalogCombo.this.combo.getItem(0))) {
                    catalogText = null;
                }
                if (CatalogCombo.this.table.getSpecifiedCatalog() == null && catalogText != null) {
                    CatalogCombo.this.setSpecifiedCatalog(catalogText);
                }
                if (CatalogCombo.this.table.getSpecifiedCatalog() != null && !CatalogCombo.this.table.getSpecifiedCatalog().equals(catalogText)) {
                    CatalogCombo.this.setSpecifiedCatalog(catalogText);
                }
            }
        });
    }

    private void setSpecifiedCatalog(String catalogName) {
        this.table.setSpecifiedCatalog(catalogName);
        this.getConnectionProfile().setCatalogName(catalogName);
    }

    protected void catalogChanged(Notification notification) {
        if (notification.getFeatureID(ITable.class) == 4) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (CatalogCombo.this.getControl().isDisposed()) {
                        return;
                    }
                    CatalogCombo.this.populateCatalogName();
                }
            });
        } else if (notification.getFeatureID(ITable.class) == 5) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (CatalogCombo.this.getControl().isDisposed()) {
                        return;
                    }
                    CatalogCombo.this.populateDefaultCatalogName();
                }
            });
        }
    }

    public void doPopulate(EObject obj) {
        this.table = (ITable)obj;
        if (this.table != null) {
            this.populateCatalogCombo();
        } else {
            this.connectionProfile = null;
        }
    }

    public void doPopulate() {
        this.populateCatalogCombo();
    }

    protected Database getDatabase() {
        return this.getConnectionProfile().getDatabase();
    }

    private ConnectionProfile getConnectionProfile() {
        if (this.connectionProfile == null) {
            this.connectionProfile = this.table.getJpaProject().connectionProfile();
        }
        return this.connectionProfile;
    }

    private void populateCatalogCombo() {
        if (this.table == null) {
            return;
        }
        this.populateDefaultCatalogName();
        if (this.getConnectionProfile().isConnected()) {
            this.combo.remove(1, this.combo.getItemCount() - 1);
            Database database = this.getDatabase();
            if (database != null) {
                Iterator catalogs = database.catalogNames();
                Iterator stream = CollectionTools.sort((Iterator)catalogs);
                while (stream.hasNext()) {
                    this.combo.add((String)stream.next());
                }
            }
        } else {
            this.combo.remove(1, this.combo.getItemCount() - 1);
        }
        this.populateCatalogName();
    }

    protected void populateDefaultCatalogName() {
        String defaultCatalogName = this.getDatabase().getDefaultCatalogName();
        int selectionIndex = this.combo.getSelectionIndex();
        this.combo.setItem(0, NLS.bind((String)JptUiMappingsMessages.TableComposite_defaultWithOneParam, (Object)defaultCatalogName));
        if (selectionIndex == 0) {
            this.combo.clearSelection();
            this.combo.select(0);
        }
    }

    protected void populateCatalogName() {
        if (this.table == null) {
            return;
        }
        String catalogName = this.table.getSpecifiedCatalog();
        String defaultCatalogName = this.getDatabase().getDefaultCatalogName();
        if (!StringTools.stringIsEmpty((String)catalogName)) {
            if (!this.combo.getText().equals(catalogName)) {
                this.combo.setText(catalogName);
            }
        } else if (!this.combo.getText().equals(NLS.bind((String)JptUiMappingsMessages.TableComposite_defaultWithOneParam, (Object)defaultCatalogName))) {
            this.combo.select(0);
        }
    }

    public CCombo getCombo() {
        return this.combo;
    }

    public Control getControl() {
        return this.getCombo();
    }

    protected void disengageListeners() {
        if (this.table != null) {
            this.removeConnectionListener();
            this.table.eAdapters().remove((Object)this.listener);
        }
    }

    protected void engageListeners() {
        if (this.table != null) {
            this.table.eAdapters().add((Object)this.listener);
            this.addConnectionListener();
        }
    }

    private void addConnectionListener() {
        this.getConnectionProfile().addConnectionListener(this.connectionListener);
    }

    private void removeConnectionListener() {
        this.getConnectionProfile().removeConnectionListener(this.connectionListener);
    }
}

