/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Iterator;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.core.internal.mappings.IAbstractJoinColumn;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.INamedColumn;
import org.eclipse.jpt.core.internal.mappings.IPrimaryKeyJoinColumn;
import org.eclipse.jpt.ui.internal.details.BaseJpaComposite;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.PrimaryKeyJoinColumnDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class PrimaryKeyJoinColumnsComposite
extends BaseJpaComposite {
    private IEntity entity;
    private final Adapter entityListener = this.buildEntityListener();
    private final Adapter pkJoinColumnListener = this.buildPkJoinColumnListener();
    ListViewer pkJoinColumnsListViewer;
    private Group pkJoinColumnsGroup;
    Button overrideDefaultJoinColumnsCheckBox;
    private Button pkJoinColumnsRemoveButton;
    private Button pkJoinColumnsEditButton;

    public PrimaryKeyJoinColumnsComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0, commandStack, widgetFactory);
    }

    private Adapter buildEntityListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                PrimaryKeyJoinColumnsComposite.this.entityChanged(notification);
            }
        };
    }

    private Adapter buildPkJoinColumnListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                PrimaryKeyJoinColumnsComposite.this.pkJoinColumnChanged(notification);
            }
        };
    }

    protected void initializeLayout(Composite composite) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        this.overrideDefaultJoinColumnsCheckBox = this.getWidgetFactory().createButton(composite, JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_overrideDefaultPrimaryKeyJoinColumns, 32);
        this.overrideDefaultJoinColumnsCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (PrimaryKeyJoinColumnsComposite.this.overrideDefaultJoinColumnsCheckBox.getSelection()) {
                    IPrimaryKeyJoinColumn defaultJoinColumn = (IPrimaryKeyJoinColumn)PrimaryKeyJoinColumnsComposite.this.entity.getDefaultPrimaryKeyJoinColumns().get(0);
                    String columnName = defaultJoinColumn.getDefaultName();
                    String referencedColumnName = defaultJoinColumn.getDefaultReferencedColumnName();
                    IPrimaryKeyJoinColumn pkJoinColumn = PrimaryKeyJoinColumnsComposite.this.entity.createPrimaryKeyJoinColumn(0);
                    PrimaryKeyJoinColumnsComposite.this.entity.getSpecifiedPrimaryKeyJoinColumns().add((Object)pkJoinColumn);
                    pkJoinColumn.setSpecifiedName(columnName);
                    pkJoinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
                } else {
                    PrimaryKeyJoinColumnsComposite.this.entity.getSpecifiedPrimaryKeyJoinColumns().clear();
                }
            }
        });
        this.pkJoinColumnsGroup = this.getWidgetFactory().createGroup(composite, JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_primaryKeyJoinColumn);
        this.pkJoinColumnsGroup.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.pkJoinColumnsGroup.setLayoutData((Object)gridData);
        this.pkJoinColumnsListViewer = new ListViewer((Composite)this.pkJoinColumnsGroup, 2050);
        this.pkJoinColumnsListViewer.setContentProvider(this.buildJoinColumnsListContentProvider());
        this.pkJoinColumnsListViewer.setLabelProvider((IBaseLabelProvider)this.buildJoinColumnsListLabelProvider());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.pkJoinColumnsListViewer.getList().setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.pkJoinColumnsListViewer.getList(), "org.eclipse.jpt.ui.mapping_joinTableJoinColumns");
        Button addJoinColumnButton = this.getWidgetFactory().createButton((Composite)this.pkJoinColumnsGroup, JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_add, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        addJoinColumnButton.setLayoutData((Object)gridData);
        addJoinColumnButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PrimaryKeyJoinColumnsComposite.this.addPrimaryKeyJoinColumn();
            }
        });
        this.pkJoinColumnsEditButton = this.getWidgetFactory().createButton((Composite)this.pkJoinColumnsGroup, JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_edit, 0);
        this.pkJoinColumnsEditButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PrimaryKeyJoinColumnsComposite.this.editPrimaryKeyJoinColumn();
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.pkJoinColumnsEditButton.setLayoutData((Object)gridData);
        this.pkJoinColumnsRemoveButton = this.getWidgetFactory().createButton((Composite)this.pkJoinColumnsGroup, JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_remove, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.pkJoinColumnsRemoveButton.setLayoutData((Object)gridData);
        this.pkJoinColumnsRemoveButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PrimaryKeyJoinColumnsComposite.this.removePrimaryKeyJoinColumn();
            }
        });
        this.pkJoinColumnsListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PrimaryKeyJoinColumnsComposite.this.updatePrimaryKeyJoinColumnsEnablement();
            }
        });
    }

    private IContentProvider buildJoinColumnsListContentProvider() {
        return new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((IEntity)inputElement).getPrimaryKeyJoinColumns().toArray();
            }
        };
    }

    private ILabelProvider buildJoinColumnsListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                IPrimaryKeyJoinColumn joinColumn = (IPrimaryKeyJoinColumn)element;
                return PrimaryKeyJoinColumnsComposite.this.entity.containsSpecifiedPrimaryKeyJoinColumns() ? PrimaryKeyJoinColumnsComposite.this.buildJoinColumnLabel(joinColumn) : PrimaryKeyJoinColumnsComposite.this.buildDefaultJoinColumnLabel(joinColumn);
            }
        };
    }

    String buildDefaultJoinColumnLabel(IPrimaryKeyJoinColumn joinColumn) {
        return NLS.bind((String)JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
    }

    String buildJoinColumnLabel(IPrimaryKeyJoinColumn joinColumn) {
        if (joinColumn.getSpecifiedName() == null) {
            if (joinColumn.getSpecifiedReferencedColumnName() == null) {
                return NLS.bind((String)JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsBothDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
            }
            return NLS.bind((String)JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsFirstDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedReferencedColumnName() == null) {
            return NLS.bind((String)JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsSecDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        return NLS.bind((String)JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParams, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
    }

    void addPrimaryKeyJoinColumn() {
        PrimaryKeyJoinColumnDialog dialog = new PrimaryKeyJoinColumnDialog(this.getControl().getShell(), this.entity);
        this.addJoinColumnFromDialog(dialog);
    }

    private void addJoinColumnFromDialog(PrimaryKeyJoinColumnDialog dialog) {
        if (dialog.open() == 0) {
            int index = this.entity.getSpecifiedPrimaryKeyJoinColumns().size();
            String name = dialog.getSelectedName();
            String referencedColumnName = dialog.getReferencedColumnName();
            IPrimaryKeyJoinColumn joinColumn = this.entity.createPrimaryKeyJoinColumn(index);
            this.entity.getSpecifiedPrimaryKeyJoinColumns().add((Object)joinColumn);
            joinColumn.setSpecifiedName(name);
            joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
        }
    }

    private IPrimaryKeyJoinColumn getSelectedJoinColumn() {
        return (IPrimaryKeyJoinColumn)((StructuredSelection)this.pkJoinColumnsListViewer.getSelection()).getFirstElement();
    }

    void editPrimaryKeyJoinColumn() {
        IPrimaryKeyJoinColumn joinColumn = this.getSelectedJoinColumn();
        PrimaryKeyJoinColumnDialog dialog = new PrimaryKeyJoinColumnDialog(this.getControl().getShell(), joinColumn);
        this.editJoinColumnFromDialog(dialog, joinColumn);
    }

    private void editJoinColumnFromDialog(PrimaryKeyJoinColumnDialog dialog, IPrimaryKeyJoinColumn joinColumn) {
        if (dialog.open() == 0) {
            this.editJoinColumnDialogOkd(dialog, joinColumn);
        }
    }

    private void editJoinColumnDialogOkd(PrimaryKeyJoinColumnDialog dialog, IPrimaryKeyJoinColumn joinColumn) {
        String name = dialog.getSelectedName();
        String referencedColumnName = dialog.getReferencedColumnName();
        if (dialog.isDefaultNameSelected()) {
            if (joinColumn.getSpecifiedName() != null) {
                joinColumn.setSpecifiedName(null);
            }
        } else if (joinColumn.getSpecifiedName() == null || !joinColumn.getSpecifiedName().equals(name)) {
            joinColumn.setSpecifiedName(name);
        }
        if (dialog.isDefaultReferencedColumnNameSelected()) {
            if (joinColumn.getSpecifiedReferencedColumnName() != null) {
                joinColumn.setSpecifiedReferencedColumnName(null);
            }
        } else if (joinColumn.getSpecifiedReferencedColumnName() == null || !joinColumn.getSpecifiedReferencedColumnName().equals(referencedColumnName)) {
            joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
        }
    }

    void removePrimaryKeyJoinColumn() {
        ISelection selection = this.pkJoinColumnsListViewer.getSelection();
        if (selection instanceof StructuredSelection) {
            Iterator i = ((StructuredSelection)selection).iterator();
            while (i.hasNext()) {
                this.entity.getPrimaryKeyJoinColumns().remove(i.next());
            }
        }
    }

    void updatePrimaryKeyJoinColumnsEnablement() {
        boolean groupEnabledState = this.entity.containsSpecifiedPrimaryKeyJoinColumns();
        this.enableGroup(this.pkJoinColumnsGroup, groupEnabledState);
        this.pkJoinColumnsRemoveButton.setEnabled(groupEnabledState && !((StructuredSelection)this.pkJoinColumnsListViewer.getSelection()).isEmpty());
        this.pkJoinColumnsEditButton.setEnabled(groupEnabledState && ((StructuredSelection)this.pkJoinColumnsListViewer.getSelection()).size() == 1);
    }

    private void enableGroup(Group group, boolean enabled) {
        group.setEnabled(enabled);
        int i = 0;
        while (i < group.getChildren().length) {
            group.getChildren()[i].setEnabled(enabled);
            ++i;
        }
    }

    public void doPopulate(EObject obj) {
        this.entity = (IEntity)obj;
        if (this.entity == null) {
            this.pkJoinColumnsListViewer.setInput(null);
            return;
        }
        this.pkJoinColumnsListViewer.setInput((Object)this.entity);
        this.updatePrimaryKeyJoinColumnsEnablement();
        this.overrideDefaultJoinColumnsCheckBox.setSelection(this.entity.containsSpecifiedPrimaryKeyJoinColumns());
    }

    protected void doPopulate() {
    }

    protected void engageListeners() {
        if (this.entity != null) {
            this.entity.eAdapters().add((Object)this.entityListener);
            for (IPrimaryKeyJoinColumn pkJoinColumn : this.entity.getPrimaryKeyJoinColumns()) {
                pkJoinColumn.eAdapters().add((Object)this.pkJoinColumnListener);
            }
        }
    }

    protected void disengageListeners() {
        if (this.entity != null) {
            for (IPrimaryKeyJoinColumn pkJoinColumn : this.entity.getPrimaryKeyJoinColumns()) {
                pkJoinColumn.eAdapters().remove((Object)this.pkJoinColumnListener);
            }
            this.entity.eAdapters().remove((Object)this.entityListener);
        }
    }

    protected void entityChanged(Notification notification) {
        if (notification.getFeatureID(IEntity.class) == 7) {
            if (notification.getEventType() == 3) {
                ((IPrimaryKeyJoinColumn)notification.getNewValue()).eAdapters().add((Object)this.pkJoinColumnListener);
            } else if (notification.getEventType() == 4) {
                ((IPrimaryKeyJoinColumn)notification.getOldValue()).eAdapters().remove((Object)this.pkJoinColumnListener);
            }
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (PrimaryKeyJoinColumnsComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    PrimaryKeyJoinColumnsComposite.this.pkJoinColumnsListViewer.refresh();
                    PrimaryKeyJoinColumnsComposite.this.overrideDefaultJoinColumnsCheckBox.setSelection(PrimaryKeyJoinColumnsComposite.this.entity.containsSpecifiedPrimaryKeyJoinColumns());
                    PrimaryKeyJoinColumnsComposite.this.updatePrimaryKeyJoinColumnsEnablement();
                }
            });
        }
    }

    protected void pkJoinColumnChanged(Notification notification) {
        if (notification.getFeatureID(INamedColumn.class) == 1 || notification.getFeatureID(IAbstractJoinColumn.class) == 5 || notification.getFeatureID(INamedColumn.class) == 2 || notification.getFeatureID(IAbstractJoinColumn.class) == 6) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (PrimaryKeyJoinColumnsComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    PrimaryKeyJoinColumnsComposite.this.pkJoinColumnsListViewer.refresh();
                }
            });
        }
    }
}

