/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Iterator;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jpt.core.internal.mappings.ITable;
import org.eclipse.jpt.db.internal.ConnectionListener;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.db.internal.Database;
import org.eclipse.jpt.db.internal.Schema;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.ui.internal.details.BaseJpaController;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class SchemaCombo
extends BaseJpaController {
    private ITable table;
    private Adapter listener = this.buildTableListener();
    private ConnectionProfile connectionProfile;
    private ConnectionListener connectionListener = this.buildConnectionListener();
    private CCombo combo;

    public SchemaCombo(Composite parent, CommandStack theCommandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, theCommandStack, widgetFactory);
    }

    private Adapter buildTableListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                SchemaCombo.this.schemaChanged(notification);
            }
        };
    }

    private ConnectionListener buildConnectionListener() {
        return new ConnectionListener(){

            public void aboutToClose(ConnectionProfile profile) {
            }

            public void closed(ConnectionProfile profile) {
                SchemaCombo.this.getCombo().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (SchemaCombo.this.getControl().isDisposed()) {
                            return;
                        }
                        SchemaCombo.this.populateShemaCombo();
                    }
                });
            }

            public void modified(ConnectionProfile profile) {
                SchemaCombo.this.getCombo().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (SchemaCombo.this.getControl().isDisposed()) {
                            return;
                        }
                        SchemaCombo.this.populateShemaCombo();
                    }
                });
            }

            public boolean okToClose(ConnectionProfile profile) {
                return true;
            }

            public void opened(ConnectionProfile profile) {
                SchemaCombo.this.getCombo().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (SchemaCombo.this.getControl().isDisposed()) {
                            return;
                        }
                        SchemaCombo.this.populateShemaCombo();
                    }
                });
            }

            public void databaseChanged(ConnectionProfile profile, final Database database) {
                SchemaCombo.this.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (database == SchemaCombo.this.getDatabase() && !SchemaCombo.this.getControl().isDisposed()) {
                            SchemaCombo.this.populateShemaCombo();
                        }
                    }
                });
            }

            public void schemaChanged(ConnectionProfile profile, final Schema schema) {
                SchemaCombo.this.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (schema == SchemaCombo.this.getTableSchema() && !SchemaCombo.this.getControl().isDisposed()) {
                            SchemaCombo.this.populateShemaCombo();
                        }
                    }
                });
            }

            public void tableChanged(ConnectionProfile profile, Table table) {
            }
        };
    }

    protected void buildWidget(Composite parent) {
        this.combo = this.getWidgetFactory().createCCombo(parent, 0x800000);
        this.combo.add(JptUiMappingsMessages.TableComposite_defaultEmpty);
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SchemaCombo.this.isPopulating()) {
                    return;
                }
                String schemaText = ((CCombo)e.getSource()).getText();
                if (schemaText.equals("")) {
                    schemaText = null;
                    if (SchemaCombo.this.table.getSpecifiedSchema() == null || SchemaCombo.this.table.getSpecifiedSchema().equals("")) {
                        return;
                    }
                }
                if (schemaText != null && SchemaCombo.this.combo.getItemCount() > 0 && schemaText.equals(SchemaCombo.this.combo.getItem(0))) {
                    schemaText = null;
                }
                if (SchemaCombo.this.table.getSpecifiedSchema() == null && schemaText != null) {
                    SchemaCombo.this.table.setSpecifiedSchema(schemaText);
                }
                if (SchemaCombo.this.table.getSpecifiedSchema() != null && !SchemaCombo.this.table.getSpecifiedSchema().equals(schemaText)) {
                    SchemaCombo.this.table.setSpecifiedSchema(schemaText);
                }
            }
        });
    }

    protected void schemaChanged(Notification notification) {
        if (notification.getFeatureID(ITable.class) == 7) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (SchemaCombo.this.getControl().isDisposed()) {
                        return;
                    }
                    SchemaCombo.this.populateSchemaName();
                }
            });
        } else if (notification.getFeatureID(ITable.class) == 8) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (SchemaCombo.this.getControl().isDisposed()) {
                        return;
                    }
                    SchemaCombo.this.populateDefaultSchemaName();
                }
            });
        } else if (notification.getFeatureID(ITable.class) == 5) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (SchemaCombo.this.getControl().isDisposed()) {
                        return;
                    }
                    SchemaCombo.this.populateShemaCombo();
                }
            });
        } else if (notification.getFeatureID(ITable.class) == 4) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (SchemaCombo.this.getControl().isDisposed()) {
                        return;
                    }
                    SchemaCombo.this.populateShemaCombo();
                }
            });
        }
    }

    public void doPopulate(EObject obj) {
        this.table = (ITable)obj;
        if (this.table != null) {
            this.populateShemaCombo();
        } else {
            this.connectionProfile = null;
        }
    }

    public void doPopulate() {
        this.populateShemaCombo();
    }

    protected Database getDatabase() {
        return this.getConnectionProfile().getDatabase();
    }

    private ConnectionProfile getConnectionProfile() {
        if (this.connectionProfile == null) {
            this.connectionProfile = this.table.getJpaProject().connectionProfile();
        }
        return this.connectionProfile;
    }

    private void populateShemaCombo() {
        if (this.table == null) {
            return;
        }
        this.populateDefaultSchemaName();
        if (this.getConnectionProfile().isConnected()) {
            this.combo.remove(1, this.combo.getItemCount() - 1);
            Database database = this.getDatabase();
            if (database != null) {
                Iterator schemata = database.schemaNames();
                Iterator stream = CollectionTools.sort((Iterator)schemata);
                while (stream.hasNext()) {
                    this.combo.add((String)stream.next());
                }
            }
        } else {
            this.combo.remove(1, this.combo.getItemCount() - 1);
        }
        this.populateSchemaName();
    }

    protected void populateDefaultSchemaName() {
        String defaultSchemaName = this.table.getDefaultSchema();
        int selectionIndex = this.combo.getSelectionIndex();
        this.combo.setItem(0, NLS.bind((String)JptUiMappingsMessages.TableComposite_defaultWithOneParam, (Object)defaultSchemaName));
        if (selectionIndex == 0) {
            this.combo.clearSelection();
            this.combo.select(0);
        }
    }

    protected void populateSchemaName() {
        if (this.table == null) {
            return;
        }
        String schemaName = this.table.getSpecifiedSchema();
        String defaultSchemaName = this.table.getDefaultSchema();
        if (!StringTools.stringIsEmpty((String)schemaName)) {
            if (!this.combo.getText().equals(schemaName)) {
                this.combo.setText(schemaName);
            }
        } else if (!this.combo.getText().equals(NLS.bind((String)JptUiMappingsMessages.TableComposite_defaultWithOneParam, (Object)defaultSchemaName))) {
            this.combo.select(0);
        }
    }

    public CCombo getCombo() {
        return this.combo;
    }

    public Control getControl() {
        return this.getCombo();
    }

    protected Schema getTableSchema() {
        return this.getConnectionProfile().getDatabase().schemaNamed(this.table.getSchema());
    }

    protected void disengageListeners() {
        if (this.table != null) {
            this.removeConnectionListener();
            this.table.eAdapters().remove((Object)this.listener);
        }
    }

    protected void engageListeners() {
        if (this.table != null) {
            this.table.eAdapters().add((Object)this.listener);
            this.addConnectionListener();
        }
    }

    private void addConnectionListener() {
        this.getConnectionProfile().addConnectionListener(this.connectionListener);
    }

    private void removeConnectionListener() {
        this.getConnectionProfile().removeConnectionListener(this.connectionListener);
    }
}

