/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jpt.core.internal.mappings.IRelationshipMapping;
import org.eclipse.jpt.ui.internal.details.BaseJpaController;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.CommonWidgets;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class TargetEntityChooser
extends BaseJpaController {
    private IRelationshipMapping relationshipMapping;
    private Adapter relationshipMappingListener;
    protected CCombo targetEntityCombo;
    private Composite composite;

    public TargetEntityChooser(Composite parent, CommandStack theCommandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, theCommandStack, widgetFactory);
        this.buildRelationshipMappingListener();
    }

    private void buildRelationshipMappingListener() {
        this.relationshipMappingListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                TargetEntityChooser.this.relationshipMappingChanged(notification);
            }
        };
    }

    protected void buildWidget(Composite parent) {
        this.composite = this.getWidgetFactory().createComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 3;
        this.composite.setLayout((Layout)gridLayout);
        CommonWidgets.buildTargetEntityLabel(this.composite, this.getWidgetFactory());
        this.targetEntityCombo = this.buildTargetEntityCombo(this.composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.targetEntityCombo.setLayoutData((Object)gridData);
        this.buildTargetEntitySelectionButton(this.composite);
    }

    protected CCombo buildTargetEntityCombo(Composite parent) {
        final CCombo combo = this.getWidgetFactory().createCCombo(parent, 0x800000);
        combo.add(JptUiMappingsMessages.TargetEntityChooser_defaultEmpty);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)combo, "org.eclipse.jpt.ui.mapping_targetEntity");
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TargetEntityChooser.this.isPopulating()) {
                    return;
                }
                String targetEntityName = ((CCombo)e.getSource()).getText();
                if (targetEntityName.equals(combo.getItem(0)) || targetEntityName.equals("")) {
                    targetEntityName = null;
                } else if (!TargetEntityChooser.this.relationshipMapping.targetEntityIsValid(targetEntityName)) {
                    return;
                }
                TargetEntityChooser.this.relationshipMapping.setSpecifiedTargetEntity(targetEntityName);
            }
        });
        return combo;
    }

    private void relationshipMappingChanged(Notification notification) {
        if (notification.getFeatureID(IRelationshipMapping.class) == 1) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    TargetEntityChooser.this.populate();
                }
            });
        } else if (notification.getFeatureID(IRelationshipMapping.class) == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    TargetEntityChooser.this.populate();
                }
            });
        }
    }

    protected void engageListeners() {
        if (this.relationshipMapping != null) {
            this.relationshipMapping.eAdapters().add((Object)this.relationshipMappingListener);
        }
    }

    protected void disengageListeners() {
        if (this.relationshipMapping != null) {
            this.relationshipMapping.eAdapters().remove((Object)this.relationshipMappingListener);
        }
    }

    public void doPopulate(EObject obj) {
        this.relationshipMapping = (IRelationshipMapping)obj;
        this.populateCombo();
    }

    protected void doPopulate() {
        this.populateCombo();
    }

    private void populateCombo() {
        if (this.relationshipMapping == null) {
            this.targetEntityCombo.clearSelection();
            return;
        }
        String targetEntity = this.relationshipMapping.getSpecifiedTargetEntity();
        this.targetEntityCombo.setItem(0, NLS.bind((String)JptUiMappingsMessages.TargetEntityChooser_defaultWithOneParam, (Object)this.relationshipMapping.getDefaultTargetEntity()));
        if (targetEntity != null) {
            if (!this.targetEntityCombo.getText().equals(targetEntity)) {
                this.targetEntityCombo.setText(targetEntity);
            }
        } else if (this.targetEntityCombo.getSelectionIndex() != 0) {
            this.targetEntityCombo.select(0);
        }
    }

    public Control getControl() {
        return this.composite;
    }

    protected Button buildTargetEntitySelectionButton(Composite parent) {
        Button button = this.getWidgetFactory().createButton(parent, JptUiMappingsMessages.TargetEntityChooser_browse, 8);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetEntityChooser.this.browse();
            }
        });
        return button;
    }

    protected void browse() {
        BusyIndicator.showWhile((Display)this.targetEntityCombo.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                TargetEntityChooser.this.doOpenSelectionDialog();
            }
        });
    }

    private void doOpenSelectionDialog() {
        SelectionDialog dialog;
        try {
            dialog = JavaUI.createTypeDialog((Shell)this.getControl().getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)256, (boolean)false, (String)"");
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        dialog.setTitle("Select Type");
        if (dialog.open() == 0) {
            IType type = (IType)dialog.getResult()[0];
            this.targetEntityCombo.setText(type.getFullyQualifiedName('$'));
        }
    }
}

