/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.selection;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jpt.ui.internal.selection.ISelectionManager;
import org.eclipse.jpt.ui.internal.selection.ISelectionParticipant;
import org.eclipse.jpt.ui.internal.selection.Selection;
import org.eclipse.jpt.ui.internal.selection.SelectionEvent;
import org.eclipse.jpt.ui.internal.views.JpaStructureView;

public class JpaStructureSelectionParticipant
implements ISelectionParticipant {
    final JpaStructureView structureView;

    public JpaStructureSelectionParticipant(ISelectionManager selectionManager, JpaStructureView structureView) {
        this.structureView = structureView;
        structureView.addSelectionChangedListener(new StructureViewSelectionListener(selectionManager, structureView));
    }

    public Selection getSelection() {
        return this.structureView.getSelection();
    }

    public void selectionChanged(SelectionEvent evt) {
        this.structureView.select(evt.getSelection());
    }

    public boolean disposeOnHide() {
        return false;
    }

    public void dispose() {
    }

    private class StructureViewSelectionListener
    implements ISelectionChangedListener {
        private final ISelectionManager selectionManager;

        StructureViewSelectionListener(ISelectionManager selectionManager, JpaStructureView structureView) {
            this.selectionManager = selectionManager;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.selectionManager.select(this.structureViewSelection());
        }

        private Selection structureViewSelection() {
            return JpaStructureSelectionParticipant.this.structureView.getSelection();
        }
    }
}

