/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.selection;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jpt.core.internal.IJpaContentNode;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.ui.internal.selection.ISelectionManager;
import org.eclipse.jpt.ui.internal.selection.ISelectionParticipant;
import org.eclipse.jpt.ui.internal.selection.Selection;
import org.eclipse.jpt.ui.internal.selection.SelectionEvent;
import org.eclipse.jpt.ui.internal.views.AbstractJpaView;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextEditorSelectionParticipant
implements ISelectionParticipant {
    private final ISelectionManager selectionManager;
    final ITextEditor textEditor;
    private final IPropertyListener editorInputListener;
    private final ISelectionChangedListener editorSelectionListener;
    private Selection currentSelection;
    private boolean forwardSelection = true;

    public TextEditorSelectionParticipant(ISelectionManager selectionManager, ITextEditor textEditor) {
        this.selectionManager = selectionManager;
        this.textEditor = textEditor;
        this.editorInputListener = new EditorInputListener();
        this.textEditor.addPropertyListener(this.editorInputListener);
        this.editorSelectionListener = new EditorSelectionListener();
        this.postSelectionProvider().addPostSelectionChangedListener(this.editorSelectionListener);
        this.currentSelection = this.calculateSelection();
    }

    public Selection getSelection() {
        return this.currentSelection;
    }

    public void selectionChanged(SelectionEvent evt) {
        Selection newSelection = evt.getSelection();
        if (newSelection == Selection.NULL_SELECTION || newSelection.equals(this.currentSelection)) {
            return;
        }
        this.forwardSelection = false;
        ITextRange textRange = newSelection.getSelectedNode().selectionTextRange();
        if (textRange != null) {
            this.textEditor.selectAndReveal(textRange.getOffset(), textRange.getLength());
        }
        this.forwardSelection = true;
    }

    public boolean disposeOnHide() {
        return true;
    }

    public void dispose() {
        this.textEditor.removePropertyListener(this.editorInputListener);
        this.postSelectionProvider().removePostSelectionChangedListener(this.editorSelectionListener);
    }

    private Selection calculateSelection() {
        ISelection selection = this.textEditor.getSelectionProvider().getSelection();
        if (!(selection instanceof ITextSelection)) {
            return Selection.NULL_SELECTION;
        }
        IJpaFile jpaFile = this.jpaFile();
        if (jpaFile == null) {
            return Selection.NULL_SELECTION;
        }
        IJpaContentNode selectedNode = jpaFile.getContentNode(((ITextSelection)selection).getOffset());
        if (selectedNode == null) {
            return Selection.NULL_SELECTION;
        }
        return new Selection(selectedNode);
    }

    private IJpaFile jpaFile() {
        IEditorInput input = this.textEditor.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return null;
        }
        return JptCorePlugin.jpaFile((IFile)((IFileEditorInput)input).getFile());
    }

    private IPostSelectionProvider postSelectionProvider() {
        return (IPostSelectionProvider)this.textEditor.getSelectionProvider();
    }

    void editorInputChanged() {
        Selection newSelection = this.calculateSelection();
        if (newSelection.equals(this.currentSelection)) {
            return;
        }
        this.currentSelection = newSelection;
        if (this.forwardSelection) {
            this.selectionManager.select(newSelection);
        }
    }

    void editorSelectionChanged(SelectionChangedEvent event) {
        Selection newSelection = this.calculateSelection();
        if (newSelection.equals(this.currentSelection)) {
            return;
        }
        this.currentSelection = newSelection;
        if (this.textEditor.getEditorSite().getPage().getActivePart() instanceof AbstractJpaView) {
            return;
        }
        if (this.forwardSelection) {
            this.selectionManager.select(newSelection);
        }
    }

    private class EditorInputListener
    implements IPropertyListener {
        EditorInputListener() {
        }

        public void propertyChanged(Object source, int propId) {
            if (source == TextEditorSelectionParticipant.this.textEditor && propId == 258) {
                TextEditorSelectionParticipant.this.editorInputChanged();
            }
        }
    }

    private class EditorSelectionListener
    implements ISelectionChangedListener {
        EditorSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TextEditorSelectionParticipant.this.editorSelectionChanged(event);
        }
    }
}

