/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.views;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jpt.core.internal.IJpaContentNode;
import org.eclipse.jpt.ui.internal.IJpaPlatformUi;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.PlatformRegistry;
import org.eclipse.jpt.ui.internal.details.IJpaDetailsPage;
import org.eclipse.jpt.ui.internal.details.IJpaDetailsProvider;
import org.eclipse.jpt.ui.internal.selection.Selection;
import org.eclipse.jpt.ui.internal.views.AbstractJpaView;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class JpaDetailsView
extends AbstractJpaView {
    private Selection currentSelection = Selection.NULL_SELECTION;
    private IJpaDetailsPage currentPage;
    private Map<String, IJpaDetailsProvider> detailsProviders = new HashMap<String, IJpaDetailsProvider>();
    private Map<Object, IJpaDetailsPage> detailsPages = new HashMap<Object, IJpaDetailsPage>();

    public JpaDetailsView() {
        super(JptUiMessages.JpaDetailsView_viewNotAvailable);
    }

    public Selection getSelection() {
        return this.currentSelection;
    }

    public void select(Selection newSelection) {
        if (newSelection.equals(this.currentSelection)) {
            return;
        }
        this.currentSelection = newSelection;
        if (newSelection != Selection.NULL_SELECTION) {
            IJpaContentNode newNode = newSelection.getSelectedNode();
            IJpaDetailsPage newPage = this.getDetailsPage(newNode);
            this.setCurrentPage(newPage);
        } else if (this.currentSelection != Selection.NULL_SELECTION) {
            this.setCurrentPage(null);
        }
    }

    private IJpaDetailsPage getDetailsPage(IJpaContentNode contentNode) {
        if (this.detailsPages.containsKey(contentNode.getId())) {
            IJpaDetailsPage page = this.detailsPages.get(contentNode.getId());
            if (page != null && page.getControl().isDisposed()) {
                this.detailsPages.remove(contentNode.getId());
            } else {
                return page;
            }
        }
        return this.buildDetailsPage(contentNode);
    }

    private IJpaDetailsPage buildDetailsPage(IJpaContentNode contentNode) {
        IJpaDetailsProvider detailsProvider = this.getDetailsProvider(contentNode);
        if (detailsProvider == null) {
            return null;
        }
        Composite parentComposite = this.getWidgetFactory().createComposite((Composite)this.pageBook, 0);
        parentComposite.setLayout((Layout)new FillLayout(512));
        IJpaDetailsPage page = detailsProvider.buildDetailsPage(parentComposite, contentNode.getId(), this.getWidgetFactory());
        if (page != null) {
            this.detailsPages.put(contentNode.getId(), page);
        }
        return page;
    }

    private IJpaDetailsProvider getDetailsProvider(IJpaContentNode contentNode) {
        String contentId = contentNode.getJpaFile().getContentId();
        IJpaDetailsProvider provider = this.detailsProviders.get(contentId);
        if (provider == null) {
            String platformId = contentNode.jpaPlatform().getId();
            IJpaPlatformUi jpaPlatformUI = PlatformRegistry.instance().jpaPlatform(platformId);
            provider = jpaPlatformUI.detailsProvider(contentId);
            if (provider != null) {
                this.detailsProviders.put(contentId, provider);
            }
        }
        return provider;
    }

    private void setCurrentPage(IJpaDetailsPage newPage) {
        if (this.currentPage != null && this.currentPage != newPage) {
            this.currentPage.populate(null);
        }
        if (newPage != null) {
            newPage.populate(this.currentSelection.getSelectedNode());
        }
        this.currentPage = newPage;
        if (newPage == null) {
            this.showDefaultPage();
        } else {
            this.pageBook.showPage((Control)newPage.getControl().getParent());
        }
    }

    public void dispose() {
        String key;
        CloneIterator stream = new CloneIterator((Collection)this.detailsProviders.keySet());
        while (stream.hasNext()) {
            key = (String)stream.next();
            IJpaDetailsProvider provider = this.detailsProviders.remove(key);
            provider.dispose();
        }
        stream = new CloneIterator((Collection)this.detailsPages.keySet());
        while (stream.hasNext()) {
            key = stream.next();
            IJpaDetailsPage detailsPage = this.detailsPages.remove(key);
            detailsPage.dispose();
        }
        this.currentSelection = Selection.NULL_SELECTION;
        this.currentPage = null;
        super.dispose();
    }
}

