/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.metadata.internal.StandardMetaDataFileInfo;
import org.eclipse.jst.jsf.common.metadata.internal.StandardMetaDataFileRegistry;

public class StandardMetaDataFileRegistryReader {
    protected static final String EXTENSION_POINT_ID = "standardMetaDataFiles";
    protected static final String TAG_NAME = "StandardMetaDataFile";
    protected static final String ATT_URI = "uri";
    protected static final String ATT_LOCATION = "location";
    protected static final String ATT_LOCATOR = "locator";
    private StandardMetaDataFileRegistry annotationFileRegistry;

    public StandardMetaDataFileRegistryReader(StandardMetaDataFileRegistry registry) {
        this.annotationFileRegistry = registry;
    }

    public void readRegistry() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = extensionRegistry.getExtensionPoint("org.eclipse.jst.jsf.common", EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.readElement(elements[i]);
                ++i;
            }
        }
    }

    private void readElement(IConfigurationElement element) {
        if (element.getName().equalsIgnoreCase(TAG_NAME)) {
            String uri = element.getAttribute(ATT_URI);
            String location = element.getAttribute(ATT_LOCATION);
            String locator = element.getAttribute(ATT_LOCATOR);
            String bundleId = null;
            if (uri != null && location != null) {
                try {
                    bundleId = element.getContributor().getName();
                    StandardMetaDataFileInfo fileInfo = new StandardMetaDataFileInfo(location, bundleId, locator);
                    this.annotationFileRegistry.addStandardMetaDataFileInfo(uri, fileInfo);
                }
                catch (Exception e) {
                    JSFCommonPlugin.log(4, "Internal Error: exception occurred while reading StandardMetaDataFile ext-pt: " + location + ":" + uri, e);
                }
            }
        }
    }
}

