/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.wizard;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jst.j2ee.internal.dialogs.TwoArrayQuickSorter;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.web.operations.FilterMappingItem;
import org.eclipse.jst.j2ee.internal.web.operations.IFilterMappingItem;
import org.eclipse.jst.j2ee.internal.web.plugin.WebPlugin;
import org.eclipse.jst.j2ee.internal.web.providers.WebAppEditResourceHandler;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.servlet.ui.internal.wizard.IWebWizardConstants;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.internal.layout.CellLayout;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddEditFilterMappingDialog
extends SelectionStatusDialog
implements SelectionListener {
    private ISelectionStatusValidator fValidator = null;
    public static final int SERVLET = 0;
    public static final int URL_PATTERN = 1;
    protected Button fServletButton;
    protected Button fURLPatternButton;
    protected int fSelection = -1;
    protected PageBook fPageBook = null;
    protected Control fURLPatternControl = null;
    protected Control fServletControl = null;
    protected Composite fChild = null;
    protected IRunnableContext fRunnableContext;
    protected ILabelProvider fElementRenderer;
    private Object[] fElements;
    private boolean fIgnoreCase = true;
    private String fUpperListLabel;
    private String fLowerListLabel;
    private Table fUpperList;
    protected Text fURLText;
    private String[] fServletNames;
    private String[] fRenderedStrings;
    private int dispatchers;
    private Button fRequest;
    private Button fForward;
    private Button fInclude;
    private Button fErorr;
    private IFilterMappingItem selectedItem;

    public AddEditFilterMappingDialog(Shell parent, String title, IProject project, List<IFilterMappingItem> elements, IFilterMappingItem item) {
        super(parent);
        this.selectedItem = item;
        this.setShellStyle(67696);
        if (title == null) {
            this.setTitle(WebAppEditResourceHandler.getString((String)"File_Selection_UI_"));
        } else {
            this.setTitle(title);
        }
        Status currStatus = new Status(0, "org.eclipse.jst.servlet.ui", 0, "", null);
        this.updateStatus((IStatus)currStatus);
        this.fElementRenderer = new TypeRenderer();
        this.fRunnableContext = J2EEUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        try {
            IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
            Object mObj = provider.getModelObject();
            ArrayList<String> servletsList = new ArrayList<String>();
            if (mObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)mObj;
                EList servlets = webApp.getServlets();
                for (Servlet servlet : servlets) {
                    String servletName = servlet.getServletName();
                    if (!servletName.equals(item != null ? item.getName() : null) && this.isAlreadyAdded(servletName, elements)) continue;
                    servletsList.add(servletName);
                }
            } else if (mObj instanceof WebApp) {
                WebApp webApp = (WebApp)mObj;
                List servlets = webApp.getServlets();
                for (org.eclipse.jst.javaee.web.Servlet servlet : servlets) {
                    String servletName = servlet.getServletName();
                    if (!servletName.equals(item != null ? item.getName() : null) && this.isAlreadyAdded(servletName, elements)) continue;
                    servletsList.add(servletName);
                }
            }
            this.fServletNames = servletsList.toArray(new String[servletsList.size()]);
            servletsList = null;
        }
        catch (Exception exc) {
            Logger.getLogger().logError((Throwable)exc);
        }
    }

    private boolean isAlreadyAdded(String servlet, List<IFilterMappingItem> elements) {
        for (IFilterMappingItem item : elements) {
            if (!item.isServletNameType() || !item.getName().equals(servlet)) continue;
            return true;
        }
        return false;
    }

    protected void computeResult() {
        if (this.fSelection == 1) {
            ArrayList<FilterMappingItem> result = new ArrayList<FilterMappingItem>(1);
            this.dispatchers = this.getDispatchers();
            FilterMappingItem mappingItem = new FilterMappingItem(0, this.fURLText.getText().trim(), this.dispatchers);
            result.add(mappingItem);
            this.setResult(result);
        } else {
            String servletName = (String)this.getWidgetSelection();
            if (servletName == null) {
                this.setResult(null);
            } else {
                this.dispatchers = this.getDispatchers();
                ArrayList<FilterMappingItem> result = new ArrayList<FilterMappingItem>(1);
                FilterMappingItem mappingItem = new FilterMappingItem(1, servletName, this.dispatchers);
                result.add(mappingItem);
                this.setResult(result);
            }
        }
    }

    private int getDispatchers() {
        int dispatchers = 0;
        if (this.fRequest.getSelection()) {
            dispatchers |= 2;
        }
        if (this.fForward.getSelection()) {
            dispatchers |= 4;
        }
        if (this.fInclude.getSelection()) {
            dispatchers |= 8;
        }
        if (this.fErorr.getSelection()) {
            dispatchers |= 0x10;
        }
        return dispatchers;
    }

    public void create() {
        super.create();
        if (this.selectedItem == null && this.fServletNames != null && this.fServletNames.length > 0) {
            this.fSelection = 0;
        }
        this.updateOkState();
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Composite composite2 = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite2.setLayout((Layout)layout);
        GridData data = new GridData(132);
        composite2.setLayoutData((Object)data);
        composite2.setFont(parent.getFont());
        super.createButtonsForButtonBar(composite2);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        GridData gd = new GridData();
        this.fChild = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fChild, "com.ibm.etools.webapplicationedit.webx2010");
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginHeight = 0;
        this.fChild.setLayout((Layout)gl);
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.fChild.setLayoutData((Object)gd);
        this.fServletButton = new Button(this.fChild, 16);
        this.fServletButton.setText(WebAppEditResourceHandler.getString((String)"Servlet_UI_"));
        gd = new GridData();
        this.fServletButton.setLayoutData((Object)gd);
        this.fServletButton.addSelectionListener((SelectionListener)this);
        this.fURLPatternButton = new Button(this.fChild, 16);
        this.fURLPatternButton.setText(WebAppEditResourceHandler.getString((String)"URL_pattern_UI_"));
        gd = new GridData();
        this.fURLPatternButton.setLayoutData((Object)gd);
        this.fURLPatternButton.addSelectionListener((SelectionListener)this);
        this.fPageBook = new PageBook(this.fChild, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.fPageBook.setLayoutData((Object)gd);
        Composite composite = new Composite((Composite)this.fPageBook, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label messageLabel = new Label(composite, 0);
        gd = new GridData();
        messageLabel.setLayoutData((Object)gd);
        messageLabel.setText(IWebWizardConstants.URL_PATTERN_LABEL);
        this.fURLText = new Text(composite, 2048);
        GridData spec = new GridData();
        spec.grabExcessVerticalSpace = false;
        spec.grabExcessHorizontalSpace = true;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 1;
        this.fURLText.setLayoutData((Object)spec);
        Listener l = new Listener(){

            public void handleEvent(Event evt) {
                AddEditFilterMappingDialog.this.updateOkState();
            }
        };
        this.fURLText.addListener(24, l);
        this.fURLPatternControl = composite;
        composite = new Composite((Composite)this.fPageBook, 0);
        layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        messageLabel = new Label(composite, 0);
        gd = new GridData();
        messageLabel.setLayoutData((Object)gd);
        messageLabel.setText(WebAppEditResourceHandler.getString((String)"Choose_a_servlet__2"));
        this.fUpperList = this.createUpperList(composite);
        this.fServletControl = composite;
        Group dispatchers = new Group(this.fChild, 4);
        dispatchers.setText(WebAppEditResourceHandler.getString((String)"Select_Dispatchers_UI_"));
        dispatchers.setLayout((Layout)new CellLayout(2).setMargins(10, 10).setSpacing(5, 5));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        dispatchers.setLayoutData((Object)gridData);
        this.fRequest = new Button((Composite)dispatchers, 32);
        this.fRequest.setText(IWebWizardConstants.REQUEST);
        this.fForward = new Button((Composite)dispatchers, 32);
        this.fForward.setText(IWebWizardConstants.FORWARD);
        this.fInclude = new Button((Composite)dispatchers, 32);
        this.fInclude.setText(IWebWizardConstants.INCLUDE);
        this.fErorr = new Button((Composite)dispatchers, 32);
        this.fErorr.setText(IWebWizardConstants.ERROR);
        if (this.selectedItem != null) {
            this.fSelection = this.selectedItem.isUrlPatternType() ? 1 : 0;
        } else if (this.fServletNames == null || this.fServletNames.length == 0) {
            this.fSelection = 1;
        }
        this.updateUpperListWidget();
        this.fServletButton.setEnabled(true);
        if (this.fSelection == 1) {
            this.fURLPatternButton.setSelection(true);
            this.fPageBook.showPage(this.fURLPatternControl);
            this.fServletButton.setSelection(false);
            if (this.fServletNames == null || this.fServletNames.length == 0) {
                this.fServletButton.setEnabled(false);
            }
            if (this.selectedItem != null) {
                this.fURLText.setText(this.selectedItem.getName());
                this.setDispatchers(this.selectedItem.getDispatchers());
            }
        } else {
            this.fServletButton.setSelection(true);
            this.fPageBook.showPage(this.fServletControl);
            if (this.selectedItem != null) {
                this.fUpperList.setSelection(this.getServletIndex(this.fUpperList, this.selectedItem.getName()));
                this.setDispatchers(this.selectedItem.getDispatchers());
            }
        }
        this.updateOkState();
        return parent;
    }

    private int getServletIndex(Table list, String name) {
        TableItem[] items = list.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem tableItem = items[i];
            if (tableItem.getText().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void setDispatchers(int dispatchers) {
        if ((dispatchers & 2) > 0) {
            this.fRequest.setSelection(true);
        }
        if ((dispatchers & 4) > 0) {
            this.fForward.setSelection(true);
        }
        if ((dispatchers & 8) > 0) {
            this.fInclude.setSelection(true);
        }
        if ((dispatchers & 0x10) > 0) {
            this.fErorr.setSelection(true);
        }
    }

    private Table createUpperList(Composite parent) {
        if (this.fUpperListLabel != null) {
            new Label(parent, 0).setText(this.fUpperListLabel);
        }
        Table list = new Table(parent, 2816);
        list.addListener(8, new Listener(){

            public void handleEvent(Event evt) {
                AddEditFilterMappingDialog.this.handleUpperDoubleClick();
            }
        });
        list.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AddEditFilterMappingDialog.this.fElementRenderer.dispose();
            }
        });
        GridData spec = new GridData();
        spec.widthHint = this.convertWidthInCharsToPixels(50);
        spec.heightHint = this.convertHeightInCharsToPixels(4);
        spec.grabExcessVerticalSpace = true;
        spec.grabExcessHorizontalSpace = true;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 4;
        list.setLayoutData((Object)spec);
        return list;
    }

    protected int getDefaultButtonID() {
        return 0;
    }

    public int getSelectedItem() {
        return this.fSelection;
    }

    protected Object getWidgetSelection() {
        int index = this.fUpperList.getSelectionIndex();
        return index >= 0 ? this.fElements[index] : null;
    }

    protected final void handleLowerDoubleClick() {
        if (this.getWidgetSelection() != null) {
            this.buttonPressed(this.getDefaultButtonID());
        }
    }

    protected final void handleLowerSelectionChanged() {
        this.updateOkState();
    }

    protected final void handleUpperDoubleClick() {
        if (this.getWidgetSelection() != null) {
            this.buttonPressed(this.getDefaultButtonID());
        }
    }

    public int open() {
        if (this.fServletNames == null || this.fServletNames.length == 0) {
            this.fSelection = 1;
        }
        this.setElements(this.fServletNames);
        this.setInitialSelections(new Object[]{""});
        return super.open();
    }

    private String[] renderStrings(Object[] p) {
        Object[] strings = new String[p.length];
        int size = strings.length;
        int i = 0;
        while (i < size) {
            strings[i] = this.fElementRenderer.getText(p[i]);
            ++i;
        }
        new TwoArrayQuickSorter(this.fIgnoreCase).sort(strings, p);
        return strings;
    }

    public void setElements(Object[] elements) {
        if (elements == null) {
            elements = new Object[]{};
        }
        this.fElements = elements;
        this.fRenderedStrings = this.renderStrings(this.fElements);
    }

    public void setSelectedItem(int newSelection) {
        this.fSelection = newSelection;
    }

    private void updateOkState() {
        Button okButton = this.getOkButton();
        if (okButton != null) {
            if (this.fSelection == 0) {
                okButton.setEnabled(this.getWidgetSelection() != null);
            } else {
                String result = this.fURLText.getText().trim();
                okButton.setEnabled(result.length() > 0);
            }
        }
    }

    private void updateUpperListWidget() {
        this.fUpperList.setRedraw(false);
        this.fUpperList.clearAll();
        int i = 0;
        while (i < this.fRenderedStrings.length) {
            TableItem ti = new TableItem(this.fUpperList, 0);
            ti.setText(this.fRenderedStrings[i]);
            Image img = this.fElementRenderer.getImage((Object)this.fRenderedStrings[i]);
            ti.setImage(img);
            ++i;
        }
        if (this.fUpperList.getItemCount() > 0) {
            this.fUpperList.setSelection(0);
        }
        this.fUpperList.setRedraw(true);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.fURLPatternButton) {
            this.fSelection = 1;
            this.fPageBook.showPage(this.fURLPatternControl);
            this.updateOkState();
        } else if (e.widget == this.fServletButton) {
            this.fSelection = 0;
            this.fPageBook.showPage(this.fServletControl);
            this.getShell().pack();
        } else {
            this.fSelection = -1;
        }
    }

    private static class TypeRenderer
    extends LabelProvider {
        private final Image SERVLET_ICON = ImageDescriptor.createFromURL((URL)((URL)WebPlugin.getDefault().getImage("servlet"))).createImage();

        private TypeRenderer() {
        }

        public String getText(Object element) {
            return (String)element;
        }

        public Image getImage(Object element) {
            return this.SERVLET_ICON;
        }
    }
}

