/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.j2ee.internal.plugin.J2EEEditorUtility;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.web.operations.NewListenerClassDataModelProvider;
import org.eclipse.jst.servlet.ui.internal.plugin.ServletUIPlugin;
import org.eclipse.jst.servlet.ui.internal.wizard.AddListenerWizardPage;
import org.eclipse.jst.servlet.ui.internal.wizard.IWebWizardConstants;
import org.eclipse.jst.servlet.ui.internal.wizard.NewListenerClassOptionsWizardPage;
import org.eclipse.jst.servlet.ui.internal.wizard.NewListenerClassWizardPage;
import org.eclipse.jst.servlet.ui.internal.wizard.NewWebWizard;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class AddListenerWizard
extends NewWebWizard {
    private static final String PAGE_ONE = "pageOne";
    private static final String PAGE_TWO = "pageTwo";
    private static final String PAGE_THREE = "pageThree";

    public AddListenerWizard(IDataModel model) {
        super(model);
        this.setWindowTitle(IWebWizardConstants.ADD_LISTENER_WIZARD_WINDOW_TITLE);
        this.setDefaultPageImageDescriptor(this.getListenerWizBan());
    }

    public AddListenerWizard() {
        this(null);
    }

    public void doAddPages() {
        NewListenerClassWizardPage page1 = new NewListenerClassWizardPage(this.getDataModel(), PAGE_ONE, IWebWizardConstants.NEW_JAVA_CLASS_DESTINATION_WIZARD_PAGE_DESC, IWebWizardConstants.ADD_LISTENER_WIZARD_PAGE_TITLE, "jst.web");
        this.addPage((IWizardPage)page1);
        AddListenerWizardPage page2 = new AddListenerWizardPage(this.getDataModel(), PAGE_TWO);
        this.addPage((IWizardPage)page2);
        NewListenerClassOptionsWizardPage page3 = new NewListenerClassOptionsWizardPage(this.getDataModel(), PAGE_THREE, IWebWizardConstants.NEW_JAVA_CLASS_OPTIONS_WIZARD_PAGE_DESC, IWebWizardConstants.ADD_LISTENER_WIZARD_PAGE_TITLE);
        this.addPage((IWizardPage)page3);
    }

    protected boolean runForked() {
        return false;
    }

    public boolean canFinish() {
        return this.getDataModel().isValid();
    }

    protected void postPerformFinish() throws InvocationTargetException {
        Object artifactEdit = null;
        try {
            try {
                String className = this.getDataModel().getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
                IProject p = (IProject)this.getDataModel().getProperty("NewJavaClassDataModel.PROJECT");
                IJavaProject javaProject = J2EEEditorUtility.getJavaProject((IProject)p);
                IFile file = (IFile)javaProject.findType(className).getResource();
                this.openEditor(file);
            }
            catch (Exception cantOpen) {
                ServletUIPlugin.log(cantOpen);
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void openEditor(final IFile file) {
        if (file != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        ServletUIPlugin.log((Exception)((Object)e));
                    }
                }
            });
        }
    }

    protected IDataModelProvider getDefaultProvider() {
        return new NewListenerClassDataModelProvider();
    }

    private ImageDescriptor getListenerWizBan() {
        URL url = (URL)J2EEPlugin.getDefault().getImage("newlistener_wiz");
        return ImageDescriptor.createFromURL((URL)url);
    }
}

