/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.wizard;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.internal.web.operations.FilterMappingItem;
import org.eclipse.jst.j2ee.internal.web.operations.IFilterMappingItem;
import org.eclipse.jst.j2ee.internal.web.plugin.WebPlugin;
import org.eclipse.jst.j2ee.internal.web.providers.WebAppEditResourceHandler;
import org.eclipse.jst.servlet.ui.internal.wizard.AddEditFilterMappingDialog;
import org.eclipse.jst.servlet.ui.internal.wizard.IWebWizardConstants;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class FilterMappingsArrayTableWizardSection
extends Composite {
    static final int ICON_WIDTH = 25;
    static final int DISPATCHERS_WIDTH = 100;
    private static final String ICON_PROP = "ICON_PROP";
    private static final String NAME_PROP = "NAME_PROP";
    private static final String DISPATCHERS_PROP = "DISPATCHERS_PROP";
    private TableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private IDataModel model;
    private String propertyName;

    public FilterMappingsArrayTableWizardSection(Composite parent, IDataModel model, String propertyName) {
        super(parent, 0);
        this.model = model;
        this.propertyName = propertyName;
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 4;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Label titleLabel = new Label((Composite)this, 16384);
        titleLabel.setText(IWebWizardConstants.FILTER_MAPPINGS_LABEL);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        titleLabel.setLayoutData((Object)data);
        Table table = new Table((Composite)this, 67584);
        this.viewer = new TableViewer(table);
        table.setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new StringArrayListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new StringArrayListLabelProvider());
        final Composite buttonCompo = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        buttonCompo.setLayout((Layout)layout);
        buttonCompo.setLayoutData((Object)new GridData(1042));
        this.addButton = new Button(buttonCompo, 8);
        this.addButton.setText(IWebWizardConstants.ADD_BUTTON_LABEL);
        this.addButton.setLayoutData((Object)new GridData(258));
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                FilterMappingsArrayTableWizardSection.this.handleAddButtonSelected();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.editButton = new Button(buttonCompo, 8);
        this.editButton.setText(IWebWizardConstants.EDIT_BUTTON_LABEL);
        this.editButton.setLayoutData((Object)new GridData(258));
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                FilterMappingsArrayTableWizardSection.this.handleEditButtonSelected();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.editButton.setEnabled(false);
        this.removeButton = new Button(buttonCompo, 8);
        this.removeButton.setText(IWebWizardConstants.REMOVE_BUTTON_LABEL);
        this.removeButton.setLayoutData((Object)new GridData(258));
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                FilterMappingsArrayTableWizardSection.this.handleRemoveButtonSelected();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.removeButton.setEnabled(false);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (FilterMappingsArrayTableWizardSection.this.editButton != null) {
                    boolean enabled = ((IStructuredSelection)selection).size() == 1;
                    FilterMappingsArrayTableWizardSection.this.editButton.setEnabled(enabled);
                }
                FilterMappingsArrayTableWizardSection.this.removeButton.setEnabled(!selection.isEmpty());
            }
        });
        if (this.editButton != null) {
            this.viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    FilterMappingsArrayTableWizardSection.this.handleEditButtonSelected();
                }
            });
        }
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(25);
        tableColumn.setResizable(false);
        tableColumn = new TableColumn(table, 0);
        tableColumn.setText(IWebWizardConstants.URL_SERVLET_LABEL);
        tableColumn.setResizable(true);
        tableColumn = new TableColumn(table, 0);
        tableColumn.setText(IWebWizardConstants.DISPATCHERS_LABEL);
        tableColumn.setWidth(100);
        tableColumn.setResizable(false);
        this.viewer.setColumnProperties(new String[]{ICON_PROP, NAME_PROP, DISPATCHERS_PROP});
        table.setHeaderVisible(true);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Table table = FilterMappingsArrayTableWizardSection.this.viewer.getTable();
                TableColumn[] columns = table.getColumns();
                Point buttonArea = buttonCompo.computeSize(-1, -1);
                Rectangle area = table.getParent().getClientArea();
                Point preferredSize = FilterMappingsArrayTableWizardSection.this.viewer.getTable().computeSize(-1, -1);
                int width = area.width - 2 * table.getBorderWidth() - buttonArea.x - columns.length * 2;
                if (preferredSize.y > area.height + table.getHeaderHeight()) {
                    Point vBarSize = table.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = table.getSize();
                int i = 0;
                while (i < columns.length) {
                    if (oldSize.x > area.width) {
                        if (i == 1) {
                            columns[i].setWidth(width - 25 - 100);
                        }
                        table.setSize(area.width - buttonArea.x - columns.length * 2, area.height);
                    } else {
                        table.setSize(area.width - buttonArea.x - columns.length * 2, area.height);
                        if (i == 1) {
                            columns[i].setWidth(width - 25 - 100);
                        }
                    }
                    ++i;
                }
            }
        });
    }

    private void handleAddButtonSelected() {
        String title = WebAppEditResourceHandler.getString((String)"Add_Filter_Mapping_Title_UI_");
        IProject p = (IProject)this.model.getProperty("NewJavaClassDataModel.PROJECT");
        List valueList = (List)this.viewer.getInput();
        AddEditFilterMappingDialog dialog = new AddEditFilterMappingDialog(this.getShell(), title, p, valueList, null);
        dialog.open();
        Object[] result = dialog.getResult();
        this.addFilterMapping(result != null && result.length > 0 ? (IFilterMappingItem)result[0] : null);
    }

    private void handleEditButtonSelected() {
        String title = WebAppEditResourceHandler.getString((String)"Edit_Filter_Mapping_Title_UI_");
        ISelection s = this.viewer.getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        if (selection.size() != 1) {
            return;
        }
        List valueList = (List)this.viewer.getInput();
        Object selectedObj = selection.getFirstElement();
        FilterMappingItem value = (FilterMappingItem)selectedObj;
        IProject p = (IProject)this.model.getProperty("NewJavaClassDataModel.PROJECT");
        AddEditFilterMappingDialog dialog = new AddEditFilterMappingDialog(this.getShell(), title, p, valueList, (IFilterMappingItem)value);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0) {
            return;
        }
        this.editFilterMapping((IFilterMappingItem)value, (IFilterMappingItem)result[0]);
    }

    private void handleRemoveButtonSelected() {
        ISelection selection = this.viewer.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        List selectedObj = ((IStructuredSelection)selection).toList();
        this.removeFilterMappings(selectedObj);
    }

    private void addFilterMapping(IFilterMappingItem filterMapping) {
        if (filterMapping == null) {
            return;
        }
        ArrayList<IFilterMappingItem> valueList = (ArrayList<IFilterMappingItem>)this.viewer.getInput();
        if (valueList == null) {
            valueList = new ArrayList<IFilterMappingItem>();
        }
        valueList.add(filterMapping);
        this.setInput(valueList);
    }

    private void editFilterMapping(IFilterMappingItem oldFilterMapping, IFilterMappingItem newFilterMapping) {
        int index;
        if (newFilterMapping == null) {
            return;
        }
        ArrayList<IFilterMappingItem> valueList = (ArrayList<IFilterMappingItem>)this.viewer.getInput();
        if (valueList == null) {
            valueList = new ArrayList<IFilterMappingItem>();
        }
        if ((index = valueList.indexOf(oldFilterMapping)) == -1) {
            valueList.add(newFilterMapping);
        } else {
            valueList.set(index, newFilterMapping);
        }
        this.setInput(valueList);
    }

    private void removeFilterMapping(Object selectedFilterMapping) {
        List valueList = (List)this.viewer.getInput();
        valueList.remove(selectedFilterMapping);
        this.setInput(valueList);
    }

    private void removeFilterMappings(Collection selectedFilterMappings) {
        List valueList = (List)this.viewer.getInput();
        valueList.removeAll(selectedFilterMappings);
        this.setInput(valueList);
    }

    public void setInput(List input) {
        this.viewer.setInput((Object)input);
        ArrayList newInput = new ArrayList();
        newInput.addAll(input);
        this.model.setProperty(this.propertyName, newInput);
    }

    public List getInput() {
        ArrayList valueList = (ArrayList)this.viewer.getInput();
        if (valueList == null) {
            valueList = new ArrayList();
        }
        return valueList;
    }

    protected class StringArrayListContentProvider
    implements IStructuredContentProvider {
        protected StringArrayListContentProvider() {
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        public Object[] getElements(Object element) {
            if (element instanceof List) {
                return ((List)element).toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer aViewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    protected class StringArrayListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final Image URL_PATTERN_ICON = ImageDescriptor.createFromURL((URL)((URL)WebPlugin.getDefault().getImage("url_mapping"))).createImage();
        private final Image SERVLET_ICON = ImageDescriptor.createFromURL((URL)((URL)WebPlugin.getDefault().getImage("servlet"))).createImage();

        protected StringArrayListLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                FilterMappingItem item = (FilterMappingItem)element;
                if (item.isServletNameType()) {
                    return this.SERVLET_ICON;
                }
                if (item.isUrlPatternType()) {
                    return this.URL_PATTERN_ICON;
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 1) {
                return ((FilterMappingItem)element).getName();
            }
            if (columnIndex == 2) {
                return ((FilterMappingItem)element).getDispatchersAsString();
            }
            return null;
        }
    }
}

