/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.wizard;

import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.j2ee.internal.web.operations.FilterSupertypesValidator;
import org.eclipse.jst.j2ee.internal.wizard.NewJavaClassOptionsWizardPage;
import org.eclipse.jst.servlet.ui.internal.wizard.IWebWizardConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class NewFilterClassOptionsWizardPage
extends NewJavaClassOptionsWizardPage
implements ISelectionChangedListener {
    protected Button initButton;
    protected Button destroyButton;
    protected Button doFilterButton;
    private FilterSupertypesValidator validator;

    public NewFilterClassOptionsWizardPage(IDataModel model, String pageName, String pageDesc, String pageTitle) {
        super(model, pageName, pageDesc, pageTitle);
        this.validator = new FilterSupertypesValidator(model);
    }

    protected void enter() {
        super.enter();
        this.interfaceViewer.getList().deselectAll();
        this.removeButton.setEnabled(false);
        String superClass = this.getDataModel().getStringProperty("NewJavaClassDataModel.SUPERCLASS");
        boolean hasSuperClass = superClass == null ? false : superClass.trim().length() > 0;
        this.constructorButton.setEnabled(hasSuperClass);
        if (!hasSuperClass) {
            this.constructorButton.setSelection(false);
        }
        this.inheritButton.setSelection(true);
        this.inheritButton.setEnabled(false);
        this.initButton.setSelection(true);
        this.initButton.setEnabled(false);
        this.destroyButton.setSelection(true);
        this.destroyButton.setEnabled(false);
        this.doFilterButton.setSelection(true);
        this.doFilterButton.setEnabled(false);
    }

    protected void createModifierControls(Composite parent) {
        super.createModifierControls(parent);
        this.publicButton.setEnabled(false);
        this.abstractButton.setEnabled(false);
    }

    protected void createStubsComposite(Composite parent) {
        Label stubLabel = new Label(parent, 0);
        stubLabel.setText(IWebWizardConstants.JAVA_CLASS_METHOD_STUBS_LABEL);
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        stubLabel.setLayoutData((Object)data);
        Composite buttonCompo = new Composite(parent, 0);
        buttonCompo.setLayout((Layout)new GridLayout());
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.horizontalIndent = 15;
        buttonCompo.setLayoutData((Object)data);
        this.constructorButton = new Button(buttonCompo, 32);
        this.constructorButton.setText(IWebWizardConstants.JAVA_CLASS_CONSTRUCTOR_CHECKBOX_LABEL);
        this.synchHelper.synchCheckbox(this.constructorButton, "NewJavaClassDataModel.CONSTRUCTOR", null);
        this.inheritButton = new Button(buttonCompo, 32);
        this.inheritButton.setText(IWebWizardConstants.JAVA_CLASS_INHERIT_CHECKBOX_LABEL);
        this.synchHelper.synchCheckbox(this.inheritButton, "NewJavaClassDataModel.ABSTRACT_METHODS", null);
        Composite comp = new Composite(buttonCompo, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = true;
        comp.setLayout((Layout)layout);
        data = new GridData(1808);
        comp.setLayoutData((Object)data);
        this.initButton = new Button(comp, 32);
        this.initButton.setText("&init");
        this.synchHelper.synchCheckbox(this.initButton, "NewFilterClassDataModel.INIT", null);
        this.destroyButton = new Button(comp, 32);
        this.destroyButton.setText("destro&y");
        this.synchHelper.synchCheckbox(this.destroyButton, "NewFilterClassDataModel.DESTROY", null);
        this.doFilterButton = new Button(comp, 32);
        this.doFilterButton.setText("do&Filter");
        this.synchHelper.synchCheckbox(this.doFilterButton, "NewFilterClassDataModel.DO_FILTER", null);
        this.interfaceViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Dialog.applyDialogFont((Control)parent);
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"NewJavaClassDataModel.INTERFACES"};
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        if (selection.isEmpty()) {
            this.removeButton.setEnabled(false);
            return;
        }
        if (this.validator.isFilterSuperclass()) {
            this.removeButton.setEnabled(true);
            return;
        }
        Iterator iter = selection.iterator();
        if (iter.hasNext()) {
            if ("javax.servlet.Filter".equals(iter.next())) {
                this.removeButton.setEnabled(false);
            }
            return;
        }
        this.removeButton.setEnabled(true);
    }
}

