/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.wizard;

import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.j2ee.internal.web.operations.ServletSupertypesValidator;
import org.eclipse.jst.j2ee.internal.wizard.NewJavaClassOptionsWizardPage;
import org.eclipse.jst.servlet.ui.internal.wizard.IWebWizardConstants;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class NewServletClassOptionsWizardPage
extends NewJavaClassOptionsWizardPage
implements ISelectionChangedListener {
    protected Button initButton;
    protected Button destroyButton;
    protected Button getConfigButton;
    protected Button getInfoButton;
    protected Button serviceButton;
    protected Button doGetButton;
    protected Button doPostButton;
    protected Button doPutButton;
    protected Button doDeleteButton;
    protected Button doHeadButton;
    protected Button doOptionsButton;
    protected Button doTraceButton;

    public NewServletClassOptionsWizardPage(IDataModel model, String pageName, String pageDesc, String pageTitle) {
        super(model, pageName, pageDesc, pageTitle);
    }

    protected void enter() {
        super.enter();
        this.interfaceViewer.getList().deselectAll();
        this.removeButton.setEnabled(false);
        ServletSupertypesValidator validator = new ServletSupertypesValidator(this.getDataModel());
        boolean genericServlet = validator.isGenericServletSuperclass();
        this.inheritButton.setEnabled(genericServlet);
        boolean inherit = this.getDataModel().getBooleanProperty("NewJavaClassDataModel.ABSTRACT_METHODS");
        this.initButton.setEnabled(genericServlet && inherit);
        this.destroyButton.setEnabled(genericServlet && inherit);
        this.getConfigButton.setEnabled(genericServlet && inherit);
        this.getInfoButton.setEnabled(genericServlet && inherit);
        this.serviceButton.setEnabled(genericServlet && inherit);
        boolean httpServlet = validator.isHttpServletSuperclass();
        this.doGetButton.setVisible(httpServlet);
        this.doPostButton.setVisible(httpServlet);
        this.doPutButton.setVisible(httpServlet);
        this.doDeleteButton.setVisible(httpServlet);
        this.doHeadButton.setVisible(httpServlet);
        this.doOptionsButton.setVisible(httpServlet);
        this.doTraceButton.setVisible(httpServlet);
    }

    protected void createModifierControls(Composite parent) {
        super.createModifierControls(parent);
        this.publicButton.setEnabled(false);
        this.abstractButton.setEnabled(false);
    }

    protected void createStubsComposite(Composite parent) {
        Label stubLabel = new Label(parent, 0);
        stubLabel.setText(IWebWizardConstants.JAVA_CLASS_METHOD_STUBS_LABEL);
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        stubLabel.setLayoutData((Object)data);
        Composite buttonCompo = new Composite(parent, 0);
        buttonCompo.setLayout((Layout)new GridLayout());
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.horizontalIndent = 15;
        buttonCompo.setLayoutData((Object)data);
        this.constructorButton = new Button(buttonCompo, 32);
        this.constructorButton.setText(IWebWizardConstants.JAVA_CLASS_CONSTRUCTOR_CHECKBOX_LABEL);
        this.synchHelper.synchCheckbox(this.constructorButton, "NewJavaClassDataModel.CONSTRUCTOR", null);
        this.inheritButton = new Button(buttonCompo, 32);
        this.inheritButton.setText(IWebWizardConstants.JAVA_CLASS_INHERIT_CHECKBOX_LABEL);
        this.synchHelper.synchCheckbox(this.inheritButton, "NewJavaClassDataModel.ABSTRACT_METHODS", null);
        this.inheritButton.addSelectionListener(new SelectionListener(){
            private ServletSupertypesValidator validator;
            {
                this.validator = new ServletSupertypesValidator(NewServletClassOptionsWizardPage.this.getDataModel());
            }

            public void widgetSelected(SelectionEvent e) {
                boolean enable = NewServletClassOptionsWizardPage.this.inheritButton.getSelection();
                this.enableGenericServletButtons(enable);
                this.enableHttpServletButtons(enable);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            private void enableGenericServletButtons(boolean enable) {
                if (this.validator.isGenericServletSuperclass()) {
                    NewServletClassOptionsWizardPage.this.initButton.setEnabled(enable);
                    NewServletClassOptionsWizardPage.this.destroyButton.setEnabled(enable);
                    NewServletClassOptionsWizardPage.this.getConfigButton.setEnabled(enable);
                    NewServletClassOptionsWizardPage.this.getInfoButton.setEnabled(enable);
                    NewServletClassOptionsWizardPage.this.serviceButton.setEnabled(enable);
                }
            }

            private void enableHttpServletButtons(boolean enable) {
                NewServletClassOptionsWizardPage.this.doGetButton.setEnabled(enable);
                NewServletClassOptionsWizardPage.this.doPostButton.setEnabled(enable);
                NewServletClassOptionsWizardPage.this.doPutButton.setEnabled(enable);
                NewServletClassOptionsWizardPage.this.doDeleteButton.setEnabled(enable);
                NewServletClassOptionsWizardPage.this.doHeadButton.setEnabled(enable);
                NewServletClassOptionsWizardPage.this.doOptionsButton.setEnabled(enable);
                NewServletClassOptionsWizardPage.this.doTraceButton.setEnabled(enable);
            }
        });
        Composite comp = new Composite(buttonCompo, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = true;
        comp.setLayout((Layout)layout);
        data = new GridData(1808);
        comp.setLayoutData((Object)data);
        this.initButton = new Button(comp, 32);
        this.initButton.setText("&init");
        this.synchHelper.synchCheckbox(this.initButton, "NewServletClassDataModel.INIT", null);
        this.destroyButton = new Button(comp, 32);
        this.destroyButton.setText("destro&y");
        this.synchHelper.synchCheckbox(this.destroyButton, "NewServletClassDataModel.DESTROY", null);
        this.getConfigButton = new Button(comp, 32);
        this.getConfigButton.setText("getServlet&Config");
        this.synchHelper.synchCheckbox(this.getConfigButton, "NewServletClassDataModel.GET_SERVLET_CONFIG", null);
        this.getInfoButton = new Button(comp, 32);
        this.getInfoButton.setText("getServletI&nfo");
        this.synchHelper.synchCheckbox(this.getInfoButton, "NewServletClassDataModel.GET_SERVLET_INFO", null);
        this.serviceButton = new Button(comp, 32);
        this.serviceButton.setText("&service");
        this.synchHelper.synchCheckbox(this.serviceButton, "NewServletClassDataModel.SERVICE", null);
        this.doGetButton = new Button(comp, 32);
        this.doGetButton.setText("do&Get");
        this.synchHelper.synchCheckbox(this.doGetButton, "NewServletClassDataModel.DO_GET", null);
        this.doPostButton = new Button(comp, 32);
        this.doPostButton.setText("do&Post");
        this.synchHelper.synchCheckbox(this.doPostButton, "NewServletClassDataModel.DO_POST", null);
        this.doPutButton = new Button(comp, 32);
        this.doPutButton.setText("doP&ut");
        this.synchHelper.synchCheckbox(this.doPutButton, "NewServletClassDataModel.DO_PUT", null);
        this.doDeleteButton = new Button(comp, 32);
        this.doDeleteButton.setText("do&Delete");
        this.synchHelper.synchCheckbox(this.doDeleteButton, "NewServletClassDataModel.DO_DELETE", null);
        this.doHeadButton = new Button(comp, 32);
        this.doHeadButton.setText("do&Head");
        this.synchHelper.synchCheckbox(this.doHeadButton, "NewServletClassDataModel.DO_HEAD", null);
        this.doOptionsButton = new Button(comp, 32);
        this.doOptionsButton.setText("do&Options");
        this.synchHelper.synchCheckbox(this.doOptionsButton, "NewServletClassDataModel.DO_OPTIONS", null);
        this.doTraceButton = new Button(comp, 32);
        this.doTraceButton.setText("do&Trace");
        this.synchHelper.synchCheckbox(this.doTraceButton, "NewServletClassDataModel.DO_TRACE", null);
        this.interfaceViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Dialog.applyDialogFont((Control)parent);
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"NewJavaClassDataModel.INTERFACES"};
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        if (selection.isEmpty()) {
            this.removeButton.setEnabled(false);
            return;
        }
        ServletSupertypesValidator validator = new ServletSupertypesValidator(this.getDataModel());
        if (validator.isGenericServletSuperclass()) {
            this.removeButton.setEnabled(true);
            return;
        }
        Iterator iter = selection.iterator();
        if (iter.hasNext()) {
            if ("javax.servlet.Servlet".equals(iter.next())) {
                this.removeButton.setEnabled(false);
            }
            return;
        }
        this.removeButton.setEnabled(true);
    }
}

