/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.wizard;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.internal.war.ui.util.WebServletGroupItemProvider;
import org.eclipse.jst.j2ee.internal.wizard.AnnotationsStandaloneGroup;
import org.eclipse.jst.j2ee.internal.wizard.NewJavaClassWizardPage;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.servlet.ui.internal.navigator.CompressedJavaProject;
import org.eclipse.jst.servlet.ui.internal.wizard.IWebWizardConstants;
import org.eclipse.jst.servlet.ui.internal.wizard.MultiSelectFilteredFileSelectionDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class NewServletClassWizardPage
extends NewJavaClassWizardPage {
    private AnnotationsStandaloneGroup annotationsGroup = null;
    private Button existingClassButton;
    private Label existingClassLabel;
    private Text existingClassText;
    private Button existingButton;
    private static final String[] JSPEXTENSIONS = new String[]{"jsp"};

    public NewServletClassWizardPage(IDataModel model, String pageName, String pageDesc, String pageTitle, String moduleType) {
        super(model, pageName, pageDesc, pageTitle, moduleType);
    }

    private void createAnnotationsGroup(Composite parent) {
        if (this.isWebDocletProject()) {
            this.annotationsGroup = new AnnotationsStandaloneGroup(parent, (Object)this.model, "jst.ejb".equals(this.projectType), "jst.web".equals(this.projectType));
            if (!this.model.isPropertySet("IArtifactEditOperationDataModelProperties.PROJECT_NAME")) {
                return;
            }
            IProject project = ProjectUtilities.getProject((String)this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME"));
            this.annotationsGroup.setEnablement(project);
        } else {
            this.model.setProperty("IAnnotationsDataModel.useAnnotations", (Object)false);
        }
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = super.createTopLevelComposite(parent);
        this.addSeperator(composite, 3);
        this.createUseExistingGroup(composite);
        this.createAnnotationsGroup(composite);
        return composite;
    }

    private void createUseExistingGroup(Composite composite) {
        this.existingButton = new Button(composite, 32);
        this.existingButton.setText(IWebWizardConstants.USE_EXISTING_SERVLET_CLASS);
        GridData data = new GridData(256);
        data.horizontalSpan = 3;
        this.existingButton.setLayoutData((Object)data);
        this.synchHelper.synchCheckbox(this.existingButton, "NewServletClassDataModel.USE_EXISTING_CLASS", null);
        this.existingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewServletClassWizardPage.this.handleExistingButtonSelected();
            }
        });
        this.existingClassLabel = new Label(composite, 16384);
        this.existingClassLabel.setText(IWebWizardConstants.CLASS_NAME_LABEL);
        this.existingClassLabel.setLayoutData((Object)new GridData(32));
        this.existingClassLabel.setEnabled(false);
        this.existingClassText = new Text(composite, 2060);
        this.existingClassText.setLayoutData((Object)new GridData(768));
        this.existingClassText.setEnabled(false);
        this.synchHelper.synchText(this.existingClassText, "NewJavaClassDataModel.CLASS_NAME", null);
        this.existingClassButton = new Button(composite, 8);
        this.existingClassButton.setText(IWebWizardConstants.BROWSE_BUTTON_LABEL);
        this.existingClassButton.setLayoutData((Object)new GridData(256));
        this.existingClassButton.setEnabled(false);
        this.existingClassButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewServletClassWizardPage.this.handleClassButtonSelected();
            }
        });
    }

    private void handleExistingButtonSelected() {
        boolean enable = this.existingButton.getSelection();
        this.existingClassLabel.setEnabled(enable);
        this.existingClassButton.setEnabled(enable);
        this.packageText.setEnabled(!enable);
        this.packageButton.setEnabled(!enable);
        this.packageLabel.setEnabled(!enable);
        this.classText.setEnabled(!enable);
        this.classLabel.setEnabled(!enable);
        this.superText.setEnabled(!enable);
        this.superButton.setEnabled(!enable);
        this.superLabel.setEnabled(!enable);
    }

    private void handleClassButtonSelected() {
        this.getControl().setCursor(new Cursor((Device)this.getShell().getDisplay(), 1));
        IProject project = (IProject)this.model.getProperty("NewJavaClassDataModel.PROJECT");
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        MultiSelectFilteredFileSelectionDialog ms = new MultiSelectFilteredFileSelectionDialog(this.getShell(), IWebWizardConstants.NEW_SERVLET_WIZARD_WINDOW_TITLE, IWebWizardConstants.CHOOSE_SERVLET_CLASS, JSPEXTENSIONS, false, project);
        IContainer root = component.getRootFolder().getUnderlyingFolder();
        ms.setInput(root);
        ms.open();
        if (ms.getReturnCode() == 0) {
            String qualifiedClassName = "";
            if (ms.getSelectedItem() == 0) {
                Object obj = ms.getFirstResult();
                if (obj != null && obj instanceof IFile) {
                    IFile file = (IFile)obj;
                    IPath pFull = file.getFullPath();
                    IPath pBase = root.getFullPath();
                    IPath path = pFull.removeFirstSegments(pBase.segmentCount());
                    qualifiedClassName = path.makeAbsolute().toString();
                    this.model.setProperty("NewServletClassDataModel.IS_SERVLET_TYPE", (Object)new Boolean(false));
                }
            } else {
                IType type = (IType)ms.getFirstResult();
                if (type != null) {
                    qualifiedClassName = type.getFullyQualifiedName();
                    this.model.setProperty("NewServletClassDataModel.IS_SERVLET_TYPE", (Object)new Boolean(true));
                }
            }
            this.existingClassText.setText(qualifiedClassName);
        }
        this.getControl().setCursor(null);
    }

    protected IProject getExtendedSelectedProject(Object selection) {
        if (selection instanceof WebServletGroupItemProvider) {
            WebApp webApp = (WebApp)((WebServletGroupItemProvider)selection).getParent();
            return ProjectUtilities.getProject((EObject)webApp);
        }
        if (selection instanceof CompressedJavaProject) {
            return ((CompressedJavaProject)selection).getProject().getProject();
        }
        return super.getExtendedSelectedProject(selection);
    }

    private boolean isWebDocletProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        if (projectName != null && !"".equals(projectName.trim())) {
            IProject project = ProjectUtilities.getProject((String)projectName);
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                return facetedProject.hasProjectFacet(WebFacetUtils.WEB_XDOCLET_FACET);
            }
            catch (CoreException e) {
                Logger.getLogger().log((Throwable)e);
            }
        }
        return false;
    }
}

