/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotation.internal.model;

import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.ejb.SessionType;
import org.eclipse.jst.j2ee.ejb.TransactionType;
import org.eclipse.jst.j2ee.ejb.annotation.internal.model.EnterpriseBeanDelegate;
import org.eclipse.jst.j2ee.ejb.annotation.internal.model.ISessionBean;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class SessionBeanDelegate
extends EnterpriseBeanDelegate
implements ISessionBean {
    public SessionBeanDelegate() {
        Session sessionBean = EjbFactory.eINSTANCE.createSession();
        this.setEnterpriseBean((EnterpriseBean)sessionBean);
    }

    public void setDataModel(IDataModel dataModel) {
        super.setDataModel(dataModel);
        Session session = (Session)this.getEnterpriseBean();
        if (session == null) {
            return;
        }
        SessionType sessionBeanType = SessionType.STATELESS_LITERAL;
        if (dataModel.getStringProperty("SessionBeanDataModel.STATELESS").equals(SessionType.STATEFUL_LITERAL.getName())) {
            sessionBeanType = SessionType.STATEFUL_LITERAL;
        }
        session.setSessionType(sessionBeanType);
        TransactionType transactionType = TransactionType.CONTAINER_LITERAL;
        if (dataModel.getStringProperty("IEjbCommonDataModel.TRANSACTIONTYPE").equals(TransactionType.BEAN_LITERAL.getName())) {
            transactionType = TransactionType.BEAN_LITERAL;
        }
        session.setTransactionType(transactionType);
    }

    public String getSessionType() {
        Session session = (Session)this.getEnterpriseBean();
        return session.getSessionType().getName();
    }

    public String getTransactionType() {
        Session session = (Session)this.getEnterpriseBean();
        return session.getTransactionType().getName();
    }

    public void propertyChanged(DataModelEvent event) {
        super.propertyChanged(event);
        String property = event.getPropertyName();
        Object propertyValue = event.getProperty();
        Session session = (Session)this.getEnterpriseBean();
        if (session == null) {
            return;
        }
        if ("SessionBeanDataModel.STATELESS".equals(property)) {
            SessionType sessionBeanType = SessionType.STATELESS_LITERAL;
            if (propertyValue.equals(SessionType.STATEFUL_LITERAL.getName())) {
                sessionBeanType = SessionType.STATEFUL_LITERAL;
            }
            session.setSessionType(sessionBeanType);
        } else if ("IEjbCommonDataModel.TRANSACTIONTYPE".equals(property)) {
            TransactionType transactionType = TransactionType.CONTAINER_LITERAL;
            if (propertyValue.equals(TransactionType.BEAN_LITERAL.getName())) {
                transactionType = TransactionType.BEAN_LITERAL;
            }
            session.setTransactionType(transactionType);
        }
    }
}

