/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;
import org.eclipse.wst.ws.service.policy.IPolicyState;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.ServicePolicyPlatform;
import org.eclipse.wst.ws.service.policy.listeners.IPolicyPlatformLoadListener;

public class MigrateWSIpreferencesLoadListener
implements IPolicyPlatformLoadListener {
    private static final String[] ENUM_ID_VALUES = new String[]{"org.eclipse.wst.sug.require", "org.eclipse.wst.sug.suggest", "org.eclipse.wst.sug.ignore"};
    private static final String[] CONTEXT_IDS = new String[]{"0", "1", "2"};

    public void load() {
        String oldProperty;
        IProject project;
        QualifiedName name;
        ServicePolicyPlatform platform;
        IEclipsePreferences preferences = new InstanceScope().getNode("org.eclipse.wst.ws.service.policy");
        String apValue = preferences.get("org.eclipse.wst.ws.service.policy.ui.servicepols.wsiprofilecomp.wsiap.value", null);
        String ssbpValue = preferences.get("org.eclipse.wst.ws.service.policy.ui.servicepols.wsiprofilecomp.wsissbp.value", null);
        Preferences oldPrefs = WSPlugin.getInstance().getPluginPreferences();
        String[] oldPropNames = oldPrefs.propertyNames();
        if (apValue == null) {
            platform = ServicePolicyPlatform.getInstance();
            IServicePolicy apPolicy = platform.getServicePolicy("org.eclipse.wst.ws.service.policy.ui.servicepols.wsiprofilecomp.wsiap");
            IPolicyState apState = apPolicy.getPolicyState();
            if (this.indexOfString("nonWSIAPCompliance", oldPropNames) != -1) {
                String oldApValue = oldPrefs.getString("nonWSIAPCompliance");
                int oldApIndex = this.indexOfString(oldApValue, CONTEXT_IDS);
                String newApValue = null;
                if (oldApIndex < ENUM_ID_VALUES.length) {
                    newApValue = ENUM_ID_VALUES[oldApIndex];
                }
                if (newApValue != null) {
                    apState.putValue("default.value.key", newApValue);
                }
            }
            name = new QualifiedName("org.eclipse.wst.ws", "nonWSIAPCompliance");
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                try {
                    project = projects[i];
                    oldProperty = null;
                    oldProperty = project.getPersistentProperty(name);
                    if (oldProperty != null && !oldProperty.equals("")) {
                        int oldApIndex = this.indexOfString(oldProperty, CONTEXT_IDS);
                        String newApValue = null;
                        if (oldApIndex != -1 && oldApIndex < ENUM_ID_VALUES.length) {
                            newApValue = ENUM_ID_VALUES[oldApIndex];
                        }
                        if (newApValue != null) {
                            apState = apPolicy.getPolicyState(project);
                            platform.setProjectPreferencesEnabled(project, true);
                            apState.putValue("default.value.key", newApValue);
                        }
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
        }
        if (ssbpValue == null) {
            platform = ServicePolicyPlatform.getInstance();
            IServicePolicy ssbpPolicy = platform.getServicePolicy("org.eclipse.wst.ws.service.policy.ui.servicepols.wsiprofilecomp.wsissbp");
            IPolicyState ssbpState = ssbpPolicy.getPolicyState();
            if (this.indexOfString("nonWSISSBPCompliance", oldPropNames) != -1) {
                String oldSSBPValue = oldPrefs.getString("nonWSISSBPCompliance");
                int oldSSBPIndex = this.indexOfString(oldSSBPValue, CONTEXT_IDS);
                String newSSBPValue = null;
                if (oldSSBPIndex < ENUM_ID_VALUES.length) {
                    newSSBPValue = ENUM_ID_VALUES[oldSSBPIndex];
                }
                if (newSSBPValue != null) {
                    ssbpState.putValue("default.value.key", newSSBPValue);
                }
            }
            name = new QualifiedName("org.eclipse.wst.ws", "nonWSISSBPCompliance");
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                try {
                    project = projects[i];
                    oldProperty = null;
                    oldProperty = project.getPersistentProperty(name);
                    if (oldProperty != null && !oldProperty.equals("")) {
                        int oldSSBPIndex = this.indexOfString(oldProperty, CONTEXT_IDS);
                        String newSSBPValue = null;
                        if (oldSSBPIndex != -1 && oldSSBPIndex < ENUM_ID_VALUES.length) {
                            newSSBPValue = ENUM_ID_VALUES[oldSSBPIndex];
                        }
                        if (newSSBPValue != null) {
                            ssbpState = ssbpPolicy.getPolicyState(project);
                            platform.setProjectPreferencesEnabled(project, true);
                            ssbpState.putValue("default.value.key", newSSBPValue);
                        }
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
        }
    }

    private int indexOfString(String target, String[] values) {
        int result = -1;
        int index = 0;
        while (index < values.length) {
            String value = values[index];
            if (value.equals(target)) {
                result = index;
                break;
            }
            ++index;
        }
        return result;
    }
}

