/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.EnvironmentService;
import org.eclipse.wst.common.environment.uri.IURIScheme;
import org.eclipse.wst.common.environment.uri.SimpleURIFactory;
import org.eclipse.wst.common.environment.uri.URIException;
import org.eclipse.wst.common.uriresolver.internal.util.URIEncoder;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.ws.internal.WstWSPluginMessages;
import org.eclipse.wst.ws.internal.parser.discovery.NetUtils;
import org.eclipse.wst.ws.internal.parser.wsil.WWWAuthenticationException;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.util.UniversalPathTransformer;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.internal.impl.wsdl4j.WSDLFactoryImpl;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDLCopier
implements IWorkspaceRunnable {
    private static final String XSD = ".xsd";
    private WebServicesParser parser = null;
    private String sourceURI = "";
    private Definition definition = null;
    private String targetFolderURI = null;
    private String targetFilename = null;
    private IPath pathPrefix = null;
    private IPath wsdlRelPath = null;
    private Map xmlObjectInfos = new LinkedHashMap();
    private SimpleURIFactory uriFactory = null;

    public WSDLCopier() {
        this(null);
    }

    public WSDLCopier(WebServicesParser parser) {
        this.parser = parser == null ? new WebServicesParser() : parser;
        IURIScheme eclipseScheme = EnvironmentService.getEclipseScheme();
        IURIScheme fileScheme = EnvironmentService.getFileScheme();
        this.uriFactory = new SimpleURIFactory();
        this.uriFactory.registerScheme("platform", eclipseScheme);
        this.uriFactory.registerScheme("file", fileScheme);
    }

    public void setSourceURI(String uri) {
        this.setSourceURI(uri, null);
    }

    public void setSourceURI(String uri, Definition definition) {
        if (uri != null) {
            uri = uri.replace('\\', '/');
        }
        this.sourceURI = uri;
        this.definition = definition;
    }

    public void setTargetFolderURI(String uri) {
        if (uri != null) {
            uri = uri.replace('\\', '/');
        }
        this.targetFolderURI = uri;
    }

    public void setTargetFilename(String filename) {
        this.targetFilename = filename;
    }

    private void updatePathPrefix(XMLObjectInfo info) {
        if (this.pathPrefix == null) {
            this.pathPrefix = info.path.removeLastSegments(1);
        } else {
            int matching = this.pathPrefix.matchingFirstSegments(info.path);
            if (matching < this.pathPrefix.segmentCount()) {
                this.pathPrefix = this.pathPrefix.uptoSegment(matching);
            }
        }
    }

    private boolean isRelative(String uri) {
        return uri.indexOf(58) == -1;
    }

    private void analyzeWSDL(URI uri, Definition definition) throws MalformedURLException, IOException, WSDLException, WWWAuthenticationException {
        if (this.xmlObjectInfos.containsKey((uri = uri.normalize()).toString())) {
            return;
        }
        if (definition == null) {
            definition = this.parser.getWSDLDefinitionVerbose(uri.toString());
        }
        if (this.definition == null) {
            this.definition = definition;
        }
        Path path = new Path(uri.getPath());
        if (definition == this.definition && this.targetFilename != null) {
            path = path.removeLastSegments(1).append(this.targetFilename);
        }
        XMLObjectInfo info = new XMLObjectInfo((IPath)path, definition);
        this.xmlObjectInfos.put(uri.toString(), info);
        this.updatePathPrefix(info);
        for (List list : definition.getImports().values()) {
            for (Import wsdlImport : list) {
                String wsdlImportLocation = wsdlImport.getLocationURI();
                if (wsdlImportLocation == null || !this.isRelative(wsdlImportLocation)) continue;
                if (wsdlImportLocation.endsWith(XSD)) {
                    this.analyzeXSD(uri.resolve(wsdlImportLocation));
                    continue;
                }
                this.analyzeWSDL(uri.resolve(wsdlImportLocation), null);
            }
        }
        Types types = definition.getTypes();
        if (types == null) {
            return;
        }
        for (ExtensibilityElement extElement : types.getExtensibilityElements()) {
            Element element;
            if (extElement instanceof UnknownExtensibilityElement) {
                element = ((UnknownExtensibilityElement)extElement).getElement();
            } else {
                if (!(extElement instanceof XSDSchemaExtensibilityElement)) continue;
                element = ((XSDSchemaExtensibilityElement)extElement).getElement();
            }
            try {
                XSDSchema xsdSchema = XSDSchemaImpl.createSchema((Node)element);
                this.analyzeXSD(uri, xsdSchema);
            }
            catch (Exception exception) {}
        }
    }

    private void analyzeXSD(URI uri, XSDSchema schema) {
        if (schema == null) {
            return;
        }
        for (Object content : schema.getContents()) {
            XSDSchemaDirective xsdSchemaDirective;
            String xsdSchemaDirectiveLocation;
            if (!(content instanceof XSDSchemaDirective) || (xsdSchemaDirectiveLocation = (xsdSchemaDirective = (XSDSchemaDirective)content).getSchemaLocation()) == null || !this.isRelative(xsdSchemaDirectiveLocation)) continue;
            this.analyzeXSD(uri.resolve(xsdSchemaDirectiveLocation));
        }
    }

    private void analyzeXSD(URI uri) {
        if (this.xmlObjectInfos.containsKey((uri = uri.normalize()).toString())) {
            return;
        }
        XSDSchema xsdSchema = XSDSchemaImpl.getSchemaForSchema((String)uri.toString());
        if (xsdSchema == null) {
            XSDParser p = new XSDParser(null);
            InputStream is = NetUtils.getURLInputStream((String)uri.toString());
            if (is != null) {
                p.parse(is);
                xsdSchema = p.getSchema();
            }
        }
        if (xsdSchema != null) {
            XMLObjectInfo info = new XMLObjectInfo((IPath)new Path(uri.getPath()), xsdSchema);
            this.xmlObjectInfos.put(uri.toString(), info);
            this.updatePathPrefix(info);
            this.analyzeXSD(uri, xsdSchema);
        }
    }

    private String appendPathToURI(String uri, IPath path) {
        if (uri.endsWith("/")) {
            return String.valueOf(uri) + path.makeRelative();
        }
        return String.valueOf(uri) + path.makeAbsolute();
    }

    private String writeXMLObj(IPath path, Definition definition, IProgressMonitor monitor) throws WSDLException, URIException, IOException, CoreException {
        WSDLFactoryImpl wsdlFactory = new WSDLFactoryImpl();
        WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
        String targetURI = this.appendPathToURI(this.targetFolderURI, path);
        OutputStream os = this.uriFactory.newURI(targetURI).getOutputStream();
        wsdlWriter.writeWSDL(definition, os);
        os.close();
        return targetURI;
    }

    private String writeXMLObj(IPath path, XSDSchema xsdSchema, IProgressMonitor monitor) throws TransformerConfigurationException, TransformerException, URIException, IOException, CoreException {
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("encoding", "UTF-8");
        serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        Element e = xsdSchema.getElement();
        DOMSource domSource = new DOMSource(e);
        String targetURI = this.appendPathToURI(this.targetFolderURI, path);
        OutputStream os = this.uriFactory.newURI(targetURI).getOutputStream();
        serializer.transform(domSource, new StreamResult(os));
        os.close();
        return targetURI;
    }

    private boolean isSameLocation(String uri1, String uri2) {
        if (uri1 == null || uri2 == null) {
            return false;
        }
        uri1 = UniversalPathTransformer.toLocation(uri1);
        uri2 = UniversalPathTransformer.toLocation(uri2);
        return uri1.equals(uri2);
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        this.xmlObjectInfos.clear();
        if (this.targetFolderURI == null) {
            throw new CoreException(StatusUtils.errorStatus((String)WstWSPluginMessages.MSG_ERROR_TARGET_FOLDER_NOT_SPECIFIED));
        }
        try {
            URI uri = URIHelper.isProtocolFile((String)this.sourceURI) || URIHelper.isPlatformResourceProtocol((String)this.sourceURI) ? new URI(URIEncoder.encode((String)this.sourceURI, (String)"UTF-8")) : new URI(this.sourceURI);
            this.analyzeWSDL(uri, this.definition);
            for (XMLObjectInfo info : this.xmlObjectInfos.values()) {
                IPath relPath = info.path.removeFirstSegments(this.pathPrefix.segmentCount());
                if (info.content instanceof Definition) {
                    Definition definition = (Definition)info.content;
                    if (definition == this.definition) {
                        this.wsdlRelPath = relPath;
                    }
                    String targetURI = this.writeXMLObj(relPath, definition, monitor);
                    if (definition != this.definition || !this.isSameLocation(uri.toString(), targetURI)) continue;
                    return;
                }
                this.writeXMLObj(relPath, (XSDSchema)info.content, monitor);
            }
        }
        catch (Exception t) {
            throw new CoreException(StatusUtils.errorStatus((String)NLS.bind((String)WstWSPluginMessages.MSG_ERROR_COPY_WSDL, (Object[])new String[]{this.sourceURI, this.targetFolderURI}), (Throwable)t));
        }
    }

    public IPath getRelativePath() {
        return this.wsdlRelPath;
    }

    private class XMLObjectInfo {
        public IPath path;
        public Object content;

        public XMLObjectInfo(IPath path, Object content) {
            this.path = path.setDevice(null);
            this.content = content;
        }
    }
}

