/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.resources;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class VirtualFolder
extends VirtualContainer
implements IVirtualFolder {
    public VirtualFolder(IProject aComponentProject, IPath aRuntimePath) {
        super(aComponentProject, aRuntimePath);
    }

    public void create(int updateFlags, IProgressMonitor monitor) throws CoreException {
        IVirtualComponent container = ComponentCore.createComponent(this.getProject());
        if (!container.getRootFolder().getProjectRelativePath().isRoot()) {
            IFolder realFolder = this.getProject().getFolder(container.getRootFolder().getProjectRelativePath());
            IFolder newFolder = realFolder.getFolder(this.getRuntimePath());
            this.createResource((IContainer)newFolder, updateFlags, monitor);
        } else {
            IFolder newFolder = this.getProject().getFolder(this.getRuntimePath());
            this.createResource((IContainer)newFolder, updateFlags, monitor);
        }
    }

    public boolean exists(IPath path) {
        throw new UnsupportedOperationException("Method not supported");
    }

    public int getType() {
        return 32;
    }

    public IResource getUnderlyingResource() {
        return this.getUnderlyingFolder();
    }

    public IResource[] getUnderlyingResources() {
        return this.getUnderlyingFolders();
    }

    public IContainer getUnderlyingFolder() {
        IPath path = this.getProjectRelativePath();
        if (!path.isRoot()) {
            return this.getProject().getFolder(this.getProjectRelativePath());
        }
        return this.getProject();
    }

    public IContainer[] getUnderlyingFolders() {
        IPath[] paths = this.getProjectRelativePaths();
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < paths.length) {
            if (!paths[i].isRoot()) {
                IFolder folder = this.getProject().getFolder(paths[i]);
                if (folder != null && folder.exists() && !result.contains(folder)) {
                    result.add(folder);
                }
            } else {
                result.add(this.getProject());
            }
            ++i;
        }
        return result.toArray(new IContainer[result.size()]);
    }

    protected void doDeleteMetaModel(int updateFlags, IProgressMonitor monitor) {
        StructureEdit moduleCore = null;
        try {
            IPath runtimePath = this.getRuntimePath();
            moduleCore = StructureEdit.getStructureEditForWrite(this.getProject());
            WorkbenchComponent component = moduleCore.getComponent();
            ComponentResource[] resources = component.findResourcesByRuntimePath(runtimePath);
            int i = 0;
            while (i < resources.length) {
                if (runtimePath.equals((Object)resources[i].getRuntimePath())) {
                    component.getResources().remove((Object)resources[i]);
                }
                ++i;
            }
        }
        finally {
            if (moduleCore != null) {
                moduleCore.saveIfNecessary(null);
                moduleCore.dispose();
            }
        }
    }

    protected void doDeleteRealResources(int updateFlags, IProgressMonitor monitor) throws CoreException {
        StructureEdit moduleCore = null;
        try {
            IPath runtimePath = this.getRuntimePath();
            moduleCore = StructureEdit.getStructureEditForWrite(this.getProject());
            WorkbenchComponent component = moduleCore.getComponent();
            ComponentResource[] resources = component.findResourcesByRuntimePath(runtimePath);
            int i = 0;
            while (i < resources.length) {
                IResource realResource;
                if (runtimePath.equals((Object)resources[i].getRuntimePath()) && (realResource = StructureEdit.getEclipseResource(resources[i])) != null && realResource.getType() == this.getType()) {
                    realResource.delete(updateFlags, monitor);
                }
                ++i;
            }
        }
        finally {
            if (moduleCore != null) {
                moduleCore.saveIfNecessary(null);
                moduleCore.dispose();
            }
        }
    }
}

