/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dnd.internal;

import org.eclipse.gef.SharedCursors;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.EditValidateUtil;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class SourceViewerDragDropHelper {
    private static SourceViewerDragDropHelper _instance;

    public static SourceViewerDragDropHelper getInstance() {
        if (_instance == null) {
            _instance = new SourceViewerDragDropHelper();
        }
        return _instance;
    }

    private SourceViewerDragDropHelper() {
    }

    private Point toControl(TextViewer textViewer, Point point) {
        return textViewer != null ? textViewer.getTextWidget().toControl(point) : point;
    }

    /*
     * Unable to fully structure code
     */
    private int getDropOffset(StructuredTextEditor ste, Point pt) {
        block10: {
            st = ste.getTextViewer().getTextWidget();
            offset = st.getCaretOffset();
            try {
                offset = st.getOffsetAtLocation(pt);
                break block10;
            }
            catch (IllegalArgumentException v0) {
                found = false;
                p = new Point(pt.x > 0 ? pt.x : 0, pt.y);
                ** while (p.x > -1)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    offset = st.getOffsetAtLocation(p);
                    if (ste.getTextViewer() != null && ste.getTextViewer().getDocument() != null) {
                        lineInfo = null;
                        try {
                            lineInfo = ste.getTextViewer().getDocument().getLineInformationOfOffset(offset);
                        }
                        catch (BadLocationException v1) {}
                        if (lineInfo != null) {
                            offset = lineInfo.getOffset() + lineInfo.getLength();
                        }
                    }
                    found = true;
                    break;
                }
                catch (IllegalArgumentException v2) {
                    --p.x;
                }
                continue;
            }
lbl25:
            // 2 sources

            if (!found) {
                offset = st.getCharCount();
            }
        }
        return offset;
    }

    public void updateCaret(StructuredTextEditor textEditor, Point location, Point caret) {
        StructuredTextViewer textViewer = textEditor.getTextViewer();
        if (textViewer != null) {
            Point newCaret;
            Point pt = this.toControl((TextViewer)textViewer, location);
            StyledText st = textViewer.getTextWidget();
            Rectangle ca = st.getClientArea();
            int margin = st.getLineHeight();
            if (pt.y < margin) {
                st.invokeAction(0x1000001);
            } else if (pt.y > ca.height - margin) {
                st.invokeAction(0x1000002);
            }
            int offset = this.getDropOffset(textEditor, pt);
            if (offset != st.getCaretOffset()) {
                st.setCaretOffset(offset);
                st.setSelection(offset);
            }
            if ((newCaret = st.getLocationAtOffset(offset)).equals((Object)caret)) {
                return;
            }
            Caret ct = st.getCaret();
            Point size = ct.getSize();
            GC gc = new GC((Drawable)st);
            gc.setXORMode(true);
            gc.setLineWidth(size.x);
            if (caret != null) {
                Color originalForeground = gc.getForeground();
                gc.setForeground(st.getBackground());
                gc.drawLine(caret.x, caret.y, caret.x, caret.y + size.y);
                gc.setForeground(originalForeground);
            }
            st.redraw();
            st.update();
            if (caret == null) {
                caret = newCaret;
            } else {
                caret.x = newCaret.x;
                caret.y = newCaret.y;
            }
            if (ct.getImage() != null) {
                gc.drawImage(ct.getImage(), caret.x, caret.y);
            } else {
                gc.drawLine(caret.x, caret.y, caret.x, caret.y + size.y);
            }
            gc.dispose();
        }
    }

    public void updateCaret(StructuredTextEditor textEditor, Point location) {
        StructuredTextViewer textViewer = textEditor.getTextViewer();
        if (textViewer != null) {
            Point pt = this.toControl((TextViewer)textViewer, location);
            StyledText st = textViewer.getTextWidget();
            Rectangle ca = st.getClientArea();
            int margin = st.getLineHeight();
            if (pt.y < margin) {
                st.invokeAction(0x1000001);
            } else if (pt.y > ca.height - margin) {
                st.invokeAction(0x1000002);
            }
            int offset = this.getDropOffset(textEditor, pt);
            if (offset != st.getCaretOffset()) {
                st.setCaretOffset(offset);
                st.setSelection(offset);
            }
        }
    }

    public int showCaret(StructuredTextEditor textEditor, int location) {
        StyledText text = textEditor.getTextViewer().getTextWidget();
        text.setCursor(SharedCursors.CURSOR_TREE_ADD);
        text.setCaretOffset(location);
        if (!text.isFocusControl()) {
            text.setFocus();
        }
        return text.getCaretOffset();
    }

    protected ModelQuery getModelQuery(Node node) {
        if (node.getNodeType() == 9) {
            return ModelQueryUtil.getModelQuery((Document)((Document)node));
        }
        return ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument());
    }

    public IDOMPosition findPosition(int caretPos, Node element) {
        EditValidateUtil.validNode(element);
        IDOMPosition position = EditModelQuery.getInstance().createDomposition(((IDOMNode)element).getModel(), caretPos, false);
        return position;
    }

    public void format(TextViewer viewer, Node node) {
        int offset;
        int start;
        Node tmp;
        if (node == null) {
            return;
        }
        if (node.getPreviousSibling() != null) {
            tmp = node.getPreviousSibling();
            start = ((IndexedRegion)tmp).getEndOffset();
        } else {
            tmp = node;
            start = ((IndexedRegion)tmp).getStartOffset();
        }
        if (node.getNextSibling() != null) {
            tmp = node.getNextSibling();
            offset = ((IndexedRegion)tmp).getStartOffset() - start;
        } else {
            tmp = node;
            offset = ((IndexedRegion)tmp).getEndOffset() - start;
        }
        viewer.setSelectedRange(start, offset);
        viewer.doOperation(15);
    }

    public void changeCaret(StructuredTextEditor textEditor, boolean reset) {
        if (reset) {
            StyledText text = textEditor.getTextViewer().getTextWidget();
            text.setCursor(new Cursor(null, 19));
        }
    }

    public int getValidLocation(StructuredTextEditor textEditor, int locationOffset) {
        Node node = this.getCaretNode(textEditor, locationOffset);
        if (node == null) {
            return 0;
        }
        if (node.getNodeType() == 3) {
            return locationOffset;
        }
        return this.calculateCaretLocation(node, locationOffset);
    }

    public int getOffset(StructuredTextEditor textEditor, Point location) {
        StyledText text = textEditor.getTextViewer().getTextWidget();
        return text.getOffsetAtLocation(location);
    }

    public Node getCaretNode(StructuredTextEditor textEditor, int pos) {
        IStructuredModel model = textEditor.getModel();
        if (model == null) {
            return null;
        }
        IndexedRegion inode = model.getIndexedRegion(pos);
        if (inode == null) {
            inode = model.getIndexedRegion(pos - 1);
        }
        return inode instanceof Node ? (Node)inode : null;
    }

    public int calculateCaretLocation(Node node, int location) {
        int[][] pos = new int[2][2];
        pos[0][0] = EditModelQuery.getNodeStartIndex(node);
        pos[0][1] = EditModelQuery.getNodeStartNameEndIndex(node);
        pos[1][0] = EditModelQuery.getNodeEndNameStartIndex(node);
        pos[1][1] = EditModelQuery.getNodeEndIndex(node);
        if (pos[0][0] >= location || pos[1][0] == location || pos[1][1] <= location) {
            return location;
        }
        if (pos[0][0] <= location && pos[0][1] >= location) {
            if ((pos[0][1] + pos[0][0]) / 2 >= location) {
                return pos[0][0];
            }
            return pos[0][1];
        }
        if (pos[1][0] <= location && pos[1][1] >= location) {
            if ((pos[1][1] + pos[1][0]) / 2 >= location) {
                return pos[1][0];
            }
            return pos[1][1];
        }
        return location;
    }
}

