/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.palette.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IImageDescriptorProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.editors.palette.IPaletteItemManager;
import org.eclipse.jst.pagedesigner.editors.palette.TagToolPaletteEntry;
import org.eclipse.jst.pagedesigner.editors.palette.impl.TaglibPaletteDrawer;
import org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.PaletteInfo;
import org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.PaletteInfos;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLCMDocument;
import org.eclipse.wst.html.core.internal.contentmodel.JSPCMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;

public class PaletteHelper {
    private static final Pattern removeHTMLTags = Pattern.compile("<[/?\\w\\s=\"\\.\\#]+>");
    private static final Pattern trimInteriorWhitespace = Pattern.compile("[ ]+");
    private static final Pattern removeNewLines = Pattern.compile("[\n]");
    private static final ImageDescriptor DEFAULT_SMALL_ICON = PDPlugin.getDefault().getImageDescriptor("palette/GENERIC/small/PD_Palette_Default.gif");
    private static final ImageDescriptor DEFAULT_LARGE_ICON = PDPlugin.getDefault().getImageDescriptor("palette/GENERIC/large/PD_Palette_Default.gif");
    private static final int DESCRIPTION_TRUNCATE_HARD_LENGTH = 250;

    public static TaglibPaletteDrawer configPaletteItemsByTLD(IPaletteItemManager manager, IProject project, CMDocument doc) {
        String tldURI = null;
        if (doc instanceof TLDDocument) {
            tldURI = ((TLDDocument)doc).getUri();
        } else if (doc instanceof HTMLCMDocument) {
            tldURI = "HTML";
        } else if (doc instanceof JSPCMDocument) {
            tldURI = "JSP11";
        }
        if (tldURI == null) {
            return null;
        }
        TaglibPaletteDrawer category = PaletteHelper.findCategory(manager, tldURI);
        if (category != null) {
            return category;
        }
        ITaglibDomainMetaDataModelContext modelContext = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)project, (String)tldURI);
        Model model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)modelContext);
        category = PaletteHelper.createTaglibPaletteDrawer(manager, doc, model);
        if (category != null) {
            PaletteHelper.loadTags(category, doc, model);
            PaletteHelper.sortTags(category.getChildren());
        }
        return category;
    }

    private static void sortTags(List tags) {
        Collections.sort(tags, new Comparator(){

            public int compare(Object o1, Object o2) {
                String label1 = ((PaletteEntry)o1).getLabel();
                String label2 = ((PaletteEntry)o2).getLabel();
                if (label1 == null) {
                    if (label2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (label2 == null) {
                    if (label1 == null) {
                        return 0;
                    }
                    return -1;
                }
                return label1.compareTo(label2);
            }
        });
    }

    private static void loadTags(TaglibPaletteDrawer category, CMDocument doc, Model model) {
        if (model != null) {
            Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)model, (String)"paletteInfos");
            if (trait != null) {
                PaletteInfos tags = (PaletteInfos)trait.getValue();
                for (PaletteInfo tag : tags.getInfos()) {
                    PaletteHelper.createTagEntry(category, tag);
                }
            } else {
                for (Entity tagAsEntity : model.getChildEntities()) {
                    PaletteHelper.createTagEntry(category, tagAsEntity);
                }
            }
        } else {
            PaletteHelper.loadFromCMDocument(category, doc);
        }
    }

    private static TaglibPaletteDrawer createTaglibPaletteDrawer(IPaletteItemManager manager, CMDocument doc, Model model) {
        TaglibPaletteDrawer category = null;
        if (model != null) {
            boolean isHidden = PaletteHelper.getBooleanTagTraitValue((Entity)model, "hidden", false);
            if (isHidden) {
                return null;
            }
            String label = PaletteHelper.getStringTagTraitValue((Entity)model, "display-label", model.getId());
            label = label.equals("") ? model.getId() : label;
            category = manager.createTaglibPaletteDrawer(model.getId(), label);
            String desc = PaletteHelper.getStringTagTraitValue((Entity)model, "description", model.getId());
            category.setDescription(PaletteHelper.formatDescription(desc));
            ImageDescriptor largeIconImage = PaletteHelper.getImageDescriptorFromTagTraitValueAsString((Entity)model, "small-icon", null);
            if (largeIconImage != null) {
                category.setLargeIcon(largeIconImage);
            }
            String prefix = PaletteHelper.getStringTagTraitValue((Entity)model, "default-prefix", null);
            category.setDefaultPrefix(prefix);
            boolean isVisible = !PaletteHelper.getBooleanTagTraitValue((Entity)model, "expert", false);
            category.setVisible(isVisible);
            category.setInitialState(1);
        }
        return category;
    }

    private static TaglibPaletteDrawer findCategory(IPaletteItemManager manager, String tldURI) {
        TaglibPaletteDrawer lib2 = null;
        for (TaglibPaletteDrawer lib2 : manager.getAllCategories()) {
            if (!tldURI.equals(lib2.getURI())) continue;
            return lib2;
        }
        return null;
    }

    private static void loadFromCMDocument(TaglibPaletteDrawer category, CMDocument cmdoc) {
        CMNamedNodeMap nodeMap = cmdoc.getElements();
        int i = 0;
        int size = nodeMap.getLength();
        while (i < size) {
            TagToolPaletteEntry item;
            CMElementDeclaration eledecl = (CMElementDeclaration)nodeMap.item(i);
            String tagName = eledecl.getElementName();
            if (tagName.equalsIgnoreCase("input")) {
                StringBuffer name = new StringBuffer(category.getURI());
                name.append(":").append(tagName).append(":").append(tagName);
                item = category.getTagPaletteEntryById(name.toString());
            } else {
                item = category.getTagPaletteEntryByTagName(tagName);
            }
            if (item == null) {
                PaletteHelper.createTagEntry(category, eledecl);
            }
            ++i;
        }
    }

    private static void createTagEntry(TaglibPaletteDrawer category, PaletteInfo info) {
        Boolean hidden = info.getHidden();
        if (hidden != null && hidden.booleanValue()) {
            return;
        }
        IMetaDataSourceModelProvider sourceProvider = ((Trait)info.eContainer().eContainer()).getSourceModelProvider();
        String tagName = info.getTag();
        String id = info.getId();
        String label = info.getDisplayLabel();
        String desc = PaletteHelper.formatDescription(info.getDescription());
        ImageDescriptor smallIcon = PaletteHelper.getImageDescriptorFromString(sourceProvider, info.getSmallIcon(), DEFAULT_SMALL_ICON);
        ImageDescriptor largeIcon = PaletteHelper.getImageDescriptorFromString(sourceProvider, info.getLargeIcon(), DEFAULT_LARGE_ICON);
        Boolean expert = info.getExpert();
        PaletteHelper.internalCreateTagEntry(category, id, tagName, label, desc, smallIcon, largeIcon, expert != null && expert != false);
    }

    private static void createTagEntry(TaglibPaletteDrawer category, Entity entity) {
        boolean hidden = PaletteHelper.getBooleanTagTraitValue(entity, "hidden", false);
        if (hidden) {
            return;
        }
        String tagName = entity.getId();
        String label = PaletteHelper.getStringTagTraitValue(entity, "display-label", tagName);
        String desc = PaletteHelper.formatDescription(PaletteHelper.getStringTagTraitValue(entity, "description", tagName));
        ImageDescriptor smallIcon = PaletteHelper.getImageDescriptorFromTagTraitValueAsString(entity, "small-icon", DEFAULT_SMALL_ICON);
        ImageDescriptor largeIcon = PaletteHelper.getImageDescriptorFromTagTraitValueAsString(entity, "large-icon", DEFAULT_LARGE_ICON);
        boolean expert = PaletteHelper.getBooleanTagTraitValue(entity, "expert", false);
        PaletteHelper.internalCreateTagEntry(category, tagName, tagName, label, desc, smallIcon, largeIcon, expert);
    }

    private static TagToolPaletteEntry internalCreateTagEntry(TaglibPaletteDrawer category, String id, String tagName, String label, String desc, ImageDescriptor smallIcon, ImageDescriptor largeIcon, boolean expert) {
        TagToolPaletteEntry item = new TagToolPaletteEntry(tagName, label, desc, smallIcon, largeIcon);
        item.setId(id);
        item.setVisible(!expert);
        category.getChildren().add(item);
        item.setParent((PaletteContainer)category);
        return item;
    }

    private static boolean getBooleanTagTraitValue(Entity entity, String key, boolean defaultValue) {
        Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)entity, (String)key);
        if (trait != null) {
            return TraitValueHelper.getValueAsBoolean((Trait)trait);
        }
        return defaultValue;
    }

    private static String getStringTagTraitValue(Entity entity, String key, String defaultValue) {
        Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)entity, (String)key);
        if (trait != null) {
            return TraitValueHelper.getValueAsString((Trait)trait);
        }
        return defaultValue;
    }

    private static ImageDescriptor getImageDescriptorFromTagTraitValueAsString(Entity entity, String key, ImageDescriptor defaultValue) {
        Trait t = TaglibDomainMetaDataQueryHelper.getTrait((Entity)entity, (String)key);
        if (t != null) {
            String imgDesc = TraitValueHelper.getValueAsString((Trait)t);
            return PaletteHelper.getImageDescriptorFromString(t.getSourceModelProvider(), imgDesc, defaultValue);
        }
        return defaultValue;
    }

    private static ImageDescriptor getImageDescriptorFromString(IMetaDataSourceModelProvider sourceModelProvider, String imgDesc, ImageDescriptor defaultValue) {
        ImageDescriptor image = defaultValue;
        IImageDescriptorProvider imageProvider = (IImageDescriptorProvider)sourceModelProvider.getAdapter(IImageDescriptorProvider.class);
        if (imageProvider != null) {
            image = imageProvider.getImageDescriptor(imgDesc);
        }
        return image;
    }

    private static void createTagEntry(TaglibPaletteDrawer category, CMElementDeclaration eledecl) {
        String tagName = eledecl.getElementName();
        String label = null;
        String desc = null;
        if (eledecl instanceof TLDElementDeclaration) {
            TLDElementDeclaration tag = (TLDElementDeclaration)eledecl;
            label = tag.getDisplayName();
            desc = tag.getDescription();
        }
        if (label == null || label.equals("")) {
            label = tagName;
        }
        desc = desc == null ? "" : PaletteHelper.formatDescription(desc);
        TagToolPaletteEntry item = PaletteHelper.internalCreateTagEntry(category, tagName, tagName, label, desc, PaletteHelper.getDefaultSmallIcon(), PaletteHelper.getDefaultLargeIcon(), false);
        item.setToolProperty("CMElementDeclaration", eledecl);
    }

    private static ImageDescriptor getDefaultLargeIcon() {
        return DEFAULT_LARGE_ICON;
    }

    private static ImageDescriptor getDefaultSmallIcon() {
        return DEFAULT_SMALL_ICON;
    }

    private static String formatDescription(String desc) {
        String aDesc = PaletteHelper.filterConvertString(desc);
        if (aDesc != null) {
            if (aDesc.length() > 250) {
                StringBuffer result = new StringBuffer(aDesc.substring(0, 250));
                result.append("...");
                return result.toString();
            }
            return aDesc;
        }
        return "";
    }

    private static String filterConvertString(String text) {
        if (text == null) {
            return "";
        }
        String result = removeHTMLTags.matcher(text).replaceAll("");
        result = removeNewLines.matcher(result).replaceAll(" ");
        result = trimInteriorWhitespace.matcher(result).replaceAll(" ");
        return result;
    }
}

