/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.elementedit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.pagedesigner.elementedit.ElementEditFacRegistryReader;
import org.eclipse.jst.pagedesigner.elementedit.IElementEdit;
import org.eclipse.jst.pagedesigner.elementedit.IElementEditFactory;
import org.eclipse.jst.pagedesigner.elementedit.html.HTMLElementEditFactory;
import org.eclipse.jst.pagedesigner.elementedit.jsp.JSPElementEditFactory;
import org.w3c.dom.Element;

public class ElementEditFactoryRegistry {
    List _factories = new ArrayList();
    private static ElementEditFactoryRegistry _instance;

    private ElementEditFactoryRegistry() {
        this.addFactory(new HTMLElementEditFactory());
        this.addFactory(new JSPElementEditFactory());
        List<IElementEditFactory> facs = ElementEditFacRegistryReader.getAllHandlers();
        if (facs != null) {
            for (IElementEditFactory fac : facs) {
                this.addFactory(fac);
            }
        }
    }

    public void addFactory(IElementEditFactory fac) {
        this._factories.add(fac);
    }

    public IElementEdit createElementEdit(TagIdentifier tagIdentifier) {
        IElementEdit elementEdit;
        String facuri;
        IElementEditFactory fac;
        String uri = tagIdentifier.getUri();
        int i = 0;
        int size = this._factories.size();
        while (i < size) {
            fac = (IElementEditFactory)this._factories.get(i);
            facuri = fac.getSupportedURI();
            if (facuri != null && facuri.equals(uri) && (elementEdit = fac.createElementEdit(tagIdentifier)) != null) {
                return elementEdit;
            }
            ++i;
        }
        i = 0;
        size = this._factories.size();
        while (i < size) {
            fac = (IElementEditFactory)this._factories.get(i);
            facuri = fac.getSupportedURI();
            if (facuri == null && (elementEdit = fac.createElementEdit(tagIdentifier)) != null) {
                return elementEdit;
            }
            ++i;
        }
        return null;
    }

    public IElementEdit createElementEdit(Element ele) {
        TagIdentifier tagIdentifier = TagIdentifierFactory.createDocumentTagWrapper((Element)ele);
        return this.createElementEdit(tagIdentifier);
    }

    public static ElementEditFactoryRegistry getInstance() {
        if (_instance == null) {
            _instance = new ElementEditFactoryRegistry();
        }
        return _instance;
    }
}

