/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.internal.metadata;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.common.metadata.internal.AbstractMetaDataLocator;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataLocator;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.meta.ICMRegistry;
import org.eclipse.jst.pagedesigner.meta.internal.SimpleCMRegistry;
import org.osgi.framework.Bundle;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SybaseCMConfigMetaDataLocator
extends AbstractMetaDataLocator {
    public List locateMetaDataModelProviders(String uri) {
        List<ICMRegistry> registries = this.findCMRegistries(uri);
        if (!registries.isEmpty()) {
            ArrayList<IMetaDataSourceModelProvider> providers = new ArrayList<IMetaDataSourceModelProvider>(registries.size());
            for (ICMRegistry reg : registries) {
                if (!reg.getSupportedURI().equals(uri)) continue;
                providers.add(this.createMetaDataSourceProvider(reg));
            }
            return providers;
        }
        return null;
    }

    private List<ICMRegistry> findCMRegistries(String uri) {
        ArrayList<ICMRegistry> contributedRegistries = new ArrayList<ICMRegistry>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PDPlugin.getPluginId(), "cmRegistry");
        IConfigurationElement[] eles = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < eles.length) {
            String cmUri;
            if (eles[i].getName().equals("registry") && (cmUri = eles[i].getAttribute("uri")) != null && cmUri.equals(uri)) {
                String className;
                String configFile = eles[i].getAttribute("configFile");
                if (configFile != null && configFile.length() > 0) {
                    String bundleName = eles[i].getDeclaringExtension().getContributor().getName();
                    try {
                        Bundle bundle = Platform.getBundle((String)bundleName);
                        URL cmFileUrl = bundle.getEntry(configFile);
                        SimpleCMRegistry reg = new SimpleCMRegistry(uri, cmFileUrl);
                        contributedRegistries.add(reg);
                    }
                    catch (ParserConfigurationException e) {
                        PDPlugin.getLogger(((Object)((Object)this)).getClass()).error(new Throwable(e));
                    }
                    catch (FactoryConfigurationError e) {
                        PDPlugin.getLogger(((Object)((Object)this)).getClass()).error(new Throwable(e));
                    }
                    catch (SAXException e) {
                        PDPlugin.getLogger(((Object)((Object)this)).getClass()).error(new Throwable(e));
                    }
                    catch (IOException e) {
                        PDPlugin.getLogger(((Object)((Object)this)).getClass()).error(new Throwable(e));
                    }
                }
                if ((className = eles[i].getAttribute("class")) != null && className.length() > 0) {
                    try {
                        Object obj = eles[i].createExecutableExtension("class");
                        if (obj instanceof ICMRegistry) {
                            contributedRegistries.add((ICMRegistry)obj);
                        }
                    }
                    catch (CoreException e) {
                        PDPlugin.getLogger(((Object)((Object)this)).getClass()).error(new Throwable(e));
                    }
                }
            }
            ++i;
        }
        return contributedRegistries;
    }

    private IMetaDataSourceModelProvider createMetaDataSourceProvider(ICMRegistry reg) {
        SybaseCMConfigMetadataProvider provider = new SybaseCMConfigMetadataProvider(reg);
        provider.setLocator((IMetaDataLocator)this);
        return provider;
    }

    public void startLocating() {
    }

    public void stopLocating() {
    }

    public class SybaseCMConfigMetadataProvider
    implements IMetaDataSourceModelProvider {
        private IMetaDataLocator _locator;
        private ICMRegistry _reg;

        public SybaseCMConfigMetadataProvider(ICMRegistry reg) {
            this._reg = reg;
        }

        public Object getSourceModel() {
            return this._reg;
        }

        public IMetaDataLocator getLocator() {
            return this._locator;
        }

        public void setLocator(IMetaDataLocator locator) {
            this._locator = locator;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }
}

