/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.internal.metadata;

import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xml.type.SimpleAnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.MetadataFactory;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelMergeAssistant;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataTranslator;
import org.eclipse.jst.jsf.common.metadata.traittypes.traittypes.ListOfValues;
import org.eclipse.jst.jsf.common.metadata.traittypes.traittypes.TraitTypesFactory;
import org.eclipse.jst.pagedesigner.meta.IAttributeDescriptor;
import org.eclipse.jst.pagedesigner.meta.IElementDescriptor;
import org.eclipse.jst.pagedesigner.meta.internal.SimpleCMRegistry;

public class SybaseCMConfigMetaDataTranslator
implements IMetaDataTranslator {
    private static final String ATTR_VAL_RUNTIME_TYPE = "attribute-value-runtime-type";
    private IMetaDataModelMergeAssistant _assistant;

    public boolean canTranslate(IMetaDataSourceModelProvider modelProvider) {
        return modelProvider.getSourceModel() != null && modelProvider.getSourceModel() instanceof SimpleCMRegistry;
    }

    public void translate(IMetaDataModelMergeAssistant assistant) {
        this._assistant = assistant;
        SimpleCMRegistry reg = (SimpleCMRegistry)assistant.getSourceModelProvider().getSourceModel();
        this.traverseCMRegistryModel(reg);
    }

    private void traverseCMRegistryModel(SimpleCMRegistry reg) {
        for (Map.Entry entry : reg.getMap().entrySet()) {
            IElementDescriptor tagElem = (IElementDescriptor)entry.getValue();
            this.findOrCreateTag(tagElem);
        }
    }

    private void findOrCreateTag(IElementDescriptor tagElem) {
        Entity tag = this._assistant.getMergedEntity((Entity)this.getMergedModel(), tagElem.getTagName());
        if (tag == null) {
            tag = this.internalCreateTagEntity(tagElem);
            this.getMergedModel().getChildEntities().add((Object)tag);
        }
        this.createTagTraits(tag, tagElem);
        this.createAttributeEntities(tag, tagElem);
    }

    private void createAttributeEntities(Entity tag, IElementDescriptor tagElem) {
        IAttributeDescriptor[] iAttributeDescriptorArray = tagElem.getAttributeDescriptors();
        int n = iAttributeDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttributeDescriptor attrDesc = iAttributeDescriptorArray[n2];
            Entity attr = this._assistant.getMergedEntity(tag, attrDesc.getAttributeName());
            if (attr == null) {
                attr = this.internalCreateAttributeEntity(attrDesc);
                tag.getChildEntities().add((Object)attr);
            }
            this.createAttributeTraits(attr, attrDesc);
            ++n2;
        }
        if (tagElem.getReference() != null) {
            this.createAttributeEntities(tag, tagElem.getReference());
        }
    }

    private void createAttributeTraits(Entity attr, IAttributeDescriptor attrDesc) {
        this.convertValueType(attr, attrDesc);
        this.createTraitAndSimpleAnyTypeValue(attr, "display-label", attrDesc.getLabelString());
        this.createTraitAndSimpleAnyTypeValue(attr, "description", attrDesc.getDescription());
        this.createTraitAndSimpleAnyTypeValue(attr, "default-value", attrDesc.getDefaultValue());
        this.createTraitAndSimpleAnyTypeValue(attr, "category", attrDesc.getCategory());
        this.createTraitAndSimpleAnyTypeValue(attr, "required", String.valueOf(attrDesc.isRequired()));
    }

    private void createTraitAndSimpleAnyTypeValue(Entity attr, String traitKey, String traitValue) {
        if (traitValue != null && traitValue.trim().length() > 0) {
            Trait trait = this.createTrait(attr, traitKey);
            this.setTraitValueUsingSimpleAnyType(trait, traitValue);
            attr.getTraits().add((Object)trait);
        }
    }

    private void convertValueType(Entity attr, IAttributeDescriptor attrDesc) {
        if (this.hasTrait(attr, ATTR_VAL_RUNTIME_TYPE)) {
            return;
        }
        String rtType = null;
        String valType = attrDesc.getValueType();
        Trait trait = this.createTrait(attr, ATTR_VAL_RUNTIME_TYPE);
        if ("ENUMERATED".equals(valType)) {
            if ("lang".equalsIgnoreCase(attrDesc.getAttributeName())) {
                rtType = "org.eclipse.jst.jsf.core.attributevalues.LanguageCodeType";
            } else {
                rtType = "org.eclipse.jst.jsf.core.attributevalues.StringType";
                this.createPossibleValuesAndValidValueTraits(attr, attrDesc);
            }
        } else if ("BOOLEAN".equals(valType)) {
            rtType = "org.eclipse.jst.jsf.core.attributevalues.BooleanType";
        } else if ("CLASSNAME".equals(valType)) {
            rtType = "org.eclipse.jst.jsf.core.attributevalues.JavaClassType";
            int colonIndex = attrDesc.getTypeParameter().lastIndexOf(":");
            String superTypeValue = attrDesc.getTypeParameter().substring(colonIndex + 1);
            String superTypeType = attrDesc.getTypeParameter().substring(colonIndex - 1, colonIndex);
            if (superTypeType.equalsIgnoreCase("I")) {
                this.createTraitAndSimpleAnyTypeValue(attr, "valid-interfaces", superTypeValue);
            } else {
                this.createTraitAndSimpleAnyTypeValue(attr, "valid-superclass", superTypeValue);
            }
        } else if ("CLASSPATH_RESOURCE".equals(valType)) {
            rtType = "org.eclipse.jst.jsf.core.attributevalues.ResourceBundleType";
        } else if ("COLOR".equals(valType)) {
            rtType = "org.eclipse.jst.jsf.core.attributevalues.ColorType";
        } else if ("CSSCLASS".equals(valType)) {
            rtType = "org.eclipse.jst.pagedesigner.attributevalues.CSSClassType";
        } else if ("CSSID".equals(valType)) {
            rtType = "org.eclipse.jst.pagedesigner.attributevalues.CSSIdType";
        } else if ("CSSSTYLE".equals(valType)) {
            rtType = "org.eclipse.jst.pagedesigner.attributevalues.CSSStyleType";
        } else if ("CURRENCYCODE".equals(valType)) {
            rtType = "org.eclipse.jst.jsf.core.attributevalues.CurrencyCodeType";
        } else if ("JAVASCRIPT".equals(valType)) {
            rtType = "org.eclipse.jst.jsf.core.attributevalues.ScriptType";
        } else if ("LINK".equals(valType)) {
            rtType = "org.eclipse.jst.jsf.core.attributevalues.LinkType";
        } else if ("LOCALE".equals(valType)) {
            rtType = "org.eclipse.jst.jsf.core.attributevalues.LocaleType";
        } else if ("METHODBINDING".equals(valType)) {
            Trait t;
            rtType = "org.eclipse.jst.jsf.core.attributevalues.MethodBindingType";
            if (attr.getId().equals("validator")) {
                this.createValidatorParams(attr);
            } else if (attr.getId().equals("actionListener")) {
                t = this.createTrait(attr, "runtime-param-types");
                t.setValue((EObject)this.createAndSetSimpleAnyTypeValue("javax.faces.event.ActionEvent"));
                attr.getTraits().add((Object)t);
            } else if (attr.getId().equals("valueChangeListener")) {
                t = this.createTrait(attr, "runtime-param-types");
                t.setValue((EObject)this.createAndSetSimpleAnyTypeValue("javax.faces.event.ValueChangeEvent"));
                attr.getTraits().add((Object)t);
            }
            Trait t2 = this.createTrait(attr, "runtime-return-type");
            t2.setValue((EObject)this.createAndSetSimpleAnyTypeValue("void"));
            attr.getTraits().add((Object)t2);
        } else {
            rtType = "MULTICHOICE".equals(valType) ? "org.eclipse.jst.jsf.core.attributevalues.StringType" : ("NAMED-BOOLEAN".equals(valType) ? "org.eclipse.jst.jsf.core.attributevalues.BooleanType" : ("PROPERTYBINDING".equals(valType) ? "org.eclipse.jst.jsf.core.attributevalues.ValueBindingType" : ("RELATIVEPATH".equals(valType) ? "org.eclipse.jst.jsf.core.attributevalues.RelativePathType" : ("TIMEZONE".equals(valType) ? "org.eclipse.jst.jsf.core.attributevalues.TimeZoneType" : ("WEBPATH".equals(valType) ? "org.eclipse.jst.jsf.core.attributevalues.WebPathType" : "org.eclipse.jst.jsf.core.attributevalues.StringType")))));
        }
        this.setTraitValueUsingSimpleAnyType(trait, rtType.toString());
        this.setTypeParamsIfAny(attr, attrDesc);
        attr.getTraits().add((Object)trait);
    }

    private void setTypeParamsIfAny(Entity attr, IAttributeDescriptor attrDesc) {
        if (attrDesc.getTypeParameter() != null) {
            String typeParam = attrDesc.getTypeParameter();
            if (typeParam.indexOf("suffix") > -1) {
                int i = typeParam.indexOf("suffix");
                String suffixes = typeParam.substring(i + "suffix".length() + 1);
                Trait trait = this.createTrait(attr, "file-extensions");
                StringTokenizer st = new StringTokenizer(suffixes, ";");
                ListOfValues exts = TraitTypesFactory.eINSTANCE.createListOfValues();
                while (st.hasMoreElements()) {
                    String ext = st.nextToken();
                    exts.getEntries().add((Object)this.createAndSetSimpleAnyTypeValue(ext));
                }
                trait.setValue((EObject)exts);
                attr.getTraits().add((Object)trait);
            } else if (typeParam.indexOf("default") > -1) {
                int i = typeParam.indexOf("default");
                String defaultVal = typeParam.substring(i + "default".length() + 1);
                this.createTraitAndSimpleAnyTypeValue(attr, "default-value", defaultVal);
            } else if (typeParam.indexOf("separator") > -1) {
                int i = typeParam.indexOf("separator");
                String sep = typeParam.substring(i + "separator".length() + 1);
                this.createTraitAndSimpleAnyTypeValue(attr, "multi-choice-seperator", sep);
            } else if (typeParam.indexOf("style") > -1) {
                int i = typeParam.indexOf("style");
                String style = typeParam.substring(i + "style".length() + 1);
                this.createTraitAndSimpleAnyTypeValue(attr, "style", style);
            } else if (typeParam.indexOf("superType") <= -1 && typeParam.length() > 0) {
                System.out.println(typeParam);
            }
        }
    }

    private void createValidatorParams(Entity attr) {
        Trait t = this.createTrait(attr, "runtime-param-types");
        ListOfValues list = TraitTypesFactory.eINSTANCE.createListOfValues();
        list.getEntries().add((Object)this.createAndSetSimpleAnyTypeValue("javax.faces.context.FacesContext"));
        list.getEntries().add((Object)this.createAndSetSimpleAnyTypeValue("javax.faces.component.UIComponent"));
        list.getEntries().add((Object)this.createAndSetSimpleAnyTypeValue("java.lang.Object"));
        t.setValue((EObject)list);
        attr.getTraits().add((Object)t);
    }

    private SimpleAnyType createAndSetSimpleAnyTypeValue(String rawVal) {
        SimpleAnyType item = XMLTypeFactory.eINSTANCE.createSimpleAnyType();
        item.setRawValue(rawVal);
        return item;
    }

    private void createPossibleValuesAndValidValueTraits(Entity attr, IAttributeDescriptor attrDesc) {
        if (attrDesc.getOptions() != null) {
            Trait validVals = MetadataFactory.eINSTANCE.createTrait();
            validVals.setId("valid-values");
            validVals.setSourceModelProvider(this._assistant.getSourceModelProvider());
            Trait displayVals = MetadataFactory.eINSTANCE.createTrait();
            displayVals.setId("displayed-values");
            displayVals.setSourceModelProvider(this._assistant.getSourceModelProvider());
            Map options = attrDesc.getOptions();
            ListOfValues validVs = TraitTypesFactory.eINSTANCE.createListOfValues();
            ListOfValues displayVs = TraitTypesFactory.eINSTANCE.createListOfValues();
            for (Map.Entry entry : options.entrySet()) {
                validVs.getEntries().add((Object)this.createAndSetSimpleAnyTypeValue((String)entry.getKey()));
                displayVs.getEntries().add((Object)this.createAndSetSimpleAnyTypeValue((String)entry.getValue()));
            }
            if (validVs.getEntries().size() > 0) {
                validVals.setValue((EObject)validVs);
                displayVals.setValue((EObject)displayVs);
                attr.getTraits().add((Object)validVals);
                attr.getTraits().add((Object)displayVals);
            }
        }
    }

    private void setTraitValueUsingSimpleAnyType(Trait trait, String type) {
        SimpleAnyType value = XMLTypeFactory.eINSTANCE.createSimpleAnyType();
        value.setRawValue(type);
        trait.setValue((EObject)value);
    }

    private Trait createTrait(Entity entity, String id) {
        Trait trait = MetadataFactory.eINSTANCE.createTrait();
        trait.setId(id);
        trait.setSourceModelProvider(this._assistant.getSourceModelProvider());
        return trait;
    }

    private boolean hasTrait(Entity attr, String traitKey) {
        return false;
    }

    private void createTagTraits(Entity tag, IElementDescriptor tagElem) {
        if (tagElem.getHelpContextID() != null) {
            tagElem.getHelpContextID().equals("");
        }
    }

    private Entity internalCreateTagEntity(IElementDescriptor tagElem) {
        Entity tag = MetadataFactory.eINSTANCE.createEntity();
        tag.setId(tagElem.getTagName());
        return tag;
    }

    private Entity internalCreateAttributeEntity(IAttributeDescriptor attrDesc) {
        Entity attr = MetadataFactory.eINSTANCE.createEntity();
        attr.setId(attrDesc.getAttributeName());
        return attr;
    }

    private Model getMergedModel() {
        if ((Model)this._assistant.getMergedModel().getRoot() != null) {
            return (Model)this._assistant.getMergedModel().getRoot();
        }
        Model model = MetadataFactory.eINSTANCE.createModel();
        model.setId(this._assistant.getMergedModel().getModelKey().getUri());
        model.setSourceModelProvider(this._assistant.getSourceModelProvider());
        this._assistant.getMergedModel().setRoot((Object)model);
        return model;
    }
}

