/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties.internal;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.pagedesigner.editors.properties.quickedittabsections.QuickEditTabSections;
import org.eclipse.jst.pagedesigner.editors.properties.quickedittabsections.SECTION_TYPE;
import org.eclipse.jst.pagedesigner.editors.properties.quickedittabsections.SectionInfo;
import org.eclipse.jst.pagedesigner.properties.internal.QuickEditAttributeGroupSection;
import org.eclipse.jst.pagedesigner.properties.internal.QuickEditTabSectionDescriptor;
import org.eclipse.jst.pagedesigner.properties.internal.WPETabPropertySectionDescriptorProvider;
import org.eclipse.ui.views.properties.tabbed.ISection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickEditTabSectionsDescriptor {
    private QuickEditTabSections _sections;
    private QName _tagId;
    private List<ISection> _sectionClasses;
    private Entity _tagEntity;
    private WPETabPropertySectionDescriptorProvider sectionProvider;

    public QuickEditTabSectionsDescriptor(Entity tagEntity, QName tagId, QuickEditTabSections sections) {
        this._tagEntity = tagEntity;
        this._tagId = tagId;
        this._sections = sections;
    }

    QuickEditTabSectionsDescriptor() {
        this._tagEntity = null;
        this._tagId = null;
        this._sections = null;
    }

    public void calculateSections() {
        if (this._sectionClasses == null || this._sectionClasses.isEmpty()) {
            this._sectionClasses = new ArrayList<ISection>();
            ArrayList<String> attrIds = new ArrayList<String>();
            for (SectionInfo secInfo : this._sections.getSections()) {
                if (secInfo.getType() == SECTION_TYPE.ATTRIBUTE) {
                    if (secInfo.getId() == null) continue;
                    attrIds.add(secInfo.getId());
                    continue;
                }
                if (secInfo.getType() != SECTION_TYPE.SECTION) continue;
                if (attrIds.size() > 0) {
                    this.createAttributeGroup(attrIds);
                    attrIds = new ArrayList();
                }
                this.createSectionGroup(secInfo);
            }
            if (attrIds.size() > 0) {
                this.createAttributeGroup(attrIds);
            }
        }
    }

    private void createSectionGroup(SectionInfo secInfo) {
        ISection section;
        QuickEditTabSectionDescriptor sd = this.getSectionProvider().getNamedSectionDescriptor(secInfo.getId());
        if (sd != null && (section = sd.getSectionClass(this._tagEntity)) != null) {
            this._sectionClasses.add(section);
        }
    }

    private void createAttributeGroup(List<String> attrNames) {
        QuickEditAttributeGroupSection section = new QuickEditAttributeGroupSection(this._tagEntity, attrNames);
        if (section != null) {
            this._sectionClasses.add((ISection)section);
        }
    }

    public QName getTagId() {
        return this._tagId;
    }

    public List<ISection> getSections() {
        return this._sectionClasses;
    }

    private WPETabPropertySectionDescriptorProvider getSectionProvider() {
        if (this.sectionProvider == null) {
            this.sectionProvider = new WPETabPropertySectionDescriptorProvider();
        }
        return this.sectionProvider;
    }
}

