/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties.internal;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.pagedesigner.properties.internal.QuickEditTabSectionsDescriptor;

public class QuickEditTabSectionsManager {
    private static QuickEditTabSectionsManagerMgr _mgrInstance = new QuickEditTabSectionsManagerMgr();
    private Map<QName, QuickEditTabSectionsDescriptor> map = new HashMap<QName, QuickEditTabSectionsDescriptor>(5);
    private IProject _project;
    private int clientCount = 0;

    public static QuickEditTabSectionsManager acquireInstance(IProject project) {
        QuickEditTabSectionsManager instance = _mgrInstance.getSectionsManager(project);
        ++instance.clientCount;
        instance._project = project;
        return instance;
    }

    public void releaseInstance() {
        int refCount;
        if ((refCount = --this.clientCount) == 0) {
            _mgrInstance.removeSectionsManager(this._project);
        }
    }

    private QuickEditTabSectionsManager() {
    }

    public IProject getProject() {
        return this._project;
    }

    public QuickEditTabSectionsDescriptor getQuickEditTabSectionsFor(QName tagId) {
        return this.map.get(tagId);
    }

    public void addQuickEditTabGroupDescriptor(QuickEditTabSectionsDescriptor group) {
        this.map.put(group.getTagId(), group);
    }

    public void removeQuickEditTabGroup(QName tagId) {
        QuickEditTabSectionsDescriptor grp = this.map.get(tagId);
        if (grp != null) {
            this.map.remove(tagId);
        }
    }

    public void dispose() {
        this.map.clear();
        this.map = null;
    }

    /* synthetic */ QuickEditTabSectionsManager(QuickEditTabSectionsManager quickEditTabSectionsManager) {
        this();
    }

    private static class QuickEditTabSectionsManagerMgr {
        private Map<IProject, QuickEditTabSectionsManager> _map = new HashMap<IProject, QuickEditTabSectionsManager>();

        private QuickEditTabSectionsManagerMgr() {
        }

        public QuickEditTabSectionsManager getSectionsManager(IProject project) {
            if (this._map.containsKey(project)) {
                return this._map.get(project);
            }
            QuickEditTabSectionsManager instance = new QuickEditTabSectionsManager(null);
            this._map.put(project, instance);
            return instance;
        }

        public void removeSectionsManager(IProject project) {
            if (this._map.containsKey(project)) {
                this._map.remove(project);
            }
        }
    }
}

