/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.tools;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.TargetingTool;
import org.eclipse.jst.pagedesigner.parts.NodeEditPart;
import org.eclipse.jst.pagedesigner.parts.TextEditPart;
import org.eclipse.jst.pagedesigner.range.RangeUtil;
import org.eclipse.jst.pagedesigner.tools.ExposeHelper;
import org.eclipse.jst.pagedesigner.validation.caret.ActionData;
import org.eclipse.jst.pagedesigner.validation.caret.InlineEditingPositionMediator;
import org.eclipse.jst.pagedesigner.validation.caret.Target;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.jst.pagedesigner.viewer.EditPartPositionHelper;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.swt.graphics.Cursor;

public class RangeDragTracker
extends TargetingTool
implements DragTracker {
    private static final int FLAG_SELECTION_PERFORMED = 64;
    private EditPart editpart;

    public RangeDragTracker(EditPart owner) {
        this.setSourceEditPart(owner);
    }

    protected Cursor calculateCursor() {
        return Cursors.IBEAM;
    }

    protected String getCommandName() {
        return "Range Drag Tracker";
    }

    protected String getDebugName() {
        return "Range Drag Tracker";
    }

    protected EditPart getSourceEditPart() {
        return this.editpart;
    }

    protected boolean handleButtonDown(int button) {
        DesignRange range;
        EditPart sourcePart;
        IHTMLGraphicalViewer viewer;
        if (button == 3 && this.isInState(1) && (viewer = (IHTMLGraphicalViewer)(sourcePart = this.getSourceEditPart()).getViewer()) != null && viewer.isInRangeMode() && (range = viewer.getRangeSelection()) != null && range.isValid() && RangeUtil.intersect(range, sourcePart)) {
            return true;
        }
        if ((button == 1 || button == 3) && this.isInState(1)) {
            this.peroformSelectionBegin();
        }
        if (button != 1) {
            this.setState(8);
            if (button == 3) {
                this.setState(0x40000000);
            }
            this.handleInvalidInput();
        } else {
            this.stateTransition(1, 2);
        }
        return true;
    }

    protected void peroformSelectionBegin() {
        if (this.getCurrentInput().isShiftKeyDown()) {
            this.getHTMLGraphicalViewer().ensureRangeSelectionMode();
            this.rangeSelection(true);
        } else if (this.shouldStartRangeSelection()) {
            this.rangeSelection(false);
        } else {
            this.getCurrentViewer().select(this.getSourceEditPart());
        }
    }

    protected boolean handleButtonUp(int button) {
        if (this.isInState(2)) {
            this.setState(0x40000000);
            return true;
        }
        return false;
    }

    protected boolean handleDoubleClick(int button) {
        if (button == 1) {
            this.performOpen();
        }
        return true;
    }

    protected boolean handleDragStarted() {
        return this.stateTransition(2, 4);
    }

    protected boolean handleDragInProgress() {
        if (this.getHTMLGraphicalViewer().isInRangeMode()) {
            this.rangeSelection(true);
            return true;
        }
        return super.handleDragInProgress();
    }

    protected boolean hasSelectionOccurred() {
        return this.getFlag(64);
    }

    protected void performOpen() {
        SelectionRequest request = new SelectionRequest();
        request.setLocation(this.getLocation());
        request.setType((Object)"open");
        this.getSourceEditPart().performRequest((Request)request);
    }

    protected void resetFlags() {
        super.resetFlags();
        this.setFlag(64, false);
    }

    protected void setSourceEditPart(EditPart part) {
        this.editpart = part;
    }

    public IHTMLGraphicalViewer getHTMLGraphicalViewer() {
        return (IHTMLGraphicalViewer)this.getCurrentViewer();
    }

    private boolean shouldStartRangeSelection() {
        InlineEditingPositionMediator positionMediator = new InlineEditingPositionMediator(new ActionData(5, null));
        if (positionMediator.isEditable(new Target(this.getSourceEditPart()))) {
            return this.getSourceEditPart() instanceof TextEditPart || !((NodeEditPart)this.getSourceEditPart()).isWidget();
        }
        return false;
    }

    private void rangeSelection(boolean b) {
        EditPart editPart = this.getCurrentViewer().findObjectAtExcluding(this.getLocation(), (Collection)Collections.EMPTY_LIST);
        InlineEditingPositionMediator positionMediator = new InlineEditingPositionMediator(new ActionData(5, null));
        ExposeHelper exposeHelper = new ExposeHelper(this.getHTMLGraphicalViewer());
        exposeHelper.adjustVertical(this.getCurrentInput().getMouseLocation());
        DesignPosition position = EditPartPositionHelper.findEditPartPosition(editPart, this.getCurrentInput().getMouseLocation(), positionMediator);
        if (b) {
            this.getHTMLGraphicalViewer().setRangeEndPosition(position);
        } else {
            this.getHTMLGraphicalViewer().setRange(position, position);
        }
        this.getHTMLGraphicalViewer().updateHorizontalPos();
    }

    protected boolean handleHover() {
        boolean retValue = super.handleHover();
        this.refreshCursor();
        return retValue;
    }
}

