/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.utils;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;

public class ImageResolver {
    static String getResolvedURL(Element element, String attrName) {
        URIResolver resolver = null;
        if (element instanceof IDOMNode) {
            resolver = ((IDOMNode)element).getModel().getResolver();
        }
        if (resolver == null) {
            return null;
        }
        String src = DOMUtil.getAttributeIgnoreCase(element, attrName);
        if (src != null && src.length() > 0) {
            return resolver.getLocationByURI(src);
        }
        return null;
    }

    public static Image initializeImage(Element element, String attrName) {
        String url = ImageResolver.getResolvedURL(element, attrName);
        if (url == null) {
            return null;
        }
        Image img = null;
        int colonIndex = url.indexOf(":");
        int slashIndex = url.indexOf("/");
        if (colonIndex != -1 && slashIndex != -1 && colonIndex < slashIndex) {
            try {
                URL urlObj = new URL(url);
                ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)urlObj);
                img = imgDesc.createImage(false);
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    img = new Image(null, url);
                }
                catch (SWTException sWTException) {
                }
            }
            catch (SWTException sWTException) {}
        } else {
            try {
                img = new Image(null, url);
            }
            catch (SWTException sWTException) {}
        }
        return img;
    }
}

