/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.IRuntimeLocator;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;
import org.eclipse.wst.server.ui.internal.DeleteRuntimeDialog;
import org.eclipse.wst.server.ui.internal.EclipseUtil;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.viewers.RuntimeComposite;
import org.eclipse.wst.server.ui.internal.wizard.ClosableWizardDialog;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.WizardTaskUtil;
import org.eclipse.wst.server.ui.internal.wizard.fragment.NewRuntimeWizardFragment;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class RuntimePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected Button edit;
    protected Button remove;
    protected Label pathLabel;

    public RuntimePreferencePage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.wst.server.ui.spge0000");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(272);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 64);
        data = new GridData(256);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(Messages.preferenceRuntimesDescription);
        label = new Label(composite, 64);
        data = new GridData(256);
        data.horizontalSpan = 2;
        data.verticalIndent = 5;
        label.setLayoutData((Object)data);
        label.setText(Messages.preferenceRuntimesTable);
        final RuntimeComposite runtimeComp = new RuntimeComposite(composite, 0, new RuntimeComposite.RuntimeSelectionListener(){

            public void runtimeSelected(IRuntime runtime) {
                if (runtime == null) {
                    RuntimePreferencePage.this.edit.setEnabled(false);
                    RuntimePreferencePage.this.remove.setEnabled(false);
                    RuntimePreferencePage.this.pathLabel.setText("");
                } else if (runtime.isReadOnly()) {
                    RuntimePreferencePage.this.edit.setEnabled(false);
                    RuntimePreferencePage.this.remove.setEnabled(false);
                    RuntimePreferencePage.this.pathLabel.setText("" + runtime.getLocation());
                } else {
                    RuntimePreferencePage.this.edit.setEnabled(true);
                    RuntimePreferencePage.this.remove.setEnabled(true);
                    RuntimePreferencePage.this.pathLabel.setText("" + runtime.getLocation());
                }
            }
        });
        runtimeComp.setLayoutData(new GridData(1808));
        Composite buttonComp = new Composite(composite, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        buttonComp.setLayout((Layout)layout);
        data = new GridData(272);
        buttonComp.setLayoutData((Object)data);
        Button add = SWTUtil.createButton(buttonComp, Messages.add);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RuntimePreferencePage.this.showWizard(null) == 1) {
                    return;
                }
                runtimeComp.refresh();
            }
        });
        this.edit = SWTUtil.createButton(buttonComp, Messages.edit);
        this.edit.setEnabled(false);
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IRuntimeWorkingCopy runtimeWorkingCopy;
                IRuntime runtime = runtimeComp.getSelectedRuntime();
                if (runtime != null && RuntimePreferencePage.this.showWizard(runtimeWorkingCopy = runtime.createWorkingCopy()) != 1) {
                    try {
                        runtimeComp.refresh(runtime);
                    }
                    catch (Exception exception) {}
                }
            }
        });
        this.remove = SWTUtil.createButton(buttonComp, Messages.remove);
        this.remove.setEnabled(false);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IRuntime runtime = runtimeComp.getSelectedRuntime();
                if (RuntimePreferencePage.this.removeRuntime(runtime)) {
                    runtimeComp.remove(runtime);
                }
            }
        });
        Button search = SWTUtil.createButton(buttonComp, Messages.search);
        data = (GridData)search.getLayoutData();
        data.verticalIndent = 9;
        search.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    DirectoryDialog directoryDialog = new DirectoryDialog(RuntimePreferencePage.this.getShell());
                    directoryDialog.setMessage(Messages.dialogRuntimeSearchMessage);
                    directoryDialog.setText(Messages.dialogRuntimeSearchTitle);
                    String pathStr = directoryDialog.open();
                    if (pathStr == null) {
                        return;
                    }
                    Path path = new Path(pathStr);
                    final ProgressMonitorDialog dialog = new ProgressMonitorDialog(RuntimePreferencePage.this.getShell());
                    dialog.setBlockOnOpen(false);
                    dialog.setCancelable(true);
                    dialog.open();
                    final IProgressMonitor monitor = dialog.getProgressMonitor();
                    final IRuntimeLocator[] locators = ServerPlugin.getRuntimeLocators();
                    monitor.beginTask(Messages.dialogRuntimeSearchProgress, 100 * locators.length + 10);
                    final ArrayList list = new ArrayList();
                    IRuntimeLocator.IRuntimeSearchListener listener = new IRuntimeLocator.IRuntimeSearchListener(){

                        public void runtimeFound(final IRuntimeWorkingCopy runtime) {
                            dialog.getShell().getDisplay().syncExec(new Runnable(){

                                public void run() {
                                    monitor.subTask(runtime.getName());
                                }
                            });
                            list.add(runtime);
                        }
                    };
                    IRunnableWithProgress runnable = new IRunnableWithProgress((IPath)path, listener){
                        private final /* synthetic */ IPath val$path;
                        private final /* synthetic */ IRuntimeLocator.IRuntimeSearchListener val$listener;
                        {
                            this.val$path = iPath;
                            this.val$listener = iRuntimeSearchListener;
                        }

                        public void run(IProgressMonitor monitor2) {
                            int size = locators.length;
                            int i = 0;
                            while (i < size) {
                                if (!monitor2.isCanceled()) {
                                    try {
                                        locators[i].searchForRuntimes(this.val$path, this.val$listener, monitor2);
                                    }
                                    catch (CoreException ce) {
                                        Trace.trace((byte)2, "Error locating runtimes: " + locators[i].getId(), ce);
                                    }
                                }
                                ++i;
                            }
                            Trace.trace((byte)1, "Done search");
                        }
                    };
                    dialog.run(true, true, runnable);
                    Trace.trace((byte)5, "Found runtimes: " + list.size());
                    if (!monitor.isCanceled()) {
                        if (list.isEmpty()) {
                            EclipseUtil.openError(RuntimePreferencePage.this.getShell(), Messages.infoNoRuntimesFound);
                            return;
                        }
                        monitor.worked(5);
                        Trace.trace((byte)5, "Removing duplicates");
                        ArrayList<IRuntime> good = new ArrayList<IRuntime>();
                        Iterator iterator2 = list.iterator();
                        while (iterator2.hasNext()) {
                            boolean dup = false;
                            IRuntime wc = (IRuntime)iterator2.next();
                            IRuntime[] runtimes = ServerCore.getRuntimes();
                            if (runtimes != null) {
                                int size = runtimes.length;
                                int i = 0;
                                while (i < size) {
                                    if (runtimes[i].getLocation() != null && runtimes[i].getLocation().equals((Object)wc.getLocation())) {
                                        dup = true;
                                    }
                                    ++i;
                                }
                            }
                            if (dup) continue;
                            good.add(wc);
                        }
                        monitor.worked(5);
                        Trace.trace((byte)5, "Adding runtimes: " + good.size());
                        for (IRuntime wc : good) {
                            wc.save(false, monitor);
                        }
                        monitor.done();
                    }
                    dialog.close();
                }
                catch (Exception ex) {
                    Trace.trace((byte)3, "Error finding runtimes", ex);
                }
                runtimeComp.refresh();
            }
        });
        this.pathLabel = new Label(parent, 0);
        this.pathLabel.setLayoutData((Object)new GridData(768));
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected boolean removeRuntime(IRuntime runtime) {
        if (runtime == null) {
            return false;
        }
        IServer[] servers = ServerCore.getServers();
        ArrayList<IServer> list = new ArrayList<IServer>();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                if (runtime.equals(servers[i].getRuntime())) {
                    list.add(servers[i]);
                }
                ++i;
            }
        }
        boolean inUse = false;
        try {
            inUse = FacetUtil.isRuntimeTargeted((IRuntime)runtime);
        }
        catch (Throwable throwable) {}
        if (!list.isEmpty() || inUse) {
            DeleteRuntimeDialog dialog = new DeleteRuntimeDialog(this.getShell(), !list.isEmpty(), inUse);
            if (dialog.open() != 0) {
                return false;
            }
            if (dialog.isDeleteServers()) {
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    try {
                        IServer server = (IServer)iter.next();
                        server.delete();
                    }
                    catch (Exception e) {
                        Trace.trace((byte)3, "Error deleting server", e);
                    }
                }
            }
            if (dialog.isRemoveTargets()) {
                try {
                    FacetUtil.removeTargets((IRuntime)runtime, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Throwable throwable) {}
            }
        }
        try {
            runtime.delete();
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error deleting runtime", e);
        }
        return true;
    }

    protected int showWizard(IRuntimeWorkingCopy runtimeWorkingCopy) {
        String title = null;
        WizardFragment fragment = null;
        TaskModel taskModel = new TaskModel();
        if (runtimeWorkingCopy == null) {
            title = Messages.wizNewRuntimeWizardTitle;
            fragment = new WizardFragment(){

                @Override
                protected void createChildFragments(List<WizardFragment> list) {
                    list.add(new NewRuntimeWizardFragment());
                    list.add(WizardTaskUtil.SaveRuntimeFragment);
                }
            };
        } else {
            title = Messages.wizEditRuntimeWizardTitle;
            final WizardFragment fragment2 = ServerUIPlugin.getWizardFragment(runtimeWorkingCopy.getRuntimeType().getId());
            if (fragment2 == null) {
                this.edit.setEnabled(false);
                return 1;
            }
            taskModel.putObject("runtime", (Object)runtimeWorkingCopy);
            fragment = new WizardFragment(){

                @Override
                protected void createChildFragments(List<WizardFragment> list) {
                    list.add(fragment2);
                    list.add(WizardTaskUtil.SaveRuntimeFragment);
                }
            };
        }
        TaskWizard wizard = new TaskWizard(title, fragment, taskModel);
        wizard.setForcePreviousAndNextButtons(true);
        ClosableWizardDialog dialog = new ClosableWizardDialog(this.getShell(), wizard);
        return dialog.open();
    }

    protected IRuntime getSelection(ISelection sel2) {
        IStructuredSelection sel = (IStructuredSelection)sel2;
        return (IRuntime)sel.getFirstElement();
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setTitle(Messages.preferenceRuntimesTitleLong);
        }
    }
}

