/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.PublishServerJob;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;

public class PublishAction
extends AbstractServerAction {
    public PublishAction(Shell shell, ISelectionProvider selectionProvider) {
        super(shell, selectionProvider, Messages.actionPublish);
        this.setToolTipText(Messages.actionPublishToolTip);
        this.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_PUBLISH"));
        this.setHoverImageDescriptor(ImageResource.getImageDescriptor("IMG_CLCL_PUBLISH"));
        this.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_PUBLISH"));
        this.setActionDefinitionId("org.eclipse.wst.server.publish");
        try {
            this.selectionChanged((IStructuredSelection)selectionProvider.getSelection());
        }
        catch (Exception exception) {}
    }

    public boolean accept(IServer server) {
        return server.canPublish().isOK();
    }

    public void perform(IServer server) {
        PublishAction.publish(server, this.shell);
    }

    public static void publish(IServer server, Shell shell) {
        if (shell != null && !ServerUIPlugin.promptIfDirty(shell, server)) {
            return;
        }
        if (!ServerUIPlugin.saveEditors()) {
            return;
        }
        PublishServerJob publishJob = new PublishServerJob(server, 1, false);
        publishJob.setUser(true);
        publishJob.schedule();
    }
}

