/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class ServerTransfer
extends ByteArrayTransfer {
    private static final ServerTransfer instance = new ServerTransfer();
    private static final String TYPE_NAME = "server-transfer-format:" + System.currentTimeMillis() + ":" + ((Object)((Object)instance)).hashCode();
    private static final int TYPEID = ServerTransfer.registerType((String)TYPE_NAME);

    private ServerTransfer() {
    }

    public static ServerTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object data, TransferData transferData) {
        if (!(data instanceof IServer[])) {
            return;
        }
        IServer[] servers = (IServer[])data;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.writeInt(servers.length);
            int i = 0;
            while (i < servers.length) {
                dataOut.writeUTF(servers[i].getId());
                ++i;
            }
            dataOut.close();
            out.close();
            byte[] bytes = out.toByteArray();
            super.javaToNative((Object)bytes, transferData);
        }
        catch (IOException iOException) {}
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int count = in.readInt();
            IServer[] results = new IServer[count];
            int i = 0;
            while (i < count) {
                String id = in.readUTF();
                results[i] = ServerCore.findServer((String)id);
                ++i;
            }
            return results;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

