/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.PublishServerJob;
import org.eclipse.wst.server.core.internal.RestartServerJob;
import org.eclipse.wst.server.core.internal.ServerType;
import org.eclipse.wst.server.core.internal.StartServerJob;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.provisional.UIDecoratorManager;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;

public class StartAction
extends AbstractServerAction {
    protected String launchMode = "run";

    public StartAction(Shell shell, ISelectionProvider selectionProvider, String launchMode) {
        super(shell, selectionProvider, "start");
        this.launchMode = launchMode;
        if (launchMode == "run") {
            this.setToolTipText(Messages.actionStartToolTip);
            this.setText(Messages.actionStart);
            this.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_START"));
            this.setHoverImageDescriptor(ImageResource.getImageDescriptor("IMG_CLCL_START"));
            this.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_START"));
            this.setActionDefinitionId("org.eclipse.wst.server.run");
        } else if (launchMode == "debug") {
            this.setToolTipText(Messages.actionDebugToolTip);
            this.setText(Messages.actionDebug);
            this.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_START_DEBUG"));
            this.setHoverImageDescriptor(ImageResource.getImageDescriptor("IMG_CLCL_START_DEBUG"));
            this.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_START_DEBUG"));
            this.setActionDefinitionId("org.eclipse.wst.server.debug");
        } else if (launchMode == "profile") {
            this.setToolTipText(Messages.actionProfileToolTip);
            this.setText(Messages.actionProfile);
            this.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_START_PROFILE"));
            this.setHoverImageDescriptor(ImageResource.getImageDescriptor("IMG_CLCL_START_PROFILE"));
            this.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_START_PROFILE"));
        }
        try {
            this.selectionChanged((IStructuredSelection)selectionProvider.getSelection());
        }
        catch (Exception exception) {}
    }

    private void updateText(IStructuredSelection sel) {
        block10: {
            block11: {
                block9: {
                    if (this.launchMode != "run") break block9;
                    if (sel.isEmpty()) {
                        this.setText(Messages.actionStart);
                        return;
                    }
                    for (Object obj : sel) {
                        if (!(obj instanceof IServer)) continue;
                        IServer server = (IServer)obj;
                        if (server.getServerState() == 2 || server.getServerState() == 1) {
                            this.setText(Messages.actionRestart);
                            continue;
                        }
                        this.setText(Messages.actionStart);
                    }
                    break block10;
                }
                if (this.launchMode != "debug") break block11;
                if (sel.isEmpty()) {
                    this.setText(Messages.actionDebug);
                    return;
                }
                for (Object obj : sel) {
                    if (!(obj instanceof IServer)) continue;
                    IServer server = (IServer)obj;
                    if (server.getServerState() == 2 || server.getServerState() == 1) {
                        this.setText(Messages.actionDebugRestart);
                        continue;
                    }
                    this.setText(Messages.actionDebug);
                }
                break block10;
            }
            if (this.launchMode != "profile") break block10;
            if (sel.isEmpty()) {
                this.setText(Messages.actionProfile);
                return;
            }
            for (Object obj : sel) {
                if (!(obj instanceof IServer)) continue;
                IServer server = (IServer)obj;
                if (server.getServerState() == 2 || server.getServerState() == 1) {
                    this.setText(Messages.actionProfileRestart);
                    continue;
                }
                this.setText(Messages.actionProfile);
            }
        }
    }

    public boolean accept(IServer server) {
        if (server.getServerState() != 2) {
            return server.canStart(this.launchMode).isOK();
        }
        String mode2 = this.launchMode;
        if (mode2 == null) {
            mode2 = server.getMode();
        }
        return server.getServerType() != null && UIDecoratorManager.getUIDecorator(server.getServerType()).canRestart() && server.canRestart(mode2).isOK();
    }

    public void perform(IServer server) {
        StartAction.start(server, this.launchMode, this.shell);
    }

    public static void start(IServer server, String launchMode, Shell shell) {
        block11: {
            if (server.getServerState() != 2) {
                if (!ServerUIPlugin.saveEditors()) {
                    return;
                }
                if (!ServerCore.isAutoPublishing()) {
                    StartServerJob startJob = new StartServerJob(server, launchMode);
                    startJob.schedule();
                    return;
                }
                try {
                    PublishServerJob publishJob = new PublishServerJob(server, 1, false);
                    StartServerJob startJob = new StartServerJob(server, launchMode);
                    if (((ServerType)server.getServerType()).startBeforePublish()) {
                        startJob.setNextJob((Job)publishJob);
                        startJob.schedule();
                        break block11;
                    }
                    publishJob.setNextJob((Job)startJob);
                    publishJob.schedule();
                }
                catch (Exception e) {
                    Trace.trace((byte)3, "Error starting server", e);
                }
            } else {
                if (shell != null && !ServerUIPlugin.promptIfDirty(shell, server)) {
                    return;
                }
                try {
                    String launchMode2 = launchMode;
                    if (launchMode2 == null) {
                        launchMode2 = server.getMode();
                    }
                    RestartServerJob restartJob = new RestartServerJob(server, launchMode2);
                    restartJob.schedule();
                }
                catch (Exception e) {
                    Trace.trace((byte)3, "Error restarting server", e);
                }
            }
        }
    }

    public void selectionChanged(IStructuredSelection sel) {
        super.selectionChanged(sel);
        this.updateText(sel);
    }
}

