/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeComposite;
import org.eclipse.wst.server.ui.internal.viewers.ServerTreeContentProvider;
import org.eclipse.wst.server.ui.internal.viewers.ServerTreeLabelProvider;

public class ServerComposite
extends AbstractTreeComposite {
    protected IServer selection;
    protected ServerSelectionListener listener;
    protected ServerTreeContentProvider contentProvider;
    protected boolean initialSelection = true;
    protected IModule module;
    protected String launchMode;
    protected boolean includeIncompatibleVersions;

    public ServerComposite(Composite parent, ServerSelectionListener listener2, IModule module, String launchMode) {
        super(parent);
        this.module = module;
        this.launchMode = launchMode;
        this.listener = listener2;
        this.contentProvider = new ServerTreeContentProvider(module, launchMode);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        ServerTreeLabelProvider labelProvider = new ServerTreeLabelProvider();
        labelProvider.addListener(new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                Object[] obj = event.getElements();
                if (obj == null) {
                    ServerComposite.this.treeViewer.refresh(true);
                } else {
                    obj = ServerUIPlugin.adaptLabelChangeObjects(obj);
                    int size = obj.length;
                    int i = 0;
                    while (i < size) {
                        ServerComposite.this.treeViewer.refresh(obj[i], true);
                        ++i;
                    }
                }
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.setInput((Object)"root");
        this.treeViewer.expandToLevel(1);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = ServerComposite.this.getSelection(event.getSelection());
                if (obj instanceof IServer) {
                    ServerComposite.this.selection = (IServer)obj;
                    ServerComposite.this.setDescription(ServerComposite.this.selection.getServerType().getRuntimeType().getDescription());
                } else {
                    ServerComposite.this.selection = null;
                    ServerComposite.this.setDescription("");
                }
                ServerComposite.this.listener.serverSelected(ServerComposite.this.selection);
            }
        });
    }

    public ServerComposite(Composite parent, ServerSelectionListener listener2) {
        this(parent, listener2, null, null);
    }

    public void setIncludeIncompatibleVersions(boolean b) {
        this.includeIncompatibleVersions = b;
        ISelection sel = this.treeViewer.getSelection();
        this.contentProvider.setIncludeIncompatibleVersions(b);
        this.treeViewer.refresh();
        this.treeViewer.setSelection(sel, true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.initialSelection) {
            this.initialSelection = false;
            this.deferInitialization();
        }
    }

    public void refreshAll() {
        ISelection sel = this.treeViewer.getSelection();
        this.contentProvider = new ServerTreeContentProvider(this.module, this.launchMode);
        this.contentProvider.setIncludeIncompatibleVersions(this.includeIncompatibleVersions);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setSelection(sel);
    }

    protected String getDescriptionLabel() {
        return null;
    }

    protected String getTitleLabel() {
        return Messages.wizNewServerSelectExisting;
    }

    public IServer getSelectedServer() {
        return this.selection;
    }

    public void setSelection(IServer server) {
        if (server != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)server), true);
        } else {
            this.treeViewer.setSelection(null);
        }
    }

    protected void deferInitialization() {
        Job job = new Job(Messages.jobInitializingServersView){

            public IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            if ((this).ServerComposite.this.contentProvider.getInitialSelection() != null) {
                                (this).ServerComposite.this.treeViewer.setSelection((ISelection)new StructuredSelection((this).ServerComposite.this.contentProvider.getInitialSelection()), true);
                            }
                        }
                        catch (Exception exception) {}
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(20);
        job.schedule();
    }

    public static interface ServerSelectionListener {
        public void serverSelected(IServer var1);
    }
}

