/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.page;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;

public class ServerCreationCache {
    protected Map<String, IServerWorkingCopy> cache = new HashMap<String, IServerWorkingCopy>();

    private String getKey(IServerType type, boolean isLocalhost) {
        return String.valueOf(type.getId()) + "|" + isLocalhost + "|";
    }

    public IServerWorkingCopy getServer(IServerType type, boolean isLocalhost, IProgressMonitor monitor) throws CoreException {
        IServerWorkingCopy server = this.getCachedServer(type, isLocalhost);
        if (server != null) {
            return server;
        }
        server = type.createServer(null, null, null, monitor);
        this.cache.put(this.getKey(type, isLocalhost), server);
        return server;
    }

    public IServerWorkingCopy getCachedServer(IServerType type, boolean isLocalhost) {
        try {
            IServerWorkingCopy server = this.cache.get(this.getKey(type, isLocalhost));
            if (server != null) {
                return server;
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

