/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.gef.ui.palette.customize;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.customize.DefaultEntryPage;
import org.eclipse.gef.ui.palette.customize.DrawerEntryPage;
import org.eclipse.gef.ui.palette.customize.EntryPage;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.gef.ui.internal.GefDebugOptions;
import org.eclipse.gmf.runtime.gef.ui.internal.GefPlugin;
import org.eclipse.gmf.runtime.gef.ui.palette.customize.IPaletteState;
import org.eclipse.gmf.runtime.gef.ui.palette.customize.PaletteDrawerState;
import org.eclipse.gmf.runtime.gef.ui.palette.customize.PaletteEntryState;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class PaletteCustomizerEx
extends PaletteCustomizer {
    private static final String PALETTE_CUSTOMIZATIONS_ID = "org.eclipse.gmf.runtime.diagram.ui.paletteCustomizations";
    private HashMap<PaletteEntry, IPaletteState> paletteStates = new HashMap();

    public EntryPage getPropertiesPage(PaletteEntry entry) {
        if (entry.getType().equals(PaletteDrawer.PALETTE_TYPE_DRAWER)) {
            return new DrawerEntryPageEx();
        }
        return new DefaultEntryPageEx();
    }

    protected IPaletteState createPaletteState(PaletteEntry entry) {
        if (entry instanceof PaletteDrawer) {
            return new PaletteDrawerState((PaletteDrawer)entry);
        }
        return new PaletteEntryState(entry);
    }

    private void storePaletteState(PaletteEntry entry) {
        if (this.paletteStates.get(entry) != null) {
            return;
        }
        IPaletteState paletteState = this.createPaletteState(entry);
        paletteState.storeState();
        this.paletteStates.put(entry, paletteState);
    }

    public void revertToSaved() {
        for (Map.Entry<PaletteEntry, IPaletteState> entry : this.paletteStates.entrySet()) {
            entry.getValue().rollback();
        }
        this.paletteStates.clear();
    }

    public void save() {
        if (this.paletteStates.isEmpty()) {
            return;
        }
        XMLMemento rootMemento = this.getExistingCustomizations();
        if (rootMemento == null) {
            rootMemento = XMLMemento.createWriteRoot((String)PALETTE_CUSTOMIZATIONS_ID);
        }
        for (Map.Entry<PaletteEntry, IPaletteState> entry : this.paletteStates.entrySet()) {
            IMemento memento = this.getMementoForEntry((IMemento)rootMemento, entry.getKey());
            if (memento == null) continue;
            entry.getValue().storeChangesInMemento(memento);
        }
        StringWriter writer = new StringWriter();
        try {
            rootMemento.save((Writer)writer);
            IPreferenceStore preferences = this.getPreferences();
            if (preferences != null) {
                preferences.setValue(PALETTE_CUSTOMIZATIONS_ID, writer.toString());
            }
        }
        catch (IOException e) {
            Trace.catching((Plugin)GefPlugin.getInstance(), (String)GefDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"Problem saving the XML memento when saving the palette customizations.", (Throwable)e);
            Log.warning((Plugin)GefPlugin.getInstance(), (int)9, (String)"Problem saving the XML memento when saving the palette customizations.", (Throwable)e);
        }
        this.paletteStates.clear();
    }

    private IMemento getMementoForEntry(IMemento rootMemento, PaletteEntry paletteEntry) {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(paletteEntry.getId());
        PaletteContainer parent = paletteEntry.getParent();
        while (parent != null && !PaletteRoot.PALETTE_TYPE_ROOT.equals(parent.getType())) {
            idList.add(parent.getId());
            parent = parent.getParent();
        }
        IMemento containerMemento = rootMemento;
        int i = idList.size() - 1;
        while (i >= 0) {
            String id = (String)idList.get(i);
            IMemento memento = containerMemento.getChild(id);
            if (memento == null) {
                try {
                    memento = containerMemento.createChild(id);
                }
                catch (Exception e) {
                    Trace.catching((Plugin)GefPlugin.getInstance(), (String)GefDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"Invalid palette id encountered when saving the palette customizations.", (Throwable)e);
                    Log.warning((Plugin)GefPlugin.getInstance(), (int)9, (String)"Invalid palette id encountered when saving the palette customizations.", (Throwable)e);
                    return null;
                }
            }
            containerMemento = memento;
            --i;
        }
        return containerMemento;
    }

    public void applyCustomizationsToPalette(PaletteRoot paletteRoot) {
        XMLMemento rootMemento = this.getExistingCustomizations();
        if (rootMemento != null) {
            this.applyCustomizations((IMemento)rootMemento, (PaletteContainer)paletteRoot);
        }
    }

    private void applyCustomizations(IMemento containerMemento, PaletteContainer paletteContainer) {
        for (PaletteEntry entry : paletteContainer.getChildren()) {
            IMemento childMemento = containerMemento.getChild(entry.getId());
            if (childMemento == null) continue;
            IPaletteState state = this.createPaletteState(entry);
            state.applyChangesFromMemento(childMemento);
            if (!(entry instanceof PaletteContainer)) continue;
            this.applyCustomizations(childMemento, (PaletteContainer)entry);
        }
    }

    private XMLMemento getExistingCustomizations() {
        String sValue;
        IPreferenceStore preferences = this.getPreferences();
        if (preferences != null && (sValue = preferences.getString(PALETTE_CUSTOMIZATIONS_ID)) != null && !sValue.equals("")) {
            try {
                XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)new StringReader(sValue));
                return rootMemento;
            }
            catch (WorkbenchException e) {
                Trace.catching((Plugin)GefPlugin.getInstance(), (String)GefDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"Problem creating the XML memento when saving the palette customizations.", (Throwable)e);
                Log.warning((Plugin)GefPlugin.getInstance(), (int)9, (String)"Problem creating the XML memento when saving the palette customizations.", (Throwable)e);
            }
        }
        return null;
    }

    private IPreferenceStore getPreferences() {
        return GefPlugin.getInstance().getPreferenceStore();
    }

    private class DefaultEntryPageEx
    extends DefaultEntryPage {
        private DefaultEntryPageEx() {
        }

        protected void handleDescriptionChanged(String text) {
            PaletteCustomizerEx.this.storePaletteState(this.getEntry());
            super.handleDescriptionChanged(text);
        }

        protected void handleHiddenSelected(boolean isChecked) {
            PaletteCustomizerEx.this.storePaletteState(this.getEntry());
            super.handleHiddenSelected(isChecked);
        }

        protected void handleNameChanged(String text) {
            PaletteCustomizerEx.this.storePaletteState(this.getEntry());
            super.handleNameChanged(text);
        }
    }

    private class DrawerEntryPageEx
    extends DrawerEntryPage {
        private DrawerEntryPageEx() {
        }

        protected void handleOpenSelected(boolean selection) {
            PaletteCustomizerEx.this.storePaletteState(this.getEntry());
            super.handleOpenSelected(selection);
        }

        protected void handlePinSelected(boolean selection) {
            PaletteCustomizerEx.this.storePaletteState(this.getEntry());
            super.handlePinSelected(selection);
        }

        protected void handleDescriptionChanged(String text) {
            PaletteCustomizerEx.this.storePaletteState(this.getEntry());
            super.handleDescriptionChanged(text);
        }

        protected void handleHiddenSelected(boolean isChecked) {
            PaletteCustomizerEx.this.storePaletteState(this.getEntry());
            super.handleHiddenSelected(isChecked);
        }

        protected void handleNameChanged(String text) {
            PaletteCustomizerEx.this.storePaletteState(this.getEntry());
            super.handleNameChanged(text);
        }
    }
}

