/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.ui.internal.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatConfigurationWorkingCopy;
import org.eclipse.jst.server.tomcat.core.internal.MimeMapping;
import org.eclipse.jst.server.tomcat.core.internal.TomcatConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.command.AddMimeMappingCommand;
import org.eclipse.jst.server.tomcat.core.internal.command.ModifyMimeMappingCommand;
import org.eclipse.jst.server.tomcat.core.internal.command.RemoveMimeMappingCommand;
import org.eclipse.jst.server.tomcat.ui.internal.Messages;
import org.eclipse.jst.server.tomcat.ui.internal.TomcatUIPlugin;
import org.eclipse.jst.server.tomcat.ui.internal.editor.MimeMappingDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class ConfigurationMimeEditorSection
extends ServerEditorSection {
    protected TomcatConfiguration tomcatConfiguration;
    protected boolean updating;
    protected PropertyChangeListener listener;
    protected Tree mimeTypes;
    protected int index = -1;
    protected List mappings;
    protected Button add;
    protected Button remove;
    protected Button edit;
    static /* synthetic */ Class class$0;

    protected void addChangeListener() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("addMapping".equals(event.getPropertyName())) {
                    Integer in = (Integer)event.getOldValue();
                    MimeMapping mapping = (MimeMapping)event.getNewValue();
                    ConfigurationMimeEditorSection.this.addMimeMapping(in, mapping);
                } else if ("removeMapping".equals(event.getPropertyName())) {
                    Integer in = (Integer)event.getNewValue();
                    ConfigurationMimeEditorSection.this.removeMimeMapping(in);
                } else if ("modifyMapping".equals(event.getPropertyName())) {
                    Integer in = (Integer)event.getOldValue();
                    MimeMapping mapping = (MimeMapping)event.getNewValue();
                    ConfigurationMimeEditorSection.this.modifyMimeMapping(in, mapping);
                }
            }
        };
        this.tomcatConfiguration.addPropertyChangeListener(this.listener);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 394);
        section.setText(Messages.configurationEditorMimeMappingsSection);
        section.setDescription(Messages.configurationEditorMimeMappingsDescription);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)composite, "org.eclipse.jst.server.tomcat.ui.tecm0000");
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        this.mimeTypes = toolkit.createTree(composite, 772);
        data = new GridData(784);
        data.heightHint = 200;
        this.mimeTypes.setLayoutData((Object)data);
        whs.setHelp((Control)this.mimeTypes, "org.eclipse.jst.server.tomcat.ui.tecm0002");
        this.mimeTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationMimeEditorSection.this.selectMimeMapping();
            }
        });
        Composite buttonComp = toolkit.createComposite(composite);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComp.setLayout((Layout)layout);
        buttonComp.setLayoutData((Object)new GridData(258));
        this.add = toolkit.createButton(buttonComp, Messages.editorAdd, 8);
        this.add.setLayoutData((Object)new GridData(256));
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MimeMappingDialog dialog = new MimeMappingDialog(ConfigurationMimeEditorSection.this.getShell());
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    ConfigurationMimeEditorSection.this.execute((IUndoableOperation)new AddMimeMappingCommand((ITomcatConfigurationWorkingCopy)ConfigurationMimeEditorSection.this.tomcatConfiguration, dialog.getMimeMapping()));
                }
            }
        });
        whs.setHelp((Control)this.add, "org.eclipse.jst.server.tomcat.ui.tecm0004");
        this.edit = toolkit.createButton(buttonComp, Messages.editorEdit, 8);
        this.edit.setLayoutData((Object)new GridData(256));
        this.edit.setEnabled(false);
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConfigurationMimeEditorSection.this.index < 0) {
                    return;
                }
                MimeMappingDialog dialog = new MimeMappingDialog(ConfigurationMimeEditorSection.this.getShell(), (MimeMapping)ConfigurationMimeEditorSection.this.tomcatConfiguration.getMimeMappings().get(ConfigurationMimeEditorSection.this.index));
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    ConfigurationMimeEditorSection.this.execute((IUndoableOperation)new ModifyMimeMappingCommand((ITomcatConfigurationWorkingCopy)ConfigurationMimeEditorSection.this.tomcatConfiguration, ConfigurationMimeEditorSection.this.index, dialog.getMimeMapping()));
                }
            }
        });
        whs.setHelp((Control)this.edit, "org.eclipse.jst.server.tomcat.ui.tecm0006");
        this.remove = toolkit.createButton(buttonComp, Messages.editorRemove, 8);
        this.remove.setLayoutData((Object)new GridData(256));
        this.remove.setEnabled(false);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConfigurationMimeEditorSection.this.index < 0) {
                    return;
                }
                ConfigurationMimeEditorSection.this.execute((IUndoableOperation)new RemoveMimeMappingCommand((ITomcatConfigurationWorkingCopy)ConfigurationMimeEditorSection.this.tomcatConfiguration, ConfigurationMimeEditorSection.this.index));
                ConfigurationMimeEditorSection.this.index = -1;
                ConfigurationMimeEditorSection.this.edit.setEnabled(false);
                ConfigurationMimeEditorSection.this.remove.setEnabled(false);
            }
        });
        whs.setHelp((Control)this.remove, "org.eclipse.jst.server.tomcat.ui.tecm0008");
        this.initialize();
    }

    public void dispose() {
        if (this.tomcatConfiguration != null) {
            this.tomcatConfiguration.removePropertyChangeListener(this.listener);
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.TomcatServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TomcatServer ts = (TomcatServer)this.server.getAdapter((Class)clazz);
        try {
            this.tomcatConfiguration = ts.getTomcatConfiguration();
        }
        catch (Exception exception) {}
        this.addChangeListener();
        this.initialize();
    }

    protected void initialize() {
        if (this.mimeTypes == null) {
            return;
        }
        this.mimeTypes.removeAll();
        this.mappings = this.tomcatConfiguration.getMimeMappings();
        int size = this.mappings.size();
        int[] map = new int[size];
        int i = 0;
        while (i < size) {
            map[i] = i;
            ++i;
        }
        i = 0;
        while (i < size - 1) {
            int j = i + 1;
            while (j < size) {
                MimeMapping mappingA = (MimeMapping)this.mappings.get(map[i]);
                MimeMapping mappingB = (MimeMapping)this.mappings.get(map[j]);
                if (mappingA.getMimeType().compareTo(mappingB.getMimeType()) > 0 || mappingA.getMimeType().equals(mappingB.getMimeType()) && mappingA.getExtension().compareTo(mappingB.getExtension()) > 0) {
                    int temp = map[i];
                    map[i] = map[j];
                    map[j] = temp;
                }
                ++j;
            }
            ++i;
        }
        HashMap<String, TreeItem> hash = new HashMap<String, TreeItem>();
        int i2 = 0;
        while (i2 < size) {
            MimeMapping mapping = (MimeMapping)this.mappings.get(map[i2]);
            TreeItem parent = (TreeItem)hash.get(mapping.getMimeType());
            if (parent == null) {
                parent = new TreeItem(this.mimeTypes, 0);
                parent.setText(mapping.getMimeType());
                parent.setImage(TomcatUIPlugin.getImage("mimeMapping"));
                hash.put(mapping.getMimeType(), parent);
            }
            TreeItem item = new TreeItem(parent, 0);
            item.setText(mapping.getExtension());
            item.setImage(TomcatUIPlugin.getImage("mimeExtension"));
            item.setData((Object)new Integer(map[i2]));
            ++i2;
        }
        if (this.readOnly) {
            this.add.setEnabled(false);
            this.edit.setEnabled(false);
            this.remove.setEnabled(false);
        } else {
            this.add.setEnabled(true);
            this.selectMimeMapping();
        }
    }

    protected void addMimeMapping(int index2, MimeMapping map) {
        TreeItem parent;
        this.mappings.add(index2, map);
        int size = this.mimeTypes.getItemCount();
        TreeItem[] parents = this.mimeTypes.getItems();
        int i = 0;
        while (i < size) {
            parent = parents[i];
            int size2 = parent.getItemCount();
            TreeItem[] children = parent.getItems();
            int j = 0;
            while (j < size2) {
                Integer in = (Integer)children[j].getData();
                if (in >= index2) {
                    children[j].setData((Object)new Integer(in + 1));
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            parent = parents[i];
            if (parent.getText().equals(map.getMimeType())) {
                TreeItem item = new TreeItem(parent, 0);
                item.setText(map.getExtension());
                item.setImage(TomcatUIPlugin.getImage("mimeExtension"));
                item.setData((Object)new Integer(index2));
                this.mimeTypes.showItem(item);
                return;
            }
            ++i;
        }
        TreeItem parent2 = new TreeItem(this.mimeTypes, 0);
        parent2.setText(map.getMimeType());
        parent2.setImage(TomcatUIPlugin.getImage("mimeMapping"));
        TreeItem item = new TreeItem(parent2, 0);
        item.setText(map.getExtension());
        item.setImage(TomcatUIPlugin.getImage("mimeExtension"));
        item.setData((Object)new Integer(index2));
        this.mimeTypes.showItem(item);
    }

    protected void modifyMimeMapping(int index2, MimeMapping map) {
        MimeMapping oldMap = (MimeMapping)this.mappings.get(index2);
        this.mappings.set(index2, map);
        int size = this.mimeTypes.getItemCount();
        TreeItem[] parents = this.mimeTypes.getItems();
        if (oldMap.getMimeType().equals(map.getMimeType())) {
            int i = 0;
            while (i < size) {
                TreeItem parent = parents[i];
                if (parent.getText().equals(map.getMimeType())) {
                    int size2 = parent.getItemCount();
                    TreeItem[] children = parent.getItems();
                    int j = 0;
                    while (j < size2) {
                        Integer in = (Integer)children[j].getData();
                        if (in == index2) {
                            children[j].setText(map.getExtension());
                            children[j].setData((Object)new Integer(index2));
                            this.mimeTypes.showItem(children[j]);
                            return;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return;
        }
        this.removeMimeMapping(index2);
        this.addMimeMapping(index2, map);
    }

    protected void removeMimeMapping(int index2) {
        Integer in;
        int j;
        TreeItem[] children;
        int size2;
        TreeItem parent;
        this.mappings.remove(index2);
        int size = this.mimeTypes.getItemCount();
        TreeItem[] parents = this.mimeTypes.getItems();
        int i = 0;
        while (i < size) {
            parent = parents[i];
            size2 = parent.getItemCount();
            children = parent.getItems();
            j = 0;
            while (j < size2) {
                in = (Integer)children[j].getData();
                if (in == index2) {
                    children[j].dispose();
                    if (size2 == 1) {
                        parent.dispose();
                    }
                    i += size;
                    j += size2;
                }
                ++j;
            }
            ++i;
        }
        size = this.mimeTypes.getItemCount();
        parents = this.mimeTypes.getItems();
        i = 0;
        while (i < size) {
            parent = parents[i];
            size2 = parent.getItemCount();
            children = parent.getItems();
            j = 0;
            while (j < size2) {
                in = (Integer)children[j].getData();
                if (in > index2) {
                    children[j].setData((Object)new Integer(in - 1));
                }
                ++j;
            }
            ++i;
        }
    }

    protected void selectMimeMapping() {
        if (this.readOnly) {
            return;
        }
        try {
            TreeItem item = this.mimeTypes.getSelection()[0];
            Integer in = (Integer)item.getData();
            if (in == null) {
                this.index = -1;
                this.remove.setEnabled(false);
                this.edit.setEnabled(false);
                return;
            }
            this.index = in;
            this.remove.setEnabled(true);
            this.edit.setEnabled(true);
        }
        catch (Exception exception) {
            this.index = -1;
            this.remove.setEnabled(false);
            this.edit.setEnabled(false);
        }
    }
}

