/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.ui.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.operations.OperationHistoryActionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ActionWrapperHelper<T extends OperationHistoryActionHandler>
extends Action {
    private final OwnerAccess<T> ownerAccess;
    private T delegate;
    private final Map<IWorkbenchPartSite, T> siteToActionHandler = new HashMap<IWorkbenchPartSite, T>();
    private IPartListener partListener;
    private final IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            ActionWrapperHelper.this.ownerAccess.firePropertyChange(event.getProperty(), event.getOldValue(), event.getNewValue());
        }
    };

    ActionWrapperHelper(OwnerAccess<T> ownerAccess) {
        this.ownerAccess = ownerAccess;
    }

    void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        IUndoContext context = null;
        if (workbenchPart != null) {
            context = (IUndoContext)workbenchPart.getAdapter(IUndoContext.class);
        }
        if (context != null) {
            if (this.delegate != null) {
                this.delegate.removePropertyChangeListener(this.listener);
            }
            this.delegate = this.getActionHandler(workbenchPart.getSite(), context);
            this.delegate.addPropertyChangeListener(this.listener);
            boolean enabled = this.isEnabled();
            this.ownerAccess.firePropertyChange("enabled", !enabled, enabled);
        }
    }

    private T getActionHandler(IWorkbenchPartSite site, IUndoContext context) {
        OperationHistoryActionHandler result = (OperationHistoryActionHandler)this.siteToActionHandler.get(site);
        if (result == null) {
            result = (OperationHistoryActionHandler)this.ownerAccess.createDelegate(site, context);
            site.getPage().addPartListener(this.getPartListener());
            this.siteToActionHandler.put(site, result);
        }
        return (T)result;
    }

    private IPartListener getPartListener() {
        if (this.partListener == null) {
            this.partListener = new IPartListener(){

                public void partClosed(IWorkbenchPart part) {
                    OperationHistoryActionHandler handler = (OperationHistoryActionHandler)ActionWrapperHelper.this.siteToActionHandler.get(part.getSite());
                    if (handler != null) {
                        ActionWrapperHelper.this.siteToActionHandler.remove(part.getSite());
                    }
                }

                public void partOpened(IWorkbenchPart part) {
                }

                public void partDeactivated(IWorkbenchPart part) {
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                }

                public void partActivated(IWorkbenchPart part) {
                }
            };
        }
        return this.partListener;
    }

    public void update() {
        if (this.delegate != null) {
            this.delegate.update();
        }
    }

    public String getDescription() {
        if (this.delegate != null) {
            return this.delegate.getDescription();
        }
        return null;
    }

    public String getText() {
        if (this.delegate != null) {
            return this.delegate.getText();
        }
        return null;
    }

    public String getToolTipText() {
        if (this.delegate != null) {
            return this.delegate.getToolTipText();
        }
        return null;
    }

    public boolean isEnabled() {
        if (this.delegate != null) {
            return this.delegate.isEnabled();
        }
        return false;
    }

    public boolean isHandled() {
        if (this.delegate != null) {
            return this.delegate.isHandled();
        }
        return false;
    }

    public void run() {
        if (this.delegate != null) {
            this.delegate.run();
        }
    }

    public void runWithEvent(Event event) {
        if (this.delegate != null) {
            this.delegate.runWithEvent(event);
        }
    }

    public void setChecked(boolean checked) {
        if (this.delegate != null) {
            this.delegate.setChecked(checked);
        }
    }

    public void setDescription(String text) {
        if (this.delegate != null) {
            this.delegate.setDescription(text);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.delegate != null) {
            this.delegate.setEnabled(enabled);
        }
    }

    public void setText(String text) {
        if (this.delegate != null) {
            this.delegate.setText(text);
        }
    }

    public void setToolTipText(String toolTipText) {
        if (this.delegate != null) {
            this.delegate.setToolTipText(toolTipText);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface OwnerAccess<T extends Action> {
        public void firePropertyChange(String var1, Object var2, Object var3);

        public T createDelegate(IWorkbenchPartSite var1, IUndoContext var2);
    }
}

