/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.internal.util.FontHelper;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.l10n.DiagramUIPropertiesImages;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.l10n.DiagramUIPropertiesMessages;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AbstractNotationPropertiesSection;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance.ColorPalettePopup;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchPart;

public class ColorsAndFontsPropertySection
extends AbstractNotationPropertiesSection {
    protected static final String FONT_COLOR_COMMAND_NAME = String.valueOf(DiagramUIPropertiesMessages.FontColor_commandText) + " " + VALUE_CHANGED_STRING;
    protected static final String LINE_COLOR_COMMAND_NAME = String.valueOf(DiagramUIPropertiesMessages.LineColor_commandText) + " " + VALUE_CHANGED_STRING;
    protected static final String FONT_COMMAND_NAME = String.valueOf(DiagramUIPropertiesMessages.Font_commandText) + " " + VALUE_CHANGED_STRING;
    protected static final String FILL_COLOR_COMMAND_NAME = String.valueOf(DiagramUIPropertiesMessages.FillColor_commandText) + " " + VALUE_CHANGED_STRING;
    protected static final String FONTS_AND_COLORS_LABEL = DiagramUIPropertiesMessages.FontAndColor_nameLabel;
    protected ToolItem fillColorButton;
    protected RGB fillColor = null;
    protected CCombo fontFamilyCombo;
    private CCombo fontSizeCombo;
    private ToolBar toolBar;
    private ToolItem fontBoldButton;
    private ToolItem fontItalicButton;
    protected static final RGB DEFAULT_PREF_COLOR = new RGB(0, 0, 0);
    protected ToolItem fontColorButton;
    protected ToolItem lineColorButton;
    protected RGB fontColor;
    protected RGB lineColor;
    protected Group colorsAndFontsGroup;
    protected int previousColor;

    protected void initializeControls(Composite parent) {
        super.initializeControls(parent);
        this.createFontsAndColorsGroups(this.composite);
    }

    protected Group createFontsAndColorsGroups(Composite parent) {
        this.colorsAndFontsGroup = this.getWidgetFactory().createGroup(parent, FONTS_AND_COLORS_LABEL);
        GridLayout layout = new GridLayout(1, false);
        this.colorsAndFontsGroup.setLayout((Layout)layout);
        this.createFontsGroup((Composite)this.colorsAndFontsGroup);
        return this.colorsAndFontsGroup;
    }

    protected Composite createFontsGroup(Composite parent) {
        Composite familySize = this.getWidgetFactory().createComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        familySize.setLayout((Layout)layout);
        this.fontFamilyCombo = this.getWidgetFactory().createCCombo(familySize, 2060);
        this.fontFamilyCombo.setItems(FontHelper.getFontNames());
        this.fontFamilyCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorsAndFontsPropertySection.this.updateFontFamily();
            }
        });
        this.fontSizeCombo = this.getWidgetFactory().createCCombo(familySize, 2060);
        this.fontSizeCombo.setItems(FontHelper.getFontSizes());
        this.fontSizeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorsAndFontsPropertySection.this.updateFontSize();
            }
        });
        this.toolBar = new ToolBar(parent, 0x800000);
        this.toolBar.setLayout((Layout)new GridLayout(7, false));
        this.toolBar.setBackground(parent.getBackground());
        this.fontBoldButton = new ToolItem(this.toolBar, 32);
        this.fontBoldButton.setImage(DiagramUIPropertiesImages.get("icons/bold.gif"));
        this.fontBoldButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorsAndFontsPropertySection.this.updateFontBold();
            }
        });
        this.fontBoldButton.setToolTipText(DiagramUIMessages.FontStyleAction_bold_tooltip);
        this.fontItalicButton = new ToolItem(this.toolBar, 32);
        this.fontItalicButton.setImage(DiagramUIPropertiesImages.get("icons/italic.gif"));
        this.fontItalicButton.setToolTipText(DiagramUIMessages.PropertyDescriptorFactory_FontStyle_Italic);
        this.fontItalicButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorsAndFontsPropertySection.this.updateFontItalic();
            }
        });
        this.fontColorButton = new ToolItem(this.toolBar, 4);
        this.fontColorButton.setImage(DiagramUIPropertiesImages.get("icons/font_color.gif"));
        this.fontColorButton.setToolTipText(DiagramUIMessages.PropertyDescriptorFactory_FontColor);
        this.fontColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorsAndFontsPropertySection.this.changeFontColor(event);
            }
        });
        this.lineColorButton = new ToolItem(this.toolBar, 4);
        this.lineColorButton.setImage(DiagramUIPropertiesImages.get("icons/line_color.gif"));
        this.lineColorButton.setToolTipText(DiagramUIMessages.PropertyDescriptorFactory_LineColor);
        this.lineColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorsAndFontsPropertySection.this.changeLineColor(event);
            }
        });
        this.fillColorButton = new ToolItem(this.toolBar, 4);
        this.fillColorButton.setImage(DiagramUIPropertiesImages.get("icons/fill_color.gif"));
        this.fillColorButton.setToolTipText(DiagramUIMessages.PropertyDescriptorFactory_FillColor);
        this.fillColorButton.setEnabled(false);
        this.toolBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String toolTip;
                ToolItem item;
                if (e.childID != -1 && (item = ColorsAndFontsPropertySection.this.toolBar.getItem(e.childID)) != null && (toolTip = item.getToolTipText()) != null) {
                    e.result = toolTip;
                }
            }
        });
        return this.toolBar;
    }

    protected Iterator getInputIterator() {
        return this.getInput().iterator();
    }

    protected void changeLineColor(SelectionEvent event) {
        if (this.lineColor != null) {
            this.previousColor = FigureUtilities.RGBToInteger((RGB)this.lineColor);
        }
        this.lineColor = this.changeColor(event, this.lineColorButton, "Appearance.lineColor", Properties.ID_LINECOLOR, LINE_COLOR_COMMAND_NAME, DiagramUIPropertiesImages.DESC_LINE_COLOR);
    }

    protected void changeFontColor(SelectionEvent event) {
        if (this.fontColor != null) {
            this.previousColor = FigureUtilities.RGBToInteger((RGB)this.fontColor);
        }
        this.fontColor = this.changeColor(event, this.fontColorButton, "Appearance.fontColor", Properties.ID_FONTCOLOR, FONT_COLOR_COMMAND_NAME, DiagramUIPropertiesImages.DESC_FONT_COLOR);
    }

    protected RGB changeColor(SelectionEvent event, Button button, String preferenceId, String propertyId, String commandName, ImageDescriptor imageDescriptor) {
        return this.changeColor(event, button, propertyId, commandName, imageDescriptor);
    }

    protected RGB changeColor(SelectionEvent event, ToolItem toolItem, String preferenceId, String propertyId, String commandName, ImageDescriptor imageDescriptor) {
        return this.changeColor(event, toolItem, propertyId, commandName, imageDescriptor);
    }

    protected RGB changeColor(SelectionEvent event, Button button, final String propertyId, String commandName, ImageDescriptor imageDescriptor) {
        ColorPalettePopup popup = new ColorPalettePopup(button.getParent().getShell(), 25);
        popup.setPreviousColor(this.previousColor);
        Rectangle r = button.getBounds();
        Point location = button.getParent().toDisplay(r.x, r.y);
        popup.open(new Point(location.x, location.y + r.height));
        if (popup.getSelectedColor() == null && !popup.useDefaultColor()) {
            return null;
        }
        RGB selectedColor = popup.getSelectedColor();
        final EStructuralFeature feature = (EStructuralFeature)PackageUtil.getElement((String)propertyId);
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        Iterator it = this.getInputIterator();
        RGB colorToReturn = selectedColor;
        RGB color = selectedColor;
        while (it.hasNext()) {
            Object preferredValue;
            final IGraphicalEditPart ep = (IGraphicalEditPart)it.next();
            color = selectedColor;
            if (popup.useDefaultColor() && (preferredValue = ep.getPreferredValue(feature)) instanceof Integer) {
                color = FigureUtilities.integerToRGB((Integer)((Integer)preferredValue));
            }
            if (colorToReturn == null) {
                colorToReturn = color;
            }
            if (color == null) continue;
            final RGB finalColor = color;
            commands.add(this.createCommand(commandName, ((View)ep.getModel()).eResource(), new Runnable(){

                public void run() {
                    ENamedElement element = PackageUtil.getElement((String)propertyId);
                    if (element instanceof EStructuralFeature) {
                        ep.setStructuralFeatureValue(feature, (Object)FigureUtilities.RGBToInteger((RGB)finalColor));
                    }
                }
            }));
        }
        if (!commands.isEmpty()) {
            this.executeAsCompositeCommand(commandName, commands);
            Image overlyedImage = new ColorOverlayImageDescriptor(imageDescriptor.getImageData(), color).createImage();
            this.disposeImage(button.getImage());
            button.setImage(overlyedImage);
        }
        return colorToReturn;
    }

    protected RGB changeColor(SelectionEvent event, ToolItem toolItem, final String propertyId, String commandName, ImageDescriptor imageDescriptor) {
        ColorPalettePopup popup = new ColorPalettePopup(toolItem.getParent().getShell(), 25);
        popup.setPreviousColor(this.previousColor);
        Rectangle r = toolItem.getBounds();
        Point location = toolItem.getParent().toDisplay(r.x, r.y);
        popup.open(new Point(location.x, location.y + r.height));
        if (popup.getSelectedColor() == null && !popup.useDefaultColor()) {
            return null;
        }
        RGB selectedColor = popup.getSelectedColor();
        final EStructuralFeature feature = (EStructuralFeature)PackageUtil.getElement((String)propertyId);
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        Iterator it = this.getInputIterator();
        RGB colorToReturn = selectedColor;
        RGB color = selectedColor;
        while (it.hasNext()) {
            Object preferredValue;
            final IGraphicalEditPart ep = (IGraphicalEditPart)it.next();
            color = selectedColor;
            if (popup.useDefaultColor() && (preferredValue = ep.getPreferredValue(feature)) instanceof Integer) {
                color = FigureUtilities.integerToRGB((Integer)((Integer)preferredValue));
            }
            if (colorToReturn == null) {
                colorToReturn = color;
            }
            if (color == null) continue;
            final RGB finalColor = color;
            commands.add(this.createCommand(commandName, ((View)ep.getModel()).eResource(), new Runnable(){

                public void run() {
                    ENamedElement element = PackageUtil.getElement((String)propertyId);
                    if (element instanceof EStructuralFeature) {
                        ep.setStructuralFeatureValue(feature, (Object)FigureUtilities.RGBToInteger((RGB)finalColor));
                    }
                }
            }));
        }
        if (!commands.isEmpty()) {
            this.executeAsCompositeCommand(commandName, commands);
            Image overlyedImage = new ColorOverlayImageDescriptor(imageDescriptor.getImageData(), color).createImage();
            this.disposeImage(toolItem.getImage());
            toolItem.setImage(overlyedImage);
        }
        return colorToReturn;
    }

    protected void updateFontBold() {
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        Iterator it = this.getInputIterator();
        while (it.hasNext()) {
            final IGraphicalEditPart ep = (IGraphicalEditPart)it.next();
            commands.add(this.createCommand(FONT_COMMAND_NAME, ((View)ep.getModel()).eResource(), new Runnable(){

                public void run() {
                    ep.setStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Bold(), (Object)ColorsAndFontsPropertySection.this.fontBoldButton.getSelection());
                }
            }));
        }
        this.executeAsCompositeCommand(FONT_COMMAND_NAME, commands);
    }

    protected void updateFontItalic() {
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        Iterator it = this.getInputIterator();
        while (it.hasNext()) {
            final IGraphicalEditPart ep = (IGraphicalEditPart)it.next();
            commands.add(this.createCommand(FONT_COMMAND_NAME, ((View)ep.getModel()).eResource(), new Runnable(){

                public void run() {
                    ep.setStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Italic(), (Object)new Boolean(ColorsAndFontsPropertySection.this.fontItalicButton.getSelection()));
                }
            }));
        }
        this.executeAsCompositeCommand(FONT_COMMAND_NAME, commands);
    }

    protected void updateFontFamily() {
        if (this.fontFamilyCombo.getText() != null || !this.fontFamilyCombo.getText().equals("")) {
            ArrayList<ICommand> commands = new ArrayList<ICommand>();
            Iterator it = this.getInputIterator();
            while (it.hasNext()) {
                final IGraphicalEditPart ep = (IGraphicalEditPart)it.next();
                commands.add(this.createCommand(FONT_COMMAND_NAME, ((View)ep.getModel()).eResource(), new Runnable(){

                    public void run() {
                        ep.setStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontName(), (Object)ColorsAndFontsPropertySection.this.fontFamilyCombo.getText());
                    }
                }));
            }
            this.executeAsCompositeCommand(FONT_COMMAND_NAME, commands);
        }
    }

    protected void updateFontSize() {
        if (this.fontSizeCombo.getText() != null || !this.fontSizeCombo.getText().equals("")) {
            ArrayList<ICommand> commands = new ArrayList<ICommand>();
            Iterator it = this.getInputIterator();
            while (it.hasNext()) {
                final IGraphicalEditPart ep = (IGraphicalEditPart)it.next();
                commands.add(this.createCommand(FONT_COMMAND_NAME, ((View)ep.getModel()).eResource(), new Runnable(){

                    public void run() {
                        ep.setStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontHeight(), (Object)new Integer(ColorsAndFontsPropertySection.this.fontSizeCombo.getText()));
                    }
                }));
            }
            this.executeAsCompositeCommand(FONT_COMMAND_NAME, commands);
        }
    }

    public void refresh() {
        if (!this.isDisposed()) {
            Image overlyedImage = new ColorOverlayImageDescriptor(DiagramUIPropertiesImages.DESC_FONT_COLOR.getImageData(), this.fontColor).createImage();
            this.disposeImage(this.fontColorButton.getImage());
            this.fontColorButton.setImage(overlyedImage);
            overlyedImage = new ColorOverlayImageDescriptor(DiagramUIPropertiesImages.DESC_LINE_COLOR.getImageData(), this.lineColor).createImage();
            this.disposeImage(this.lineColorButton.getImage());
            this.lineColorButton.setImage(overlyedImage);
            this.executeAsReadAction(new Runnable(){

                public void run() {
                    IGraphicalEditPart ep = ColorsAndFontsPropertySection.this.getSingleInput();
                    if (ep != null) {
                        boolean isReadOnly = ColorsAndFontsPropertySection.this.isReadOnly();
                        ColorsAndFontsPropertySection.this.lineColorButton.setEnabled(!isReadOnly);
                        ColorsAndFontsPropertySection.this.fillColorButton.setEnabled(!isReadOnly);
                        Style style = ep.getNotationView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
                        boolean enableFontWidgets = style != null && !isReadOnly;
                        ColorsAndFontsPropertySection.this.fontFamilyCombo.setEnabled(enableFontWidgets);
                        ColorsAndFontsPropertySection.this.fontSizeCombo.setEnabled(enableFontWidgets);
                        ColorsAndFontsPropertySection.this.fontBoldButton.setEnabled(enableFontWidgets);
                        ColorsAndFontsPropertySection.this.fontItalicButton.setEnabled(enableFontWidgets);
                        ColorsAndFontsPropertySection.this.fontColorButton.setEnabled(enableFontWidgets);
                        ColorsAndFontsPropertySection.this.fontFamilyCombo.setText((String)ColorsAndFontsPropertySection.this.getSingleInput().getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontName()));
                        ColorsAndFontsPropertySection.this.fontSizeCombo.setText(Integer.toString((Integer)ColorsAndFontsPropertySection.this.getSingleInput().getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontHeight())));
                        ColorsAndFontsPropertySection.this.fontBoldButton.setSelection(((Boolean)ColorsAndFontsPropertySection.this.getSingleInput().getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Bold())).booleanValue());
                        ColorsAndFontsPropertySection.this.fontItalicButton.setSelection(((Boolean)ColorsAndFontsPropertySection.this.getSingleInput().getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Italic())).booleanValue());
                    }
                }
            });
        }
    }

    public void update(final Notification notification, final EObject element) {
        if (!this.isDisposed() && this.isCurrentSelection(notification, element)) {
            this.postUpdateRequest(new Runnable(){

                public void run() {
                    if (!ColorsAndFontsPropertySection.this.isDisposed() && ColorsAndFontsPropertySection.this.isCurrentSelection(notification, element) && !ColorsAndFontsPropertySection.this.isNotifierDeleted(notification)) {
                        ColorsAndFontsPropertySection.this.updateColorCache();
                    }
                    ColorsAndFontsPropertySection.this.refresh();
                }
            });
        }
    }

    protected void updateColorCache() {
        this.executeAsReadAction(new Runnable(){

            public void run() {
                IGraphicalEditPart ep = ColorsAndFontsPropertySection.this.getSingleInput();
                if (ep != null) {
                    ColorsAndFontsPropertySection.this.fontColor = FigureUtilities.integerToRGB((Integer)((Integer)ep.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontColor())));
                    ColorsAndFontsPropertySection.this.lineColor = FigureUtilities.integerToRGB((Integer)((Integer)ep.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor())));
                }
            }
        });
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.updateColorCache();
    }

    protected void disposeImage(Image image) {
        if (image == null) {
            return;
        }
        if (image.equals((Object)DiagramUIPropertiesImages.get("icons/fill_color.gif")) || image.equals((Object)DiagramUIPropertiesImages.get("icons/line_color.gif")) || image.equals((Object)DiagramUIPropertiesImages.get("icons/font_color.gif"))) {
            return;
        }
        if (!image.isDisposed()) {
            image.dispose();
        }
    }

    public void dispose() {
        if (this.fontColorButton != null && !this.fontColorButton.isDisposed()) {
            this.disposeImage(this.fontColorButton.getImage());
        }
        if (this.lineColorButton != null && !this.lineColorButton.isDisposed()) {
            this.disposeImage(this.lineColorButton.getImage());
        }
        if (this.fillColorButton != null && !this.fillColorButton.isDisposed()) {
            this.disposeImage(this.fillColorButton.getImage());
        }
        super.dispose();
    }

    protected boolean digIntoGroups() {
        return true;
    }

    protected static class ColorOverlayImageDescriptor
    extends CompositeImageDescriptor {
        private static final Point ICON_SIZE = new Point(16, 16);
        private ImageData basicImgData;
        private RGB rgb;

        public ColorOverlayImageDescriptor(ImageData basicImgData, RGB rgb) {
            this.basicImgData = basicImgData;
            this.rgb = rgb;
        }

        protected void drawCompositeImage(int width, int height) {
            if (this.rgb != null) {
                ImageData colorBar = new ImageData(width, height / 5, 1, new PaletteData(new RGB[]{this.rgb}));
                this.drawImage(colorBar, 0, height - height / 5);
            }
            this.drawImage(this.basicImgData, 0, 0);
        }

        protected Point getSize() {
            return ICON_SIZE;
        }
    }
}

