/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.ClasspathContainerInitializer;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;

public class LibrarySuperType {
    IPath cpEntry;
    String superTypeName;
    String libraryName;
    IJavaProject javaProject;
    public static final String SUPER_TYPE_CONTAINER = "org.eclipse.wst.jsdt.ui.superType.container";
    public static final String SUPER_TYPE_NAME = "org.eclipse.wst.jsdt.ui.superType.name";

    public LibrarySuperType(IPath classPathEntry, IJavaProject project, String superTypeName) {
        this.cpEntry = classPathEntry;
        this.superTypeName = superTypeName;
        this.javaProject = project;
        this.libraryName = this.initLibraryName();
    }

    public LibrarySuperType(String classPathEntry, IJavaProject project, String superTypeName) {
        this((IPath)new Path(classPathEntry), project, superTypeName);
    }

    public LibrarySuperType(IPath classPathEntry, IJavaProject project) {
        this(classPathEntry, project, null);
    }

    public IPath getRawContainerPath() {
        return this.cpEntry;
    }

    public boolean hasChildren() {
        if (this.superTypeName != null) {
            return false;
        }
        ClasspathContainerInitializer init = this.getContainerInitializer();
        if (init == null) {
            return false;
        }
        String[] availableSuperTypes = init.containerSuperTypes();
        return availableSuperTypes != null && availableSuperTypes.length > 0;
    }

    public LibrarySuperType[] getChildren() {
        if (this.superTypeName != null) {
            return new LibrarySuperType[0];
        }
        return LibrarySuperType.getFlatLibrarySuperTypes(this.cpEntry, this.javaProject);
    }

    public LibrarySuperType getParent() {
        if (this.superTypeName == null) {
            return null;
        }
        return new LibrarySuperType(this.cpEntry, this.javaProject, null);
    }

    public boolean isParent() {
        return this.getParent() == null;
    }

    public ClasspathContainerInitializer getContainerInitializer() {
        return LibrarySuperType.getContainerInitializer(this.cpEntry);
    }

    public IClasspathEntry[] getClasspathEntries() {
        IClasspathContainer container = null;
        try {
            container = JavaCore.getClasspathContainer(this.cpEntry, this.javaProject);
        }
        catch (JavaModelException ex) {
            ex.printStackTrace();
        }
        if (container != null) {
            return container.getClasspathEntries();
        }
        return new IClasspathEntry[0];
    }

    private static LibrarySuperType[] getFlatLibrarySuperTypes(IPath classPathEntry, IJavaProject javaProject) {
        ClasspathContainerInitializer init = LibrarySuperType.getContainerInitializer(classPathEntry);
        if (init == null) {
            return new LibrarySuperType[0];
        }
        String[] availableSuperTypes = init.containerSuperTypes();
        LibrarySuperType[] libSupers = new LibrarySuperType[availableSuperTypes.length];
        int i = 0;
        while (i < availableSuperTypes.length) {
            libSupers[i] = new LibrarySuperType(classPathEntry, javaProject, availableSuperTypes[i]);
            ++i;
        }
        return libSupers;
    }

    public String getSuperTypeName() {
        return this.superTypeName;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    private String initLibraryName() {
        ClasspathContainerInitializer init = this.getContainerInitializer();
        if (this.superTypeName == null) {
            if (init == null) {
                return this.cpEntry.toString();
            }
            return init.getDescription(this.cpEntry, this.javaProject);
        }
        LibrarySuperType parent = this.getParent();
        if (!(parent instanceof LibrarySuperType)) {
            return null;
        }
        return parent.getLibraryName();
    }

    public String toString() {
        if (this.isParent()) {
            return this.getLibraryName();
        }
        return String.valueOf(this.superTypeName) + "() in " + this.getLibraryName();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LibrarySuperType)) {
            return false;
        }
        LibrarySuperType other = (LibrarySuperType)o;
        if (other.cpEntry != null && !other.cpEntry.equals((Object)this.cpEntry)) {
            return false;
        }
        if (other.superTypeName == this.superTypeName) {
            return true;
        }
        if (other.superTypeName != null && this.superTypeName != null) {
            return other.superTypeName.equals(this.superTypeName);
        }
        return false;
    }

    public IPackageFragment[] getPackageFragments() {
        IClasspathEntry[] entries = this.getClasspathEntries();
        ArrayList<IJavaElement> allFrags = new ArrayList<IJavaElement>();
        try {
            int i = 0;
            while (i < entries.length) {
                IPath path = entries[i].getPath();
                IPackageFragmentRoot root = this.javaProject.findPackageFragmentRoot(path.makeAbsolute());
                IJavaElement[] children = root.getChildren();
                int k = 0;
                while (k < children.length) {
                    if (children[k] instanceof IPackageFragment) {
                        allFrags.add(children[k]);
                    }
                    ++k;
                }
                ++i;
            }
        }
        catch (JavaModelException ex) {
            ex.printStackTrace();
        }
        return allFrags.toArray(new IPackageFragment[allFrags.size()]);
    }

    public static ClasspathContainerInitializer getContainerInitializer(IPath classPathEntry) {
        if (classPathEntry == null) {
            return null;
        }
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer(classPathEntry.segment(0));
        return initializer;
    }
}

