/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.codeassist.complete;

import org.eclipse.wst.jsdt.internal.codeassist.complete.CompletionNodeFound;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.ThisReference;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class CompletionOnMemberAccess
extends FieldReference {
    public boolean isInsideAnnotation;

    public CompletionOnMemberAccess(char[] source, long pos, boolean isInsideAnnotation) {
        super(source, pos);
        this.isInsideAnnotation = isInsideAnnotation;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append("<CompleteOnMemberAccess:");
        return super.printExpression(0, output).append('>');
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.receiverType = this.receiver.resolveType(scope);
        if (this.receiverType == null && this.receiver instanceof MessageSend) {
            MessageSend messageSend = (MessageSend)this.receiver;
            if (messageSend.receiver instanceof ThisReference) {
                Expression[] arguments = messageSend.arguments;
                int length = arguments == null ? 0 : arguments.length;
                TypeBinding[] argBindings = new TypeBinding[length];
                int i = 0;
                while (i < length) {
                    argBindings[i] = arguments[i].resolvedType;
                    if (argBindings[i] == null || !argBindings[i].isValidBinding()) {
                        throw new CompletionNodeFound();
                    }
                    ++i;
                }
                ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(messageSend.selector, argBindings, 1);
                throw new CompletionNodeFound((ASTNode)this, problemMethodBinding, scope);
            }
        }
        if (this.receiverType == null || this.receiverType.isBaseType()) {
            throw new CompletionNodeFound();
        }
        throw new CompletionNodeFound((ASTNode)this, this.receiverType, scope);
    }
}

