/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.flow.LoopingFlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class ForInStatement
extends Statement {
    public Statement iterationVariable;
    public Expression collection;
    public Statement action;
    public boolean neededScope;
    public BlockScope scope;
    private BranchLabel breakLabel;
    private BranchLabel continueLabel;
    int preCondInitStateIndex = -1;
    int condIfTrueInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public ForInStatement(Statement iterationVariable, Expression collection, Statement action, boolean neededScope, int s, int e) {
        this.sourceStart = s;
        this.sourceEnd = e;
        this.iterationVariable = iterationVariable;
        this.collection = collection;
        this.action = action;
        if (action instanceof EmptyStatement) {
            action.bits |= 1;
        }
        this.neededScope = neededScope;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo exitBranch;
        this.breakLabel = new BranchLabel();
        this.continueLabel = new BranchLabel();
        this.collection.checkNPE(currentScope, flowContext, flowInfo);
        flowInfo = this.iterationVariable.analyseCode(this.scope, flowContext, flowInfo);
        FlowInfo condInfo = this.collection.analyseCode(this.scope, flowContext, flowInfo.copy());
        LocalVariableBinding iterationVariableBinding = null;
        if (this.iterationVariable instanceof LocalDeclaration) {
            iterationVariableBinding = ((LocalDeclaration)this.iterationVariable).binding;
        } else if (this.iterationVariable instanceof SingleNameReference) {
            SingleNameReference singleNameReference = (SingleNameReference)this.iterationVariable;
            if (singleNameReference.binding instanceof LocalVariableBinding) {
                iterationVariableBinding = (LocalVariableBinding)singleNameReference.binding;
            }
        }
        if (iterationVariableBinding != null) {
            condInfo.markAsDefinitelyAssigned(iterationVariableBinding);
        }
        LoopingFlowContext loopingContext = new LoopingFlowContext(flowContext, flowInfo, this, this.breakLabel, this.continueLabel, this.scope);
        UnconditionalFlowInfo actionInfo = condInfo.nullInfoLessUnconditionalCopy();
        if (iterationVariableBinding != null) {
            actionInfo.markAsDefinitelyUnknown(iterationVariableBinding);
        }
        if (!(this.action == null || this.action.isEmptyBlock() && currentScope.compilerOptions().complianceLevel <= 0x2F0000L)) {
            if (!this.action.complainIfUnreachable(actionInfo, this.scope, false)) {
                actionInfo = this.action.analyseCode(this.scope, loopingContext, actionInfo).unconditionalCopy();
            }
            exitBranch = flowInfo.unconditionalCopy().addInitializationsFrom(condInfo.initsWhenFalse());
            if ((actionInfo.tagBits & loopingContext.initsOnContinue.tagBits & 1) != 0) {
                this.continueLabel = null;
            } else {
                actionInfo = actionInfo.mergedWith(loopingContext.initsOnContinue);
                loopingContext.complainOnDeferredFinalChecks(this.scope, actionInfo);
                exitBranch.addPotentialInitializationsFrom(actionInfo);
            }
        } else {
            exitBranch = condInfo.initsWhenFalse();
        }
        loopingContext.complainOnDeferredNullChecks(currentScope, actionInfo);
        UnconditionalFlowInfo mergedInfo = FlowInfo.mergedOptimizedBranches((loopingContext.initsOnBreak.tagBits & 1) != 0 ? loopingContext.initsOnBreak : flowInfo.addInitializationsFrom(loopingContext.initsOnBreak), false, exitBranch, false, true);
        return mergedInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
    }

    public StringBuffer printStatement(int tab, StringBuffer output) {
        ForInStatement.printIndent(tab, output).append("for (");
        if (this.iterationVariable != null) {
            if (this.iterationVariable instanceof AbstractVariableDeclaration) {
                AbstractVariableDeclaration variable = (AbstractVariableDeclaration)this.iterationVariable;
                variable.printAsExpression(0, output);
            } else {
                this.iterationVariable.print(0, output);
            }
        }
        output.append(" in ");
        if (this.collection != null) {
            this.collection.printExpression(0, output);
        }
        output.append(") ");
        if (this.action == null) {
            output.append(';');
        } else {
            output.append('\n');
            this.action.printStatement(tab + 1, output);
        }
        return output;
    }

    public void resolve(BlockScope upperScope) {
        BlockScope blockScope = this.scope = this.neededScope ? new BlockScope(upperScope) : upperScope;
        if (this.iterationVariable != null) {
            if (this.iterationVariable instanceof Expression) {
                Expression expression = (Expression)this.iterationVariable;
                expression.resolveType(this.scope, true, null);
            } else {
                this.iterationVariable.resolve(this.scope);
            }
        }
        if (this.collection != null) {
            TypeBinding type = this.collection.resolveTypeExpecting(this.scope, TypeBinding.BOOLEAN);
            this.collection.computeConversion(this.scope, type, type);
        }
        if (this.action != null) {
            this.action.resolve(this.scope);
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            if (this.iterationVariable != null) {
                this.iterationVariable.traverse(visitor, this.scope);
            }
            if (this.collection != null) {
                this.collection.traverse(visitor, this.scope);
            }
            if (this.action != null) {
                this.action.traverse(visitor, this.scope);
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

